/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.Iterator;
import java.util.Map;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.store.graph.v2.EntityStream;

public class InMemoryMapEntityStream
implements EntityStream {
    private final Map<String, AtlasEntity> entities;
    private Iterator<Map.Entry<String, AtlasEntity>> iterator;

    public InMemoryMapEntityStream(Map<String, AtlasEntity> entities) {
        this.entities = entities;
        this.iterator = entities.entrySet().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public AtlasEntity next() {
        return this.iterator.hasNext() ? this.iterator.next().getValue() : null;
    }

    @Override
    public void reset() {
        this.iterator = this.entities.entrySet().iterator();
    }

    @Override
    public AtlasEntity getByGuid(String guid) {
        return this.entities.get(guid);
    }
}

