/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.bulkimport;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasSchemaViolationException;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStreamForImport;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.BulkImporterImpl;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.repository.store.graph.v2.bulkimport.ImportStrategy;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegularImport
extends ImportStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RegularImport.class);
    private static final int MAX_ATTEMPTS = 3;
    private final AtlasGraph graph;
    private final AtlasEntityStore entityStore;
    private final AtlasTypeRegistry typeRegistry;
    private final EntityGraphRetriever entityGraphRetriever;
    private boolean directoryBasedImportConfigured;

    public RegularImport(AtlasGraph graph, AtlasEntityStore entityStore, AtlasTypeRegistry typeRegistry) {
        this.graph = graph;
        this.entityStore = entityStore;
        this.typeRegistry = typeRegistry;
        this.entityGraphRetriever = new EntityGraphRetriever(graph, typeRegistry);
        this.directoryBasedImportConfigured = StringUtils.isNotEmpty((String)AtlasConfiguration.IMPORT_TEMP_DIRECTORY.getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityMutationResponse run(EntityImportStream entityStream, AtlasImportResult importResult) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> bulkImport()");
        }
        if (entityStream == null || !entityStream.hasNext()) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"no entities to create/update."});
        }
        EntityMutationResponse ret = new EntityMutationResponse();
        ret.setGuidAssignments(new HashMap());
        HashSet<String> processedGuids = new HashSet<String>();
        float currentPercent = 0.0f;
        ArrayList<String> residualList = new ArrayList<String>();
        EntityImportStreamWithResidualList entityImportStreamWithResidualList = new EntityImportStreamWithResidualList(entityStream, residualList);
        block9: while (entityImportStreamWithResidualList.hasNext()) {
            AtlasEntity entity;
            AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = entityImportStreamWithResidualList.getNextEntityWithExtInfo();
            AtlasEntity atlasEntity = entity = entityWithExtInfo != null ? entityWithExtInfo.getEntity() : null;
            if (entity == null) continue;
            for (int attempt = 0; attempt < 3; ++attempt) {
                try {
                    AtlasEntityStreamForImport oneEntityStream = new AtlasEntityStreamForImport(entityWithExtInfo, null);
                    EntityMutationResponse resp = this.entityStore.createOrUpdateForImport(oneEntityStream);
                    if (resp.getGuidAssignments() != null) {
                        ret.getGuidAssignments().putAll(resp.getGuidAssignments());
                    }
                    currentPercent = this.updateImportMetrics(entityWithExtInfo, resp, importResult, processedGuids, entityStream.getPosition(), entityImportStreamWithResidualList.getStreamSize(), currentPercent);
                    entityStream.onImportComplete(entity.getGuid());
                    continue block9;
                }
                catch (AtlasBaseException e) {
                    if (this.updateResidualList(e, residualList, entityWithExtInfo.getEntity().getGuid())) continue block9;
                    throw e;
                }
                catch (AtlasSchemaViolationException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Entity: {}", (Object)entity.getGuid(), (Object)e);
                    }
                    if (attempt == 0) {
                        this.updateVertexGuid(entityWithExtInfo);
                        continue;
                    }
                    LOG.error("Guid update failed: {}", (Object)entityWithExtInfo.getEntity().getGuid());
                    throw e;
                }
                catch (Throwable e) {
                    AtlasBaseException abe = new AtlasBaseException(e);
                    if (!this.updateResidualList(abe, residualList, entityWithExtInfo.getEntity().getGuid())) {
                        throw abe;
                    }
                    LOG.warn("Exception: {}", (Object)entity.getGuid(), (Object)e);
                    continue block9;
                }
                finally {
                    RequestContext.get().clearCache();
                    continue block9;
                }
            }
        }
        importResult.getProcessedEntities().addAll(processedGuids);
        LOG.info("bulkImport(): done. Total number of entities (including referred entities) imported: {}", (Object)processedGuids.size());
        return ret;
    }

    @GraphTransaction
    public void updateVertexGuid(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        this.updateVertexGuid(entityWithExtInfo.getEntity());
        if (MapUtils.isEmpty((Map)entityWithExtInfo.getReferredEntities())) {
            return;
        }
        for (AtlasEntity entity : entityWithExtInfo.getReferredEntities().values()) {
            this.updateVertexGuid(entity);
        }
    }

    public void updateVertexGuid(AtlasEntity entity) {
        String entityGuid = entity.getGuid();
        AtlasObjectId objectId = this.entityGraphRetriever.toAtlasObjectIdWithoutGuid(entity);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entity.getTypeName());
        String vertexGuid = null;
        try {
            vertexGuid = AtlasGraphUtilsV2.getGuidByUniqueAttributes(this.graph, entityType, objectId.getUniqueAttributes());
        }
        catch (AtlasBaseException e) {
            LOG.warn("Entity: {}: Does not exist!", (Object)objectId);
            return;
        }
        if (StringUtils.isEmpty((String)vertexGuid) || vertexGuid.equals(entityGuid)) {
            return;
        }
        AtlasVertex v = AtlasGraphUtilsV2.findByGuid(this.graph, vertexGuid);
        if (v == null) {
            return;
        }
        this.addHistoricalGuid(v, vertexGuid);
        AtlasGraphUtilsV2.setProperty(v, Constants.GUID_PROPERTY_KEY, entityGuid);
        LOG.warn("GUID Updated: Entity: {}: from: {}: to: {}", new Object[]{objectId, vertexGuid, entity.getGuid()});
    }

    private void addHistoricalGuid(AtlasVertex v, String vertexGuid) {
        String existingJson = AtlasGraphUtilsV2.getProperty(v, Constants.HISTORICAL_GUID_PROPERTY_KEY, String.class);
        AtlasGraphUtilsV2.setProperty(v, Constants.HISTORICAL_GUID_PROPERTY_KEY, RegularImport.getJsonArray(existingJson, vertexGuid));
    }

    @VisibleForTesting
    static String getJsonArray(String json, String vertexGuid) {
        String quotedGuid = String.format("\"%s\"", vertexGuid);
        json = StringUtils.isEmpty((String)json) ? String.format("[%s]", quotedGuid) : json.replace("]", "").concat(",").concat(quotedGuid).concat("]");
        return json;
    }

    private boolean updateResidualList(AtlasBaseException e, List<String> lineageList, String guid) {
        if (!e.getAtlasErrorCode().getErrorCode().equals(AtlasErrorCode.INVALID_OBJECT_ID.getErrorCode())) {
            return false;
        }
        lineageList.add(guid);
        return true;
    }

    private float updateImportMetrics(AtlasEntity.AtlasEntityWithExtInfo currentEntity, EntityMutationResponse resp, AtlasImportResult importResult, Set<String> processedGuids, int currentIndex, int streamSize, float currentPercent) {
        if (!this.directoryBasedImportConfigured) {
            BulkImporterImpl.updateImportMetrics("entity:%s:created", resp.getCreatedEntities(), processedGuids, importResult);
            BulkImporterImpl.updateImportMetrics("entity:%s:updated", resp.getUpdatedEntities(), processedGuids, importResult);
            BulkImporterImpl.updateImportMetrics("entity:%s:deleted", resp.getDeletedEntities(), processedGuids, importResult);
        }
        String lastEntityImported = String.format("entity:last-imported:%s:[%s]:(%s)", currentEntity.getEntity().getTypeName(), currentIndex, currentEntity.getEntity().getGuid());
        return BulkImporterImpl.updateImportProgress(LOG, currentIndex, streamSize, currentPercent, lastEntityImported);
    }

    private static class EntityImportStreamWithResidualList {
        private final EntityImportStream stream;
        private final List<String> residualList;
        private boolean navigateResidualList;
        private int currentResidualListIndex;

        public EntityImportStreamWithResidualList(EntityImportStream stream, List<String> residualList) {
            this.stream = stream;
            this.residualList = residualList;
            this.navigateResidualList = false;
            this.currentResidualListIndex = 0;
        }

        public AtlasEntity.AtlasEntityWithExtInfo getNextEntityWithExtInfo() {
            if (!this.navigateResidualList) {
                return this.stream.getNextEntityWithExtInfo();
            }
            this.stream.setPositionUsingEntityGuid(this.residualList.get(this.currentResidualListIndex++));
            return this.stream.getNextEntityWithExtInfo();
        }

        public boolean hasNext() {
            if (!this.navigateResidualList) {
                boolean streamHasNext = this.stream.hasNext();
                boolean bl = this.navigateResidualList = !streamHasNext;
                return streamHasNext ? streamHasNext : this.currentResidualListIndex < this.residualList.size();
            }
            return this.currentResidualListIndex < this.residualList.size();
        }

        public int getStreamSize() {
            return this.stream.size() + this.residualList.size();
        }
    }
}

