/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.lang.StringUtils;

public class FilterUtil {
    public static Predicate getPredicateFromSearchFilter(SearchFilter searchFilter) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        String type = searchFilter.getParam("type");
        String name = searchFilter.getParam("name");
        String supertype = searchFilter.getParam("supertype");
        String serviceType = searchFilter.getParam("servicetype");
        String notSupertype = searchFilter.getParam("notsupertype");
        String notServiceType = searchFilter.getParam("notservicetype");
        List notNames = searchFilter.getParams("notname");
        if (StringUtils.isNotBlank((String)type)) {
            predicates.add(FilterUtil.getTypePredicate(type));
        }
        if (StringUtils.isNotBlank((String)name)) {
            predicates.add(FilterUtil.getNamePredicate(name));
        }
        if (StringUtils.isNotBlank((String)serviceType)) {
            predicates.add(FilterUtil.getServiceTypePredicate(serviceType));
        }
        if (StringUtils.isNotBlank((String)supertype)) {
            predicates.add(FilterUtil.getSuperTypePredicate(supertype));
        }
        if (StringUtils.isNotBlank((String)notSupertype)) {
            predicates.add(new NotPredicate(FilterUtil.getSuperTypePredicate(notSupertype)));
        }
        if (StringUtils.isNotBlank((String)notServiceType)) {
            predicates.add(new NotPredicate(FilterUtil.getServiceTypePredicate(notServiceType)));
        }
        if (CollectionUtils.isNotEmpty((Collection)notNames)) {
            for (String notName : notNames) {
                predicates.add(new NotPredicate(FilterUtil.getNamePredicate(notName)));
            }
        }
        return PredicateUtils.allPredicate(predicates);
    }

    private static Predicate getNamePredicate(final String name) {
        return new Predicate(){

            private boolean isAtlasType(Object o) {
                return o instanceof AtlasType;
            }

            public boolean evaluate(Object o) {
                return o != null && this.isAtlasType(o) && Objects.equals(((AtlasType)o).getTypeName(), name);
            }
        };
    }

    private static Predicate getServiceTypePredicate(final String serviceType) {
        return new Predicate(){

            private boolean isAtlasType(Object o) {
                return o instanceof AtlasType;
            }

            public boolean evaluate(Object o) {
                return this.isAtlasType(o) && Objects.equals(((AtlasType)o).getServiceType(), serviceType);
            }
        };
    }

    private static Predicate getSuperTypePredicate(final String supertype) {
        return new Predicate(){

            private boolean isClassificationType(Object o) {
                return o instanceof AtlasClassificationType;
            }

            private boolean isEntityType(Object o) {
                return o instanceof AtlasEntityType;
            }

            public boolean evaluate(Object o) {
                return this.isClassificationType(o) && ((AtlasClassificationType)o).getAllSuperTypes().contains(supertype) || this.isEntityType(o) && ((AtlasEntityType)o).getAllSuperTypes().contains(supertype);
            }
        };
    }

    private static Predicate getTypePredicate(final String type) {
        return new Predicate(){

            public boolean evaluate(Object o) {
                if (o instanceof AtlasType) {
                    AtlasType atlasType = (AtlasType)o;
                    switch (type.toUpperCase()) {
                        case "CLASS": 
                        case "ENTITY": {
                            return atlasType.getTypeCategory() == TypeCategory.ENTITY;
                        }
                        case "TRAIT": 
                        case "CLASSIFICATION": {
                            return atlasType.getTypeCategory() == TypeCategory.CLASSIFICATION;
                        }
                        case "STRUCT": {
                            return atlasType.getTypeCategory() == TypeCategory.STRUCT;
                        }
                        case "ENUM": {
                            return atlasType.getTypeCategory() == TypeCategory.ENUM;
                        }
                        case "RELATIONSHIP": {
                            return atlasType.getTypeCategory() == TypeCategory.RELATIONSHIP;
                        }
                        case "BUSINESS_METADATA": {
                            return atlasType.getTypeCategory() == TypeCategory.BUSINESS_METADATA;
                        }
                    }
                    return false;
                }
                return false;
            }
        };
    }

    public static void addParamsToHideInternalType(SearchFilter searchFilter) {
        searchFilter.setParam("notname", "__internal");
        searchFilter.setParam("notsupertype", "__internal");
    }
}

