/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.tasks;

import org.apache.atlas.model.tasks.AtlasTask;

public abstract class AbstractTask {
    private final AtlasTask task;

    public AbstractTask(AtlasTask task) {
        this.task = task;
    }

    public void run() throws Exception {
        try {
            this.perform();
        }
        catch (Exception exception) {
            this.task.setStatusPending();
            this.task.setErrorMessage(exception.getMessage());
            this.task.incrementAttemptCount();
            throw exception;
        }
        finally {
            this.task.end();
        }
    }

    protected void setStatus(AtlasTask.Status status) {
        this.task.setStatus(status);
    }

    public AtlasTask.Status getStatus() {
        return this.task.getStatus();
    }

    public String getTaskGuid() {
        return this.task.getGuid();
    }

    public String getTaskType() {
        return this.task.getType();
    }

    protected AtlasTask getTaskDef() {
        return this.task;
    }

    public abstract AtlasTask.Status perform() throws Exception;
}

