/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasClient;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.atlas.v1.model.instance.Id;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.typedef.AttributeDefinition;
import org.apache.atlas.v1.model.typedef.ClassTypeDefinition;
import org.apache.atlas.v1.model.typedef.Multiplicity;
import org.apache.atlas.v1.model.typedef.TraitTypeDefinition;
import org.apache.atlas.v1.model.typedef.TypesDef;
import org.apache.atlas.v1.typesystem.types.utils.TypesUtil;
import org.apache.commons.configuration.Configuration;

public class QuickStart {
    public static final String ATLAS_REST_ADDRESS = "atlas.rest.address";
    public static final String SALES_DB = "Sales";
    public static final String SALES_DB_DESCRIPTION = "Sales Database";
    public static final String SALES_FACT_TABLE = "sales_fact";
    public static final String FACT_TRAIT = "Fact_v1";
    public static final String COLUMNS_ATTRIBUTE = "columns";
    public static final String TIME_ID_COLUMN = "time_id";
    public static final String DB_ATTRIBUTE = "db";
    public static final String SALES_FACT_TABLE_DESCRIPTION = "sales fact table";
    public static final String LOAD_SALES_DAILY_PROCESS = "loadSalesDaily";
    public static final String LOAD_SALES_DAILY_PROCESS_DESCRIPTION = "hive query for daily summary";
    public static final String INPUTS_ATTRIBUTE = "inputs";
    public static final String OUTPUTS_ATTRIBUTE = "outputs";
    public static final String TIME_DIM_TABLE = "time_dim";
    public static final String SALES_FACT_DAILY_MV_TABLE = "sales_fact_daily_mv";
    public static final String PRODUCT_DIM_VIEW = "product_dim_view";
    public static final String PRODUCT_DIM_TABLE = "product_dim";
    public static final String INPUT_TABLES_ATTRIBUTE = "inputTables";
    static final String DATABASE_TYPE = "DB_v1";
    static final String COLUMN_TYPE = "Column_v1";
    static final String TABLE_TYPE = "Table_v1";
    static final String VIEW_TYPE = "View_v1";
    static final String LOAD_PROCESS_TYPE = "LoadProcess_v1";
    static final String STORAGE_DESC_TYPE = "StorageDesc_v1";
    private static final String[] TYPES = new String[]{"DB_v1", "Table_v1", "StorageDesc_v1", "Column_v1", "LoadProcess_v1", "View_v1", "JdbcAccess_v1", "ETL_v1", "Metric_v1", "PII_v1", "Fact_v1", "Dimension_v1", "Log Data_v1"};
    private final AtlasClient metadataServiceClient;

    public static void main(String[] args) throws Exception {
        String[] basicAuthUsernamePassword = null;
        if (!AuthenticationUtil.isKerberosAuthenticationEnabled()) {
            basicAuthUsernamePassword = AuthenticationUtil.getBasicAuthenticationInput();
        }
        QuickStart.runQuickstart(args, basicAuthUsernamePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void runQuickstart(String[] args, String[] basicAuthUsernamePassword) throws Exception {
        String[] urls = QuickStart.getServerUrl(args);
        QuickStart quickStart = null;
        try {
            quickStart = !AuthenticationUtil.isKerberosAuthenticationEnabled() ? new QuickStart(urls, basicAuthUsernamePassword) : new QuickStart(urls);
            quickStart.createTypes();
            quickStart.createEntities();
            quickStart.search();
            if (quickStart != null) {
                quickStart.closeConnection();
            }
        }
        catch (Throwable throwable) {
            if (quickStart != null) {
                super.closeConnection();
            }
            throw throwable;
        }
    }

    static String[] getServerUrl(String[] args) throws AtlasException {
        if (args.length > 0) {
            return args[0].split(",");
        }
        Configuration configuration = ApplicationProperties.get();
        String[] urls = configuration.getStringArray(ATLAS_REST_ADDRESS);
        if (urls == null || urls.length == 0) {
            System.out.println("Usage: quick_start_v1.py <atlas endpoint of format <http/https>://<atlas-fqdn>:<atlas port> like http://localhost:21000>");
            System.exit(-1);
        }
        return urls;
    }

    QuickStart(String[] urls, String[] basicAuthUsernamePassword) {
        this.metadataServiceClient = new AtlasClient(urls, basicAuthUsernamePassword);
    }

    QuickStart(String[] urls) throws AtlasException {
        this.metadataServiceClient = new AtlasClient(urls);
    }

    void createTypes() throws Exception {
        TypesDef typesDef = this.createTypeDefinitions();
        String typesAsJSON = AtlasType.toV1Json((Object)typesDef);
        System.out.println("typesAsJSON = " + typesAsJSON);
        this.metadataServiceClient.createType(typesAsJSON);
        this.verifyTypesCreated();
    }

    TypesDef createTypeDefinitions() throws Exception {
        ClassTypeDefinition dbClsDef = TypesUtil.createClassTypeDef((String)DATABASE_TYPE, (String)DATABASE_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createUniqueRequiredAttrDef((String)"name", (String)"string"), this.attrDef("description", "string"), this.attrDef("locationUri", "string"), this.attrDef("owner", "string"), this.attrDef("createTime", "long")});
        ClassTypeDefinition storageDescClsDef = TypesUtil.createClassTypeDef((String)STORAGE_DESC_TYPE, (String)STORAGE_DESC_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("location", "string"), this.attrDef("inputFormat", "string"), this.attrDef("outputFormat", "string"), this.attrDef("compressed", "string", Multiplicity.REQUIRED, false, null)});
        ClassTypeDefinition columnClsDef = TypesUtil.createClassTypeDef((String)COLUMN_TYPE, (String)COLUMN_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("name", "string"), this.attrDef("dataType", "string"), this.attrDef("comment", "string")});
        ClassTypeDefinition tblClsDef = TypesUtil.createClassTypeDef((String)TABLE_TYPE, (String)TABLE_TYPE, Collections.singleton("DataSet"), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition(DB_ATTRIBUTE, DATABASE_TYPE, Multiplicity.REQUIRED, false, null), new AttributeDefinition("sd", STORAGE_DESC_TYPE, Multiplicity.REQUIRED, true, null), this.attrDef("createTime", "long"), this.attrDef("lastAccessTime", "long"), this.attrDef("retention", "long"), this.attrDef("viewOriginalText", "string"), this.attrDef("viewExpandedText", "string"), this.attrDef("tableType", "string"), this.attrDef("temporary", "boolean"), new AttributeDefinition(COLUMNS_ATTRIBUTE, AtlasBaseTypeDef.getArrayTypeName((String)COLUMN_TYPE), Multiplicity.COLLECTION, true, null)});
        ClassTypeDefinition loadProcessClsDef = TypesUtil.createClassTypeDef((String)LOAD_PROCESS_TYPE, (String)LOAD_PROCESS_TYPE, Collections.singleton("Process"), (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("userName", "string"), this.attrDef("startTime", "long"), this.attrDef("endTime", "long"), this.attrDef("queryText", "string", Multiplicity.REQUIRED), this.attrDef("queryPlan", "string", Multiplicity.REQUIRED), this.attrDef("queryId", "string", Multiplicity.REQUIRED), this.attrDef("queryGraph", "string", Multiplicity.REQUIRED)});
        ClassTypeDefinition viewClsDef = TypesUtil.createClassTypeDef((String)VIEW_TYPE, (String)VIEW_TYPE, Collections.singleton("DataSet"), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition(DB_ATTRIBUTE, DATABASE_TYPE, Multiplicity.REQUIRED, false, null), new AttributeDefinition(INPUT_TABLES_ATTRIBUTE, AtlasBaseTypeDef.getArrayTypeName((String)TABLE_TYPE), Multiplicity.COLLECTION, false, null)});
        TraitTypeDefinition dimTraitDef = TypesUtil.createTraitTypeDef((String)"Dimension_v1", (String)"Dimension Trait", null, (AttributeDefinition[])new AttributeDefinition[0]);
        TraitTypeDefinition factTraitDef = TypesUtil.createTraitTypeDef((String)FACT_TRAIT, (String)"Fact Trait", null, (AttributeDefinition[])new AttributeDefinition[0]);
        TraitTypeDefinition piiTraitDef = TypesUtil.createTraitTypeDef((String)"PII_v1", (String)"PII Trait", null, (AttributeDefinition[])new AttributeDefinition[0]);
        TraitTypeDefinition metricTraitDef = TypesUtil.createTraitTypeDef((String)"Metric_v1", (String)"Metric Trait", null, (AttributeDefinition[])new AttributeDefinition[0]);
        TraitTypeDefinition etlTraitDef = TypesUtil.createTraitTypeDef((String)"ETL_v1", (String)"ETL Trait", null, (AttributeDefinition[])new AttributeDefinition[0]);
        TraitTypeDefinition jdbcTraitDef = TypesUtil.createTraitTypeDef((String)"JdbcAccess_v1", (String)"JdbcAccess Trait", null, (AttributeDefinition[])new AttributeDefinition[0]);
        TraitTypeDefinition logTraitDef = TypesUtil.createTraitTypeDef((String)"Log Data_v1", (String)"LogData Trait", null, (AttributeDefinition[])new AttributeDefinition[0]);
        return new TypesDef(Collections.emptyList(), Collections.emptyList(), Arrays.asList(dimTraitDef, factTraitDef, piiTraitDef, metricTraitDef, etlTraitDef, jdbcTraitDef, logTraitDef), Arrays.asList(dbClsDef, storageDescClsDef, columnClsDef, tblClsDef, loadProcessClsDef, viewClsDef));
    }

    AttributeDefinition attrDef(String name, String dT) {
        return this.attrDef(name, dT, Multiplicity.OPTIONAL, false, null);
    }

    AttributeDefinition attrDef(String name, String dT, Multiplicity m) {
        return this.attrDef(name, dT, m, false, null);
    }

    AttributeDefinition attrDef(String name, String dT, Multiplicity m, boolean isComposite, String reverseAttributeName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)dT);
        return new AttributeDefinition(name, dT, m, isComposite, reverseAttributeName);
    }

    void createEntities() throws Exception {
        Id salesDB = this.database(SALES_DB, SALES_DB_DESCRIPTION, "John ETL", "hdfs://host:8000/apps/warehouse/sales", new String[0]);
        Referenceable sd = this.rawStorageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true);
        List<Referenceable> salesFactColumns = Arrays.asList(this.rawColumn(TIME_ID_COLUMN, "int", "time id", new String[0]), this.rawColumn("product_id", "int", "product id", new String[0]), this.rawColumn("customer_id", "int", "customer id", "PII_v1"), this.rawColumn("sales", "double", "product id", "Metric_v1"));
        List<Referenceable> logFactColumns = Arrays.asList(this.rawColumn(TIME_ID_COLUMN, "int", "time id", new String[0]), this.rawColumn("app_id", "int", "app id", new String[0]), this.rawColumn("machine_id", "int", "machine id", new String[0]), this.rawColumn("log", "string", "log data", "Log Data_v1"));
        Id salesFact = this.table(SALES_FACT_TABLE, SALES_FACT_TABLE_DESCRIPTION, salesDB, sd, "Joe", "Managed", salesFactColumns, FACT_TRAIT);
        List<Referenceable> productDimColumns = Arrays.asList(this.rawColumn("product_id", "int", "product id", new String[0]), this.rawColumn("product_name", "string", "product name", new String[0]), this.rawColumn("brand_name", "int", "brand name", new String[0]));
        Id productDim = this.table(PRODUCT_DIM_TABLE, "product dimension table", salesDB, sd, "John Doe", "Managed", productDimColumns, "Dimension_v1");
        List<Referenceable> timeDimColumns = Arrays.asList(this.rawColumn(TIME_ID_COLUMN, "int", "time id", new String[0]), this.rawColumn("dayOfYear", "int", "day Of Year", new String[0]), this.rawColumn("weekDay", "int", "week Day", new String[0]));
        Id timeDim = this.table(TIME_DIM_TABLE, "time dimension table", salesDB, sd, "John Doe", "External", timeDimColumns, "Dimension_v1");
        List<Referenceable> customerDimColumns = Arrays.asList(this.rawColumn("customer_id", "int", "customer id", "PII_v1"), this.rawColumn("name", "string", "customer name", "PII_v1"), this.rawColumn("address", "string", "customer address", "PII_v1"));
        Id customerDim = this.table("customer_dim", "customer dimension table", salesDB, sd, "fetl", "External", customerDimColumns, "Dimension_v1");
        Id reportingDB = this.database("Reporting", "reporting database", "Jane BI", "hdfs://host:8000/apps/warehouse/reporting", new String[0]);
        Id logDB = this.database("Logging", "logging database", "Tim ETL", "hdfs://host:8000/apps/warehouse/logging", new String[0]);
        Id salesFactDaily = this.table(SALES_FACT_DAILY_MV_TABLE, "sales fact daily materialized view", reportingDB, sd, "Joe BI", "Managed", salesFactColumns, "Metric_v1");
        Id loggingFactDaily = this.table("log_fact_daily_mv", "log fact daily materialized view", logDB, sd, "Tim ETL", "Managed", logFactColumns, "Log Data_v1");
        this.loadProcess(LOAD_SALES_DAILY_PROCESS, LOAD_SALES_DAILY_PROCESS_DESCRIPTION, "John ETL", Arrays.asList(salesFact, timeDim), Collections.singletonList(salesFactDaily), "create table as select ", "plan", "id", "graph", "ETL_v1");
        this.view(PRODUCT_DIM_VIEW, reportingDB, Collections.singletonList(productDim), "Dimension_v1", "JdbcAccess_v1");
        this.view("customer_dim_view", reportingDB, Collections.singletonList(customerDim), "Dimension_v1", "JdbcAccess_v1");
        Id salesFactMonthly = this.table("sales_fact_monthly_mv", "sales fact monthly materialized view", reportingDB, sd, "Jane BI", "Managed", salesFactColumns, "Metric_v1");
        this.loadProcess("loadSalesMonthly", "hive query for monthly summary", "John ETL", Collections.singletonList(salesFactDaily), Collections.singletonList(salesFactMonthly), "create table as select ", "plan", "id", "graph", "ETL_v1");
        Id loggingFactMonthly = this.table("logging_fact_monthly_mv", "logging fact monthly materialized view", logDB, sd, "Tim ETL", "Managed", logFactColumns, "Log Data_v1");
        this.loadProcess("loadLogsMonthly", "hive query for monthly summary", "Tim ETL", Collections.singletonList(loggingFactDaily), Collections.singletonList(loggingFactMonthly), "create table as select ", "plan", "id", "graph", "ETL_v1");
    }

    private Id createInstance(Referenceable referenceable) throws Exception {
        String typeName = referenceable.getTypeName();
        String entityJSON = AtlasType.toV1Json((Object)referenceable);
        System.out.println("Submitting new entity= " + entityJSON);
        List guids = this.metadataServiceClient.createEntity(new String[]{entityJSON});
        System.out.println("created instance for type " + typeName + ", guid: " + guids);
        if (guids.size() > 0) {
            return new Id((String)guids.get(guids.size() - 1), referenceable.getId().getVersion(), referenceable.getTypeName());
        }
        return null;
    }

    Id database(String name, String description, String owner, String locationUri, String ... traitNames) throws AtlasBaseException {
        try {
            Referenceable referenceable = new Referenceable(DATABASE_TYPE, traitNames);
            referenceable.set("name", (Object)name);
            referenceable.set("description", (Object)description);
            referenceable.set("owner", (Object)owner);
            referenceable.set("locationUri", (Object)locationUri);
            referenceable.set("createTime", (Object)System.currentTimeMillis());
            return this.createInstance(referenceable);
        }
        catch (Exception e) {
            throw new AtlasBaseException(AtlasErrorCode.QUICK_START, (Throwable)e, new String[]{String.format("%s database entity creation failed", name)});
        }
    }

    Referenceable rawStorageDescriptor(String location, String inputFormat, String outputFormat, boolean compressed) {
        Referenceable referenceable = new Referenceable(STORAGE_DESC_TYPE, new String[0]);
        referenceable.set("location", (Object)location);
        referenceable.set("inputFormat", (Object)inputFormat);
        referenceable.set("outputFormat", (Object)outputFormat);
        referenceable.set("compressed", (Object)compressed);
        return referenceable;
    }

    Referenceable rawColumn(String name, String dataType, String comment, String ... traitNames) throws AtlasBaseException {
        try {
            Referenceable referenceable = new Referenceable(COLUMN_TYPE, traitNames);
            referenceable.set("name", (Object)name);
            referenceable.set("dataType", (Object)dataType);
            referenceable.set("comment", (Object)comment);
            return referenceable;
        }
        catch (Exception e) {
            throw new AtlasBaseException(AtlasErrorCode.QUICK_START, (Throwable)e, new String[]{String.format("%s, column entity creation failed", name)});
        }
    }

    Id table(String name, String description, Id dbId, Referenceable sd, String owner, String tableType, List<Referenceable> columns, String ... traitNames) throws AtlasBaseException {
        try {
            Referenceable referenceable = new Referenceable(TABLE_TYPE, traitNames);
            referenceable.set("name", (Object)name);
            referenceable.set("qualifiedName", (Object)name);
            referenceable.set("description", (Object)description);
            referenceable.set("owner", (Object)owner);
            referenceable.set("tableType", (Object)tableType);
            referenceable.set("createTime", (Object)System.currentTimeMillis());
            referenceable.set("lastAccessTime", (Object)System.currentTimeMillis());
            referenceable.set("retention", (Object)System.currentTimeMillis());
            referenceable.set(DB_ATTRIBUTE, (Object)dbId);
            referenceable.set("sd", (Object)sd);
            referenceable.set(COLUMNS_ATTRIBUTE, columns);
            return this.createInstance(referenceable);
        }
        catch (Exception e) {
            throw new AtlasBaseException(AtlasErrorCode.QUICK_START, (Throwable)e, new String[]{String.format("%s table entity creation failed", name)});
        }
    }

    Id loadProcess(String name, String description, String user, List<Id> inputTables, List<Id> outputTables, String queryText, String queryPlan, String queryId, String queryGraph, String ... traitNames) throws AtlasBaseException {
        try {
            Referenceable referenceable = new Referenceable(LOAD_PROCESS_TYPE, traitNames);
            referenceable.set("name", (Object)name);
            referenceable.set("qualifiedName", (Object)name);
            referenceable.set("description", (Object)description);
            referenceable.set(INPUTS_ATTRIBUTE, inputTables);
            referenceable.set(OUTPUTS_ATTRIBUTE, outputTables);
            referenceable.set("user", (Object)user);
            referenceable.set("startTime", (Object)System.currentTimeMillis());
            referenceable.set("endTime", (Object)(System.currentTimeMillis() + 10000L));
            referenceable.set("queryText", (Object)queryText);
            referenceable.set("queryPlan", (Object)queryPlan);
            referenceable.set("queryId", (Object)queryId);
            referenceable.set("queryGraph", (Object)queryGraph);
            return this.createInstance(referenceable);
        }
        catch (Exception e) {
            throw new AtlasBaseException(AtlasErrorCode.QUICK_START, (Throwable)e, new String[]{String.format("%s process entity creation failed", name)});
        }
    }

    Id view(String name, Id dbId, List<Id> inputTables, String ... traitNames) throws AtlasBaseException {
        try {
            Referenceable referenceable = new Referenceable(VIEW_TYPE, traitNames);
            referenceable.set("name", (Object)name);
            referenceable.set("qualifiedName", (Object)name);
            referenceable.set(DB_ATTRIBUTE, (Object)dbId);
            referenceable.set(INPUT_TABLES_ATTRIBUTE, inputTables);
            return this.createInstance(referenceable);
        }
        catch (Exception e) {
            throw new AtlasBaseException(AtlasErrorCode.QUICK_START, (Throwable)e, new String[]{String.format("%s Id creation", name)});
        }
    }

    private void verifyTypesCreated() throws AtlasBaseException {
        try {
            List types = this.metadataServiceClient.listTypes();
            for (String type : TYPES) {
                assert (types.contains(type));
            }
        }
        catch (Exception e) {
            throw new AtlasBaseException(AtlasErrorCode.QUICK_START, (Throwable)e, new String[]{"view creation failed."});
        }
    }

    private String[] getDSLQueries() {
        return new String[]{"from DB_v1", DATABASE_TYPE, "DB_v1 where name=\"Reporting\"", "DB_v1 where DB_v1.name=\"Reporting\"", "DB_v1 name = \"Reporting\"", "DB_v1 DB_v1.name = \"Reporting\"", "DB_v1 where name=\"Reporting\" select name, owner", "DB_v1 where DB_v1.name=\"Reporting\" select name, owner", "DB_v1 has name", "DB_v1 where DB_v1 has name", "DB_v1 is JdbcAccess", "from Table_v1", TABLE_TYPE, "Table_v1 is Dimension_v1", "Column_v1 where Column_v1 isa PII_v1", "View_v1 is Dimension_v1", "Column_v1 select Column_v1.name", "Column_v1 select name", "Column_v1 where Column_v1.name=\"customer_id\"", "from Table_v1 select Table_v1.name", "DB_v1 where (name = \"Reporting\")", "DB_v1 where (name = \"Reporting\") select name as _col_0, owner as _col_1", "DB_v1 where DB_v1 is JdbcAccess_v1", "DB_v1 where DB_v1 has name", "DB_v1 Table_v1", "DB_v1 where DB_v1 has name", "DB_v1 as db1 Table where (db1.name = \"Reporting\")", "DB_v1 where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 ", "Dimension_v1", "JdbcAccess_v1", "ETL_v1", "Metric_v1", "PII_v1", "`Log Data_v1`", "Table_v1 where name=\"sales_fact\", columns", "Table_v1 where name=\"sales_fact\", columns as column select column.name, column.dataType, column.comment", "from DataSet", "from Process"};
    }

    private void search() throws AtlasBaseException {
        try {
            for (String dslQuery : this.getDSLQueries()) {
                JsonNode results = this.metadataServiceClient.search(dslQuery, 10, 0);
                if (results != null && results instanceof ArrayNode) {
                    System.out.println("query [" + dslQuery + "] returned [" + results.size() + "] rows");
                    continue;
                }
                System.out.println("query [" + dslQuery + "] failed, results:" + results);
            }
        }
        catch (Exception e) {
            throw new AtlasBaseException(AtlasErrorCode.QUICK_START, (Throwable)e, new String[]{"one or more dsl queries failed"});
        }
    }

    private void closeConnection() {
        if (this.metadataServiceClient != null) {
            this.metadataServiceClient.close();
        }
    }
}

