/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.errors;

import java.util.LinkedHashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.web.errors.ExceptionMapperUtil;
import org.springframework.stereotype.Component;

@Provider
@Component
public class AtlasBaseExceptionMapper
implements ExceptionMapper<AtlasBaseException> {
    public Response toResponse(AtlasBaseException exception) {
        long id = ThreadLocalRandom.current().nextLong();
        if (exception.getAtlasErrorCode().getHttpCode() == Response.Status.INTERNAL_SERVER_ERROR) {
            ExceptionMapperUtil.logException(id, (Exception)((Object)exception));
        }
        return this.buildAtlasBaseExceptionResponse(exception);
    }

    protected Response buildAtlasBaseExceptionResponse(AtlasBaseException baseException) {
        LinkedHashMap<String, String> errorJsonMap = new LinkedHashMap<String, String>();
        AtlasErrorCode errorCode = baseException.getAtlasErrorCode();
        errorJsonMap.put("errorCode", errorCode.getErrorCode());
        errorJsonMap.put("errorMessage", baseException.getMessage());
        if (baseException.getCause() != null) {
            errorJsonMap.put("errorCause", baseException.getCause().getMessage());
        }
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)errorCode.getHttpCode());
        if (Response.Status.NO_CONTENT != errorCode.getHttpCode()) {
            responseBuilder.entity((Object)AtlasType.toJson(errorJsonMap));
        }
        return responseBuilder.build();
    }
}

