/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.atlas.web.service.ActiveInstanceState;
import org.apache.atlas.web.service.ServiceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@Component
public class ActiveServerFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveServerFilter.class);
    private static final String MIGRATION_STATUS_STATIC_PAGE = "migration-status.html";
    private final ActiveInstanceState activeInstanceState;
    private ServiceState serviceState;
    final String[] adminUriNotFiltered = new String[]{"/admin/export", "/admin/import", "/admin/importfile", "/admin/audits", "/admin/purge", "/admin/expimp/audit", "/admin/metrics", "/admin/server", "/admin/audit/", "admin/tasks"};

    @Inject
    public ActiveServerFilter(ActiveInstanceState activeInstanceState, ServiceState serviceState) {
        this.activeInstanceState = activeInstanceState;
        this.serviceState = serviceState;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("ActiveServerFilter initialized");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isFilteredURI(servletRequest)) {
            LOG.debug("Is a filtered URI: {}. Passing request downstream.", (Object)((HttpServletRequest)servletRequest).getRequestURI());
            filterChain.doFilter(servletRequest, servletResponse);
        } else if (this.isInstanceActive()) {
            LOG.debug("Active. Passing request downstream");
            filterChain.doFilter(servletRequest, servletResponse);
        } else if (this.serviceState.isInstanceInTransition()) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            LOG.error("Instance in transition. Service may not be ready to return a result");
            httpServletResponse.sendError(503);
        } else if (this.serviceState.isInstanceInMigration()) {
            if (this.isRootURI(servletRequest)) {
                this.handleMigrationRedirect(servletRequest, servletResponse);
            }
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            LOG.error("Instance in migration. Service may not be ready to return a result");
            httpServletResponse.sendError(503);
        } else {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            String activeServerAddress = this.activeInstanceState.getActiveServerAddress();
            if (activeServerAddress == null) {
                LOG.error("Could not retrieve active server address as it is null. Cannot redirect request {}", (Object)((HttpServletRequest)servletRequest).getRequestURI());
                httpServletResponse.sendError(503);
            } else {
                this.handleRedirect((HttpServletRequest)servletRequest, httpServletResponse, activeServerAddress);
            }
        }
    }

    private boolean isFilteredURI(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String requestURI = httpServletRequest.getRequestURI();
        if (requestURI.contains("/admin/")) {
            for (String s : this.adminUriNotFiltered) {
                if (!requestURI.contains(s)) continue;
                LOG.error("URL not supported in HA mode: {}", (Object)requestURI);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isRootURI(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String requestURI = httpServletRequest.getRequestURI();
        return requestURI.equals("/");
    }

    boolean isInstanceActive() {
        return this.serviceState.getState() == ServiceState.ServiceStateValue.ACTIVE;
    }

    private void handleMigrationRedirect(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String redirectLocation = httpServletRequest.getRequestURL() + MIGRATION_STATUS_STATIC_PAGE;
        if (this.isUnsafeHttpMethod(httpServletRequest)) {
            httpServletResponse.setHeader("Location", redirectLocation);
            httpServletResponse.setStatus(307);
        } else {
            httpServletResponse.sendRedirect(redirectLocation);
        }
    }

    private void handleRedirect(HttpServletRequest servletRequest, HttpServletResponse httpServletResponse, String activeServerAddress) throws IOException {
        String requestURI = servletRequest.getRequestURI();
        String queryString = servletRequest.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            queryString = UriUtils.encodeQuery((String)queryString, (String)"UTF-8");
        }
        if (queryString != null && !queryString.isEmpty()) {
            requestURI = requestURI + "?" + queryString;
        }
        if (requestURI == null) {
            requestURI = "/";
        }
        String redirectLocation = activeServerAddress + requestURI;
        LOG.info("Not active. Redirecting to {}", (Object)redirectLocation);
        if (this.isUnsafeHttpMethod(servletRequest)) {
            httpServletResponse.setHeader("Location", redirectLocation);
            httpServletResponse.setStatus(307);
        } else {
            httpServletResponse.sendRedirect(redirectLocation);
        }
    }

    private boolean isUnsafeHttpMethod(HttpServletRequest httpServletRequest) {
        String method = httpServletRequest.getMethod();
        return method.equals("POST") || method.equals("PUT") || method.equals("DELETE");
    }

    public void destroy() {
    }
}

