/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasException;
import org.apache.atlas.DeleteType;
import org.apache.atlas.RequestContext;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.util.AtlasRepositoryConfiguration;
import org.apache.atlas.web.util.DateTimeHelper;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AuditFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuditFilter.class);
    private static final Logger AUDIT_LOG = LoggerFactory.getLogger((String)"AUDIT");
    private boolean deleteTypeOverrideEnabled = false;
    private boolean createShellEntityForNonExistingReference = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("AuditFilter initialization started");
        this.deleteTypeOverrideEnabled = AtlasConfiguration.REST_API_ENABLE_DELETE_TYPE_OVERRIDE.getBoolean();
        this.createShellEntityForNonExistingReference = AtlasConfiguration.REST_API_CREATE_SHELL_ENTITY_FOR_NON_EXISTING_REF.getBoolean();
        LOG.info("REST_API_ENABLE_DELETE_TYPE_OVERRIDE={}", (Object)this.deleteTypeOverrideEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        long startTime = System.currentTimeMillis();
        Date requestTime = new Date();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestId = UUID.randomUUID().toString();
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        String user = AtlasAuthorizationUtils.getCurrentUserName();
        Set userGroups = AtlasAuthorizationUtils.getCurrentUserGroups();
        String deleteType = httpRequest.getParameter("deleteType");
        boolean skipFailedEntities = Boolean.parseBoolean(httpRequest.getParameter("skipFailedEntities"));
        try {
            currentThread.setName(this.formatName(oldName, requestId));
            RequestContext.clear();
            RequestContext requestContext = RequestContext.get();
            requestContext.setUser(user, userGroups);
            requestContext.setClientIPAddress(AtlasAuthorizationUtils.getRequestIpAddress((HttpServletRequest)httpRequest));
            requestContext.setCreateShellEntityForNonExistingReference(this.createShellEntityForNonExistingReference);
            requestContext.setForwardedAddresses(AtlasAuthorizationUtils.getForwardedAddressesFromRequest((HttpServletRequest)httpRequest));
            requestContext.setSkipFailedEntities(skipFailedEntities);
            if (StringUtils.isNotEmpty((String)deleteType)) {
                if (this.deleteTypeOverrideEnabled) {
                    requestContext.setDeleteType(DeleteType.from((String)deleteType));
                } else {
                    LOG.warn("Override of deleteType is not enabled. Ignoring parameter deleteType={}, in request from user={}", (Object)deleteType, (Object)user);
                }
            }
            filterChain.doFilter(request, response);
        }
        finally {
            long timeTaken = System.currentTimeMillis() - startTime;
            this.recordAudit(httpRequest, requestTime, user, httpResponse.getStatus(), timeTaken);
            httpResponse.setHeader("requestId", requestId);
            currentThread.setName(oldName);
            RequestContext.clear();
        }
    }

    private String formatName(String oldName, String requestId) {
        return oldName + " - " + requestId;
    }

    private void recordAudit(HttpServletRequest httpRequest, Date when, String who, int httpStatus, long timeTaken) {
        String fromAddress = httpRequest.getRemoteAddr();
        String whatRequest = httpRequest.getMethod();
        String whatURL = Servlets.getRequestURL(httpRequest);
        String whatUrlPath = httpRequest.getRequestURL().toString();
        if (!this.isOperationExcludedFromAudit(whatRequest, whatUrlPath.toLowerCase(), null)) {
            AuditFilter.audit(new AuditLog(who, fromAddress, whatRequest, whatURL, when, httpStatus, timeTaken));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(" Skipping Audit for {} ", (Object)whatURL);
        }
    }

    public static void audit(AuditLog auditLog) {
        if (AUDIT_LOG.isInfoEnabled() && auditLog != null) {
            AUDIT_LOG.info(auditLog.toString());
        }
    }

    boolean isOperationExcludedFromAudit(String requestHttpMethod, String requestOperation, Configuration config) {
        try {
            return AtlasRepositoryConfiguration.isExcludedFromAudit((Configuration)config, (String)requestHttpMethod, (String)requestOperation);
        }
        catch (AtlasException e) {
            return false;
        }
    }

    public void destroy() {
    }

    public static class AuditLog {
        private static final char FIELD_SEP = '|';
        private final String userName;
        private final String fromAddress;
        private final String requestMethod;
        private final String requestUrl;
        private final Date requestTime;
        private int httpStatus;
        private long timeTaken;

        public AuditLog(String userName, String fromAddress, String requestMethod, String requestUrl) {
            this(userName, fromAddress, requestMethod, requestUrl, new Date());
        }

        public AuditLog(String userName, String fromAddress, String requestMethod, String requestUrl, Date requestTime) {
            this(userName, fromAddress, requestMethod, requestUrl, requestTime, 200, 0L);
        }

        public AuditLog(String userName, String fromAddress, String requestMethod, String requestUrl, Date requestTime, int httpStatus, long timeTaken) {
            this.userName = userName;
            this.fromAddress = fromAddress;
            this.requestMethod = requestMethod;
            this.requestUrl = requestUrl;
            this.requestTime = requestTime;
            this.httpStatus = httpStatus;
            this.timeTaken = timeTaken;
        }

        public void setHttpStatus(int httpStatus) {
            this.httpStatus = httpStatus;
        }

        public void setTimeTaken(long timeTaken) {
            this.timeTaken = timeTaken;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(DateTimeHelper.formatDateUTC(this.requestTime)).append('|').append(this.userName).append('|').append(this.fromAddress).append('|').append(this.requestMethod).append('|').append(this.requestUrl).append('|').append(this.httpStatus).append('|').append(this.timeTaken);
            return sb.toString();
        }
    }
}

