/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.atlas.AtlasClient;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.CreateUpdateEntitiesResult;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.GuidMapping;
import org.apache.atlas.model.legacy.EntityResult;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.repository.store.graph.v2.AtlasEntityStream;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityStream;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.utils.ParamChecker;
import org.apache.atlas.v1.model.instance.Id;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.atlas.web.rest.EntityREST;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Singleton
@Path(value="entities")
@Service
@Deprecated
public class EntityResource {
    private static final Logger LOG = LoggerFactory.getLogger(EntityResource.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.EntityResource");
    private static final String TRAIT_NAME = "traitName";
    private final AtlasInstanceConverter restAdapters;
    private final AtlasEntityStore entitiesStore;
    private final AtlasTypeRegistry typeRegistry;
    private final EntityREST entityREST;
    private final EntityAuditRepository entityAuditRepository;
    private final AtlasInstanceConverter instanceConverter;
    @Context
    UriInfo uriInfo;

    @Inject
    public EntityResource(AtlasInstanceConverter restAdapters, AtlasEntityStore entitiesStore, AtlasTypeRegistry typeRegistry, EntityREST entityREST, EntityAuditRepository entityAuditRepository, AtlasInstanceConverter instanceConverter) {
        this.restAdapters = restAdapters;
        this.entitiesStore = entitiesStore;
        this.typeRegistry = typeRegistry;
        this.entityREST = entityREST;
        this.entityAuditRepository = entityAuditRepository;
        this.instanceConverter = instanceConverter;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Consumes(value={"application/json; charset=UTF-8", "application/json"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response submit(@Context HttpServletRequest request) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.submit()");
        }
        String entityJson = null;
        AtlasPerfTracer perf = null;
        try {
            String[] jsonStrings;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"EntityResource.submit()");
            }
            entityJson = Servlets.getRequestPayload(request);
            try {
                ArrayNode jsonEntities = AtlasJson.parseToV1ArrayNode((String)entityJson);
                jsonStrings = new String[jsonEntities.size()];
                for (int i = 0; i < jsonEntities.size(); ++i) {
                    jsonStrings[i] = AtlasJson.toV1Json((Object)jsonEntities.get(i));
                }
            }
            catch (IOException e) {
                jsonStrings = new String[]{entityJson};
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("submitting entities: count={}; entities-json={}", (Object)jsonStrings.length, (Object)entityJson);
            }
            AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = this.restAdapters.toAtlasEntities(jsonStrings);
            EntityMutationResponse mutationResponse = this.entityREST.createOrUpdate(entitiesInfo);
            List guids = this.restAdapters.getGuids(mutationResponse.getCreatedEntities());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created entities {}", (Object)guids);
            }
            CreateUpdateEntitiesResult result = this.restAdapters.toCreateUpdateEntitiesResult(mutationResponse);
            String response2 = this.getResponse(result);
            URI locationURI = this.getLocationURI(guids);
            response = Response.created((URI)locationURI).entity((Object)response2).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to persist entity instance entityDef={}", (Object)entityJson, (Object)e);
                throw EntityResource.toWebApplicationException(e);
                catch (IllegalArgumentException | AtlasException e2) {
                    LOG.error("Unable to persist entity instance entityDef={}", (Object)entityJson, (Object)e2);
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to persist entity instance entityDef={}", (Object)entityJson, (Object)e3);
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to persist entity instance entityDef={}", (Object)entityJson, (Object)e4);
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.submit()");
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.submit()");
        }
        return response;
    }

    @VisibleForTesting
    public URI getLocationURI(List<String> guids) {
        URI locationURI = null;
        if (this.uriInfo != null) {
            UriBuilder ub = this.uriInfo.getAbsolutePathBuilder();
            locationURI = CollectionUtils.isEmpty(guids) ? null : ub.path(guids.get(0)).build(new Object[0]);
        } else {
            String uriPath = AtlasClient.API_V1.GET_ENTITY.getNormalizedPath();
            locationURI = guids.isEmpty() ? null : UriBuilder.fromPath((String)"http://localhost:21000").path(uriPath).path(guids.get(0)).build(new Object[0]);
        }
        return locationURI;
    }

    private String getResponse(EntityResult entityResult) throws AtlasBaseException, AtlasException {
        CreateUpdateEntitiesResult result = new CreateUpdateEntitiesResult();
        result.setEntityResult(entityResult);
        return this.getResponse(result);
    }

    private String getResponse(CreateUpdateEntitiesResult result) throws AtlasBaseException, AtlasException {
        HashMap<String, Object> response = new HashMap<String, Object>();
        EntityResult entityResult = result.getEntityResult();
        GuidMapping mapping = result.getGuidMapping();
        response.put("requestId", Servlets.getRequestId());
        if (entityResult != null) {
            response.put("entities", entityResult.getEntities());
            String sampleEntityId = this.getSample(result.getEntityResult());
            if (sampleEntityId != null) {
                response.put("definition", this.getEntity(sampleEntityId));
            }
        }
        if (mapping != null) {
            response.put("guidAssignments", mapping);
        }
        return AtlasJson.toV1Json(response);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PUT
    @Consumes(value={"application/json; charset=UTF-8", "application/json"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response updateEntities(@Context HttpServletRequest request) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.updateEntities()");
        }
        String entityJson = null;
        AtlasPerfTracer perf = null;
        try {
            String[] jsonStrings;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"EntityResource.updateEntities()");
            }
            entityJson = Servlets.getRequestPayload(request);
            try {
                ArrayNode jsonEntities = AtlasJson.parseToV1ArrayNode((String)entityJson);
                jsonStrings = new String[jsonEntities.size()];
                for (int i = 0; i < jsonEntities.size(); ++i) {
                    jsonStrings[i] = AtlasJson.toV1Json((Object)jsonEntities.get(i));
                }
            }
            catch (IOException e) {
                jsonStrings = new String[]{entityJson};
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating entities: count={}; entities-json={}", (Object)jsonStrings.length, (Object)entityJson);
            }
            AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = this.restAdapters.toAtlasEntities(jsonStrings);
            EntityMutationResponse mutationResponse = this.entityREST.createOrUpdate(entitiesInfo);
            CreateUpdateEntitiesResult result = this.restAdapters.toCreateUpdateEntitiesResult(mutationResponse);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated entities: {}", (Object)result.getEntityResult());
            }
            String response2 = this.getResponse(result);
            response = Response.ok((Object)response2).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to persist entity instance entityDef={}", (Object)entityJson, (Object)e);
                throw EntityResource.toWebApplicationException(e);
                catch (IllegalArgumentException | AtlasException e2) {
                    LOG.error("Unable to persist entity instance entityDef={}", (Object)entityJson, (Object)e2);
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to persist entity instance entityDef={}", (Object)entityJson, (Object)e3);
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to persist entity instance entityDef={}", (Object)entityJson, (Object)e4);
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.updateEntities()");
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.updateEntities()");
        }
        return response;
    }

    private String getSample(EntityResult entityResult) {
        String sample = this.getSample(entityResult.getCreatedEntities());
        if (sample == null) {
            sample = this.getSample(entityResult.getUpdateEntities());
        }
        return sample;
    }

    private String getSample(List<String> list) {
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="qualifiedName")
    @Consumes(value={"application/json; charset=UTF-8", "application/json"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response updateByUniqueAttribute(@QueryParam(value="type") String entityType, @QueryParam(value="property") String attribute, @QueryParam(value="value") String value, @Context HttpServletRequest request) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.updateByUniqueAttribute({}, {}, {})", new Object[]{entityType, attribute, value});
        }
        AtlasPerfTracer perf = null;
        String entityJson = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.updateByUniqueAttribute(" + entityType + ", " + attribute + ", " + value + ")"));
            }
            entityJson = Servlets.getRequestPayload(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Partially updating entity by unique attribute {} {} {} {} ", new Object[]{entityType, attribute, value, entityJson});
            }
            Referenceable updatedEntity = (Referenceable)AtlasType.fromV1Json((String)entityJson, Referenceable.class);
            entityType = ParamChecker.notEmpty((String)entityType, (String)"Entity type cannot be null");
            attribute = ParamChecker.notEmpty((String)attribute, (String)"attribute name cannot be null");
            value = ParamChecker.notEmpty((String)value, (String)"attribute value cannot be null");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(attribute, value);
            Id updateId = updatedEntity.getId();
            if (updateId != null && !AtlasTypeUtil.isAssignedGuid((String)updateId.getId())) {
                String guid = AtlasGraphUtilsV2.getGuidByUniqueAttributes((AtlasEntityType)this.getEntityType(entityType), attributes);
                updatedEntity.setId(new Id(guid, 0, updatedEntity.getTypeName()));
            }
            AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = this.restAdapters.toAtlasEntity(updatedEntity);
            EntityMutationResponse mutationResponse = this.entitiesStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), true);
            CreateUpdateEntitiesResult result = this.restAdapters.toCreateUpdateEntitiesResult(mutationResponse);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated entities: {}", (Object)result.getEntityResult());
            }
            String response2 = this.getResponse(result);
            response = Response.ok((Object)response2).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to partially update entity {} {}:{}.{}", new Object[]{entityJson, entityType, attribute, value, e});
                throw EntityResource.toWebApplicationException(e);
                catch (IllegalArgumentException | AtlasException e2) {
                    LOG.error("Unable to partially update entity {} {}:{}.{}", new Object[]{entityJson, entityType, attribute, value, e2});
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to partially update entity {} {}:{}.{}", new Object[]{entityJson, entityType, attribute, value, e3});
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to partially update entity {} {}:{}.{}", new Object[]{entityJson, entityType, attribute, value, e4});
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.updateByUniqueAttribute({}, {}, {})", new Object[]{entityType, attribute, value});
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.updateByUniqueAttribute({}, {}, {})", new Object[]{entityType, attribute, value});
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{guid}")
    @Consumes(value={"application/json; charset=UTF-8", "application/json"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response updateEntityByGuid(@PathParam(value="guid") String guid, @QueryParam(value="property") String attribute, @Context HttpServletRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.updateEntityByGuid({}, {})", (Object)guid, (Object)attribute);
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.updateEntityByGuid(" + guid + ", " + attribute + ")"));
            }
            if (StringUtils.isEmpty((String)attribute)) {
                Response response = this.partialUpdateEntityByGuid(guid, request);
                return response;
            }
            Response response = this.partialUpdateEntityAttrByGuid(guid, attribute, request);
            return response;
        }
        finally {
            AtlasPerfTracer.log(perf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== EntityResource.updateEntityByGuid({}, {})", (Object)guid, (Object)attribute);
            }
        }
    }

    private Response partialUpdateEntityByGuid(String guid, HttpServletRequest request) {
        String entityJson = null;
        try {
            Referenceable updatedEntity;
            Id updateId;
            guid = ParamChecker.notEmpty((String)guid, (String)"Guid property cannot be null");
            entityJson = Servlets.getRequestPayload(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("partially updating entity for guid {} : {} ", (Object)guid, (Object)entityJson);
            }
            if ((updateId = (updatedEntity = (Referenceable)AtlasType.fromV1Json((String)entityJson, Referenceable.class)).getId()) != null && !AtlasTypeUtil.isAssignedGuid((String)updateId.getId())) {
                updatedEntity.setId(new Id(guid, 0, updatedEntity.getTypeName()));
            }
            AtlasEntity.AtlasEntitiesWithExtInfo entitiesInfo = this.restAdapters.toAtlasEntity(updatedEntity);
            EntityMutationResponse mutationResponse = this.entitiesStore.createOrUpdate((EntityStream)new AtlasEntityStream(entitiesInfo), true);
            CreateUpdateEntitiesResult result = this.restAdapters.toCreateUpdateEntitiesResult(mutationResponse);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated entities: {}", (Object)result.getEntityResult());
            }
            String response = this.getResponse(result);
            return Response.ok((Object)response).build();
        }
        catch (AtlasBaseException e) {
            LOG.error("Unable to update entity by GUID {} {} ", new Object[]{guid, entityJson, e});
            throw EntityResource.toWebApplicationException(e);
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Unable to update entity by GUID {} {}", new Object[]{guid, entityJson, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (WebApplicationException e) {
            LOG.error("Unable to update entity by GUID {} {} ", new Object[]{guid, entityJson, e});
            throw e;
        }
        catch (Throwable e) {
            LOG.error("Unable to update entity by GUID {} {} ", new Object[]{guid, entityJson, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private Response partialUpdateEntityAttrByGuid(String guid, String property, HttpServletRequest request) {
        String value = null;
        try {
            Preconditions.checkNotNull((Object)property, (Object)"Entity property cannot be null");
            value = Servlets.getRequestPayload(request);
            Preconditions.checkNotNull((Object)value, (Object)"Entity value cannot be null");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating entity {} for property {} = {}", new Object[]{guid, property, value});
            }
            EntityMutationResponse mutationResponse = this.entitiesStore.updateEntityAttributeByGuid(guid, property, (Object)value);
            CreateUpdateEntitiesResult result = this.restAdapters.toCreateUpdateEntitiesResult(mutationResponse);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated entities: {}", (Object)result.getEntityResult());
            }
            String response = this.getResponse(result);
            return Response.ok((Object)response).build();
        }
        catch (AtlasBaseException e) {
            LOG.error("Unable to add property {} to entity id {} {} ", new Object[]{property, guid, value, e});
            throw EntityResource.toWebApplicationException(e);
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Unable to add property {} to entity id {} {} ", new Object[]{property, guid, value, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (WebApplicationException e) {
            LOG.error("Unable to add property {} to entity id {} {} ", new Object[]{property, guid, value, e});
            throw e;
        }
        catch (Throwable e) {
            LOG.error("Unable to add property {} to entity id {} {} ", new Object[]{property, guid, value, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DELETE
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteEntities(@QueryParam(value="guid") List<String> guids, @QueryParam(value="type") String entityType, @QueryParam(value="property") String attribute, @QueryParam(value="value") String value) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.deleteEntities({}, {}, {}, {})", new Object[]{guids, entityType, attribute, value});
        }
        AtlasPerfTracer perf = null;
        try {
            EntityResult entityResult;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.deleteEntities(" + guids + ", " + entityType + ", " + attribute + ", " + value + ")"));
            }
            if (guids != null && !guids.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleting entities {}", guids);
                }
                EntityMutationResponse mutationResponse = this.entityREST.deleteByGuids(guids);
                entityResult = this.restAdapters.toCreateUpdateEntitiesResult(mutationResponse).getEntityResult();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleting entity type={} with property {}={}", new Object[]{entityType, attribute, value});
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put(attribute, value);
                EntityMutationResponse mutationResponse = this.entitiesStore.deleteByUniqueAttributes(this.getEntityType(entityType), attributes);
                entityResult = this.restAdapters.toCreateUpdateEntitiesResult(mutationResponse).getEntityResult();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted entity result: {}", (Object)entityResult);
            }
            String response2 = this.getResponse(entityResult);
            response = Response.ok((Object)response2).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to delete entities {} {} {} {} ", new Object[]{guids, entityType, attribute, value, e});
                throw EntityResource.toWebApplicationException(e);
                catch (IllegalArgumentException | AtlasException e2) {
                    LOG.error("Unable to delete entities {} {} {} {} ", new Object[]{guids, entityType, attribute, value, e2});
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to delete entities {} {} {} {} ", new Object[]{guids, entityType, attribute, value, e3});
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to delete entities {} {} {} {} ", new Object[]{guids, entityType, attribute, value, e4});
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.deleteEntities({}, {}, {}, {})", new Object[]{guids, entityType, attribute, value});
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.deleteEntities({}, {}, {}, {})", new Object[]{guids, entityType, attribute, value});
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{guid}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getEntityDefinition(@PathParam(value="guid") String guid) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.getEntityDefinition({})", (Object)guid);
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.getEntityDefinition(" + guid + ")"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching entity definition for guid={} ", (Object)guid);
            }
            guid = ParamChecker.notEmpty((String)guid, (String)"guid cannot be null");
            Referenceable entity = this.getEntity(guid);
            HashMap<String, String> response2 = new HashMap<String, String>();
            response2.put("requestId", Servlets.getRequestId());
            Response.Status status = Response.Status.NOT_FOUND;
            if (entity != null) {
                response2.put("definition", (String)entity);
                status = Response.Status.OK;
            } else {
                response2.put("error", Servlets.escapeJsonString(String.format("An entity with GUID={%s} does not exist", guid)));
            }
            response = Response.status((Response.Status)status).entity((Object)AtlasJson.toV1Json(response2)).build();
        }
        catch (IllegalArgumentException e) {
            try {
                LOG.error("Bad GUID={} ", (Object)guid, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
                catch (AtlasBaseException e2) {
                    LOG.error("Unable to get instance definition for GUID {}", (Object)guid, (Object)e2);
                    throw EntityResource.toWebApplicationException(e2);
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to get instance definition for GUID {}", (Object)guid, (Object)e3);
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to get instance definition for GUID {}", (Object)guid, (Object)e4);
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.getEntityDefinition({})", (Object)guid);
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.getEntityDefinition({})", (Object)guid);
        }
        return response;
    }

    public Response getEntityListByType(String entityType) {
        try {
            Preconditions.checkNotNull((Object)entityType, (Object)"Entity type cannot be null");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching entity list for type={} ", (Object)entityType);
            }
            List entityGUIDS = this.entitiesStore.getEntityGUIDS(entityType);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("requestId", Servlets.getRequestId());
            response.put("typeName", entityType);
            response.put("results", entityGUIDS);
            response.put("count", entityGUIDS.size());
            return Response.ok((Object)AtlasJson.toV1Json(response)).build();
        }
        catch (NullPointerException e) {
            LOG.error("Entity type cannot be null", (Throwable)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unable to get entity list for type {}", (Object)entityType, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (WebApplicationException e) {
            LOG.error("Unable to get entity list for type {}", (Object)entityType, (Object)e);
            throw e;
        }
        catch (AtlasBaseException e) {
            LOG.error("Unable to get entity list for type {}", (Object)entityType, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get entity list for type {}", (Object)entityType, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Consumes(value={"application/json; charset=UTF-8", "application/json"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getEntity(@QueryParam(value="type") String entityType, @QueryParam(value="property") String attribute, @QueryParam(value="value") String value) {
        AtlasPerfTracer perf;
        block8: {
            Response response;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> EntityResource.getEntity({}, {}, {})", new Object[]{entityType, attribute, value});
            }
            perf = null;
            try {
                if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                    perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.getEntity(" + entityType + ", " + attribute + ", " + value + ")"));
                }
                if (!StringUtils.isEmpty((String)attribute)) break block8;
                response = this.getEntityListByType(entityType);
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.getEntity({}, {}, {})", new Object[]{entityType, attribute, value});
                }
                throw throwable;
            }
            AtlasPerfTracer.log(perf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== EntityResource.getEntity({}, {}, {})", new Object[]{entityType, attribute, value});
            }
            return response;
        }
        Response response = this.getEntityDefinitionByAttribute(entityType, attribute, value);
        AtlasPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.getEntity({}, {}, {})", new Object[]{entityType, attribute, value});
        }
        return response;
    }

    public Response getEntityDefinitionByAttribute(String entityType, String attribute, String value) {
        try {
            AtlasEntity.AtlasEntityWithExtInfo entityInfo;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching entity definition for type={}, qualified name={}", (Object)entityType, (Object)value);
            }
            entityType = ParamChecker.notEmpty((String)entityType, (String)"Entity type cannot be null");
            attribute = ParamChecker.notEmpty((String)attribute, (String)"attribute name cannot be null");
            value = ParamChecker.notEmpty((String)value, (String)"attribute value cannot be null");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(attribute, value);
            try {
                entityInfo = this.entitiesStore.getByUniqueAttributes(this.getEntityType(entityType), attributes);
            }
            catch (AtlasBaseException e) {
                LOG.error("Cannot find entity with type: {}, attribute: {} and value: {}", new Object[]{entityType, attribute, value});
                throw EntityResource.toWebApplicationException(e);
            }
            Referenceable entity = null;
            if (entityInfo != null) {
                entity = this.restAdapters.getReferenceable(entityInfo);
            }
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("requestId", Servlets.getRequestId());
            Response.Status status = Response.Status.NOT_FOUND;
            if (entity != null) {
                response.put("definition", (String)entity);
                status = Response.Status.OK;
            } else {
                response.put("error", Servlets.escapeJsonString(String.format("An entity with type={%s}, qualifiedName={%s} does not exist", entityType, value)));
            }
            return Response.status((Response.Status)status).entity((Object)AtlasJson.toV1Json(response)).build();
        }
        catch (AtlasBaseException e) {
            LOG.error("Unable to get instance definition for type={}, qualifiedName={}", new Object[]{entityType, value, e});
            throw EntityResource.toWebApplicationException(e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Bad type={}, qualifiedName={}", new Object[]{entityType, value, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (WebApplicationException e) {
            LOG.error("Unable to get instance definition for type={}, qualifiedName={}", new Object[]{entityType, value, e});
            throw e;
        }
        catch (Throwable e) {
            LOG.error("Unable to get instance definition for type={}, qualifiedName={}", new Object[]{entityType, value, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{guid}/traits")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getTraitNames(@PathParam(value="guid") String guid) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.getTraitNames({})", (Object)guid);
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.getTraitNames(" + guid + ")"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching trait names for entity={}", (Object)guid);
            }
            List classifications = this.entitiesStore.getClassifications(guid);
            ArrayList<String> traitNames = new ArrayList<String>();
            for (AtlasClassification classification : classifications) {
                traitNames.add(classification.getTypeName());
            }
            HashMap<String, Object> response2 = new HashMap<String, Object>();
            response2.put("requestId", Servlets.getRequestId());
            response2.put("results", traitNames);
            response2.put("count", traitNames.size());
            response = Response.ok((Object)AtlasJson.toV1Json(response2)).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to get trait definition for entity {}", (Object)guid, (Object)e);
                throw EntityResource.toWebApplicationException(e);
                catch (IllegalArgumentException e2) {
                    LOG.error("Unable to get trait definition for entity {}", (Object)guid, (Object)e2);
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to get trait names for entity {}", (Object)guid, (Object)e3);
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to get trait names for entity {}", (Object)guid, (Object)e4);
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.getTraitNames({})", (Object)guid);
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.getTraitNames({})", (Object)guid);
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{guid}/traitDefinitions")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getTraitDefinitionsForEntity(@PathParam(value="guid") String guid) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.getTraitDefinitionsForEntity({})", (Object)guid);
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.getTraitDefinitionsForEntity(" + guid + ")"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching all trait definitions for entity={}", (Object)guid);
            }
            List classifications = this.entitiesStore.getClassifications(guid);
            ArrayList<Struct> traits = new ArrayList<Struct>(classifications.size());
            for (AtlasClassification classification : classifications) {
                Struct trait = this.restAdapters.getTrait(classification);
                traits.add(trait);
            }
            HashMap<String, Object> response2 = new HashMap<String, Object>();
            response2.put("requestId", Servlets.getRequestId());
            response2.put("results", traits);
            response2.put("count", traits.size());
            response = Response.ok((Object)AtlasJson.toV1Json(response2)).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to get trait definition for entity {}", (Object)guid, (Object)e);
                throw EntityResource.toWebApplicationException(e);
                catch (IllegalArgumentException e2) {
                    LOG.error("Unable to get trait definition for entity {}", (Object)guid, (Object)e2);
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to get trait definitions for entity {}", (Object)guid, (Object)e3);
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to get trait definitions for entity {}", (Object)guid, (Object)e4);
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.getTraitDefinitionsForEntity({})", (Object)guid);
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.getTraitDefinitionsForEntity({})", (Object)guid);
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{guid}/traitDefinitions/{traitName}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getTraitDefinitionForEntity(@PathParam(value="guid") String guid, @PathParam(value="traitName") String traitName) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.getTraitDefinitionForEntity({}, {})", (Object)guid, (Object)traitName);
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.getTraitDefinitionForEntity(" + guid + ", " + traitName + ")"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching trait definition for entity {} and trait name {}", (Object)guid, (Object)traitName);
            }
            AtlasClassification classification = this.entitiesStore.getClassification(guid, traitName);
            Struct traitDefinition = this.restAdapters.getTrait(classification);
            HashMap<String, String> response2 = new HashMap<String, String>();
            response2.put("requestId", Servlets.getRequestId());
            response2.put("results", (String)traitDefinition);
            response = Response.ok((Object)AtlasJson.toV1Json(response2)).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to get trait definition for entity {} and trait {}", new Object[]{guid, traitName, e});
                throw EntityResource.toWebApplicationException(e);
                catch (IllegalArgumentException e2) {
                    LOG.error("Unable to get trait definition for entity {} and trait {}", new Object[]{guid, traitName, e2});
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to get trait definition for entity {} and trait {}", new Object[]{guid, traitName, e3});
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to get trait definition for entity {} and trait {}", new Object[]{guid, traitName, e4});
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.getTraitDefinitionForEntity({}, {})", (Object)guid, (Object)traitName);
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.getTraitDefinitionForEntity({}, {})", (Object)guid, (Object)traitName);
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="{guid}/traits")
    @Consumes(value={"application/json; charset=UTF-8", "application/json"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response addTrait(@Context HttpServletRequest request, final @PathParam(value="guid") String guid) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.addTrait({})", (Object)guid);
        }
        String traitDefinition = null;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.addTrait(" + guid + ")"));
            }
            traitDefinition = Servlets.getRequestPayload(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding trait={} for entity={} ", (Object)traitDefinition, (Object)guid);
            }
            ArrayList<String> guids = new ArrayList<String>(){
                {
                    this.add(guid);
                }
            };
            this.entitiesStore.addClassification((List)guids, this.restAdapters.toAtlasClassification((Struct)AtlasType.fromV1Json((String)traitDefinition, Struct.class)));
            URI locationURI = this.getLocationURI((List<String>)new ArrayList<String>(){
                {
                    this.add(guid);
                }
            });
            HashMap<String, String> response2 = new HashMap<String, String>();
            response2.put("requestId", Servlets.getRequestId());
            response = Response.created((URI)locationURI).entity((Object)AtlasJson.toV1Json(response2)).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to add trait for entity={} traitDef={}", new Object[]{guid, traitDefinition, e});
                throw EntityResource.toWebApplicationException(e);
                catch (IllegalArgumentException e2) {
                    LOG.error("Unable to add trait for entity={} traitDef={}", new Object[]{guid, traitDefinition, e2});
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to add trait for entity={} traitDef={}", new Object[]{guid, traitDefinition, e3});
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to add trait for entity={} traitDef={}", new Object[]{guid, traitDefinition, e4});
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.addTrait({})", (Object)guid);
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.addTrait({})", (Object)guid);
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DELETE
    @Path(value="{guid}/traits/{traitName}")
    @Consumes(value={"application/json; charset=UTF-8", "application/json"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteTrait(@Context HttpServletRequest request, @PathParam(value="guid") String guid, @PathParam(value="traitName") String traitName) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.deleteTrait({}, {})", (Object)guid, (Object)traitName);
        }
        AtlasPerfTracer perf = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting trait={} from entity={} ", (Object)traitName, (Object)guid);
        }
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.deleteTrait(" + guid + ", " + traitName + ")"));
            }
            this.entitiesStore.deleteClassification(guid, traitName);
            HashMap<String, String> response2 = new HashMap<String, String>();
            response2.put("requestId", Servlets.getRequestId());
            response2.put(TRAIT_NAME, traitName);
            response = Response.ok((Object)AtlasJson.toV1Json(response2)).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to delete trait name={} for entity={}", new Object[]{traitName, guid, e});
                throw EntityResource.toWebApplicationException(e);
                catch (IllegalArgumentException e2) {
                    LOG.error("Unable to delete trait name={} for entity={}", new Object[]{traitName, guid, e2});
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to delete trait name={} for entity={}", new Object[]{traitName, guid, e3});
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to delete trait name={} for entity={}", new Object[]{traitName, guid, e4});
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.deleteTrait({}, {})", (Object)guid, (Object)traitName);
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.deleteTrait({}, {})", (Object)guid, (Object)traitName);
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{guid}/audit")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getAuditEvents(@PathParam(value="guid") String guid, @QueryParam(value="startKey") String startKey, @QueryParam(value="count") @DefaultValue(value="100") short count) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntityResource.getAuditEvents({}, {}, {})", new Object[]{guid, startKey, count});
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntityResource.getAuditEvents(" + guid + ", " + startKey + ", " + count + ")"));
            }
            List events = this.entityAuditRepository.listEvents(guid, startKey, count);
            ArrayList<EntityAuditEvent> v1Events = new ArrayList<EntityAuditEvent>();
            for (Object event : events) {
                if (event instanceof EntityAuditEvent) {
                    v1Events.add((EntityAuditEvent)event);
                    continue;
                }
                if (event instanceof EntityAuditEventV2) {
                    v1Events.add(this.instanceConverter.toV1AuditEvent((EntityAuditEventV2)event));
                    continue;
                }
                LOG.warn("unknown entity-audit event type {}. Ignored", (Object)(event != null ? event.getClass().getCanonicalName() : "null"));
            }
            HashMap<String, Object> response2 = new HashMap<String, Object>();
            response2.put("requestId", Servlets.getRequestId());
            response2.put("events", v1Events);
            response = Response.ok((Object)AtlasJson.toV1Json(response2)).build();
        }
        catch (IllegalArgumentException e) {
            try {
                LOG.error("Unable to get audit events for entity guid={} startKey={}", new Object[]{guid, startKey, e});
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get audit events for entity guid={} startKey={}", new Object[]{guid, startKey, e2});
                    throw e2;
                }
                catch (Throwable e3) {
                    LOG.error("Unable to get audit events for entity guid={} startKey={}", new Object[]{guid, startKey, e3});
                    throw new WebApplicationException(Servlets.getErrorResponse(e3, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== EntityResource.getAuditEvents({}, {}, {})", new Object[]{guid, startKey, count});
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntityResource.getAuditEvents({}, {}, {})", new Object[]{guid, startKey, count});
        }
        return response;
    }

    private AtlasEntityType getEntityType(String typeName) throws AtlasBaseException {
        AtlasEntityType ret = this.typeRegistry.getEntityTypeByName(typeName);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{typeName});
        }
        return ret;
    }

    public static WebApplicationException toWebApplicationException(AtlasBaseException e) {
        if (e.getAtlasErrorCode() == AtlasErrorCode.CLASSIFICATION_NOT_FOUND || e.getAtlasErrorCode() == AtlasErrorCode.INSTANCE_GUID_NOT_FOUND || e.getAtlasErrorCode() == AtlasErrorCode.INSTANCE_BY_UNIQUE_ATTRIBUTE_NOT_FOUND) {
            return new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        if (e.getAtlasErrorCode() == AtlasErrorCode.INVALID_PARAMETERS || e.getAtlasErrorCode() == AtlasErrorCode.INSTANCE_CRUD_INVALID_PARAMS) {
            return new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        return new WebApplicationException(Servlets.getErrorResponse(e, e.getAtlasErrorCode().getHttpCode()));
    }

    private Referenceable getEntity(String guid) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entity = this.entitiesStore.getById(guid);
        Referenceable referenceable = this.restAdapters.getReferenceable(entity);
        return referenceable;
    }
}

