/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.utils.ParamChecker;
import org.apache.atlas.v1.model.discovery.DSLSearchResult;
import org.apache.atlas.v1.model.discovery.FullTextSearchResult;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="discovery")
@Singleton
@Service
@Deprecated
public class MetadataDiscoveryResource {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataDiscoveryResource.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.MetadataDiscoveryResource");
    private static final String QUERY_TYPE_DSL = "dsl";
    private static final String QUERY_TYPE_FULLTEXT = "full-text";
    private static final String LIMIT_OFFSET_DEFAULT = "-1";
    private final AtlasDiscoveryService atlasDiscoveryService;
    private final AtlasInstanceConverter restAdapters;
    private final AtlasEntityStore entitiesStore;

    @Inject
    public MetadataDiscoveryResource(AtlasDiscoveryService atlasDiscoveryService, AtlasInstanceConverter restAdapters, AtlasEntityStore entitiesStore) {
        this.atlasDiscoveryService = atlasDiscoveryService;
        this.restAdapters = restAdapters;
        this.entitiesStore = entitiesStore;
    }

    @GET
    @Path(value="search")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response search(@QueryParam(value="query") String query, @DefaultValue(value="-1") @QueryParam(value="limit") int limit, @DefaultValue(value="-1") @QueryParam(value="offset") int offset) {
        boolean dslQueryFailed = false;
        Response response = null;
        try {
            response = this.searchUsingQueryDSL(query, limit, offset);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                dslQueryFailed = true;
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error while running DSL. Switching to fulltext for query {}", (Object)query, (Object)e);
            }
            dslQueryFailed = true;
        }
        if (dslQueryFailed) {
            response = this.searchUsingFullText(query, limit, offset);
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="search/dsl")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response searchUsingQueryDSL(@QueryParam(value="query") String dslQuery, @DefaultValue(value="-1") @QueryParam(value="limit") int limit, @DefaultValue(value="-1") @QueryParam(value="offset") int offset) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> MetadataDiscoveryResource.searchUsingQueryDSL({}, {}, {})", new Object[]{dslQuery, limit, offset});
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("MetadataDiscoveryResource.searchUsingQueryDSL(" + dslQuery + ", " + limit + ", " + offset + ")"));
            }
            dslQuery = ParamChecker.notEmpty((String)dslQuery, (String)"dslQuery cannot be null");
            QueryParams queryParams = this.validateQueryParams(limit, offset);
            AtlasSearchResult result = this.atlasDiscoveryService.searchUsingDslQuery(dslQuery, queryParams.limit(), queryParams.offset());
            DSLSearchResult dslResult = new DSLSearchResult();
            dslResult.setQueryType(QUERY_TYPE_DSL);
            dslResult.setRequestId(Servlets.getRequestId());
            dslResult.setDataType(result.getType());
            dslResult.setQuery(result.getQueryText());
            dslResult.setCount(0);
            if (CollectionUtils.isNotEmpty((Collection)result.getEntities())) {
                for (AtlasEntityHeader entityHeader : result.getEntities()) {
                    Referenceable entity = this.getEntity(entityHeader.getGuid());
                    dslResult.addResult(entity);
                }
                if (dslResult.getResults() != null) {
                    dslResult.setCount(dslResult.getResults().size());
                }
            } else if (result.getAttributes() != null && CollectionUtils.isNotEmpty((Collection)result.getAttributes().getName())) {
                List attrNames = result.getAttributes().getName();
                for (List attrValues : result.getAttributes().getValues()) {
                    if (attrValues == null) continue;
                    Referenceable entity = new Referenceable();
                    for (int i = 0; i < attrNames.size(); ++i) {
                        String attrName = (String)attrNames.get(i);
                        Object attrValue = attrValues.size() > i ? attrValues.get(i) : null;
                        entity.set(attrName, attrValue);
                    }
                    dslResult.addResult(entity);
                }
                if (dslResult.getResults() != null) {
                    dslResult.setCount(dslResult.getResults().size());
                }
            }
            String response2 = AtlasJson.toV1SearchJson((Object)dslResult);
            response = Response.ok((Object)response2).build();
        }
        catch (IllegalArgumentException e) {
            try {
                LOG.error("Unable to get entity list for dslQuery {}", (Object)dslQuery, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get entity list for dslQuery {}", (Object)dslQuery, (Object)e2);
                    throw e2;
                }
                catch (Throwable e3) {
                    LOG.error("Unable to get entity list for dslQuery {}", (Object)dslQuery, (Object)e3);
                    throw new WebApplicationException(Servlets.getErrorResponse(e3, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== MetadataDiscoveryResource.searchUsingQueryDSL({}, {}, {})", new Object[]{dslQuery, limit, offset});
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== MetadataDiscoveryResource.searchUsingQueryDSL({}, {}, {})", new Object[]{dslQuery, limit, offset});
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="search/fulltext")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response searchUsingFullText(@QueryParam(value="query") String query, @DefaultValue(value="-1") @QueryParam(value="limit") int limit, @DefaultValue(value="-1") @QueryParam(value="offset") int offset) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> MetadataDiscoveryResource.searchUsingFullText({}, {}, {})", new Object[]{query, limit, offset});
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("MetadataDiscoveryResource.searchUsingFullText(" + query + ", " + limit + ", " + offset + ")"));
            }
            query = ParamChecker.notEmpty((String)query, (String)"query cannot be null or empty");
            QueryParams queryParams = this.validateQueryParams(limit, offset);
            AtlasSearchResult result = this.atlasDiscoveryService.searchUsingFullTextQuery(query, false, queryParams.limit(), queryParams.offset());
            FullTextSearchResult fullTextResult = new FullTextSearchResult();
            fullTextResult.setQueryType(QUERY_TYPE_FULLTEXT);
            fullTextResult.setRequestId(Servlets.getRequestId());
            fullTextResult.setDataType(result.getType());
            fullTextResult.setQuery(result.getQueryText());
            fullTextResult.setCount(0);
            if (CollectionUtils.isNotEmpty((Collection)result.getFullTextResult())) {
                for (AtlasSearchResult.AtlasFullTextResult entity : result.getFullTextResult()) {
                    fullTextResult.addResult(entity);
                }
                fullTextResult.setCount(fullTextResult.getResults().size());
            }
            String response2 = AtlasJson.toV1SearchJson((Object)fullTextResult);
            response = Response.ok((Object)response2).build();
        }
        catch (IllegalArgumentException e) {
            try {
                LOG.error("Unable to get entity list for query {}", (Object)query, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get entity list for query {}", (Object)query, (Object)e2);
                    throw e2;
                }
                catch (Throwable e3) {
                    LOG.error("Unable to get entity list for query {}", (Object)query, (Object)e3);
                    throw new WebApplicationException(Servlets.getErrorResponse(e3, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== MetadataDiscoveryResource.searchUsingFullText({}, {}, {})", new Object[]{query, limit, offset});
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== MetadataDiscoveryResource.searchUsingFullText({}, {}, {})", new Object[]{query, limit, offset});
        }
        return response;
    }

    private QueryParams validateQueryParams(int limitParam, int offsetParam) {
        boolean offsetSet;
        boolean limitSet;
        int defaultLimit;
        int maxLimit = AtlasConfiguration.SEARCH_MAX_LIMIT.getInt();
        int limit = defaultLimit = AtlasConfiguration.SEARCH_DEFAULT_LIMIT.getInt();
        boolean bl = limitSet = limitParam != Integer.valueOf(LIMIT_OFFSET_DEFAULT);
        if (limitSet) {
            ParamChecker.lessThan((long)limitParam, (long)maxLimit, (String)"limit");
            ParamChecker.greaterThan((long)limitParam, (long)0L, (String)"limit");
            limit = limitParam;
        }
        int offset = 0;
        boolean bl2 = offsetSet = offsetParam != Integer.valueOf(LIMIT_OFFSET_DEFAULT);
        if (offsetSet) {
            ParamChecker.greaterThan((long)offsetParam, (long)-1L, (String)"offset");
            offset = offsetParam;
        }
        return new QueryParams(limit, offset);
    }

    private Referenceable getEntity(String guid) throws AtlasBaseException {
        AtlasEntity.AtlasEntityWithExtInfo entity = this.entitiesStore.getById(guid);
        Referenceable referenceable = this.restAdapters.getReferenceable(entity);
        return referenceable;
    }
}

