/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.core.ResourceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.converters.TypeConverterUtil;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.v1.model.typedef.TypesDef;
import org.apache.atlas.web.rest.TypesREST;
import org.apache.atlas.web.util.Servlets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="types")
@Singleton
@Service
@Deprecated
public class TypesResource {
    private static final Logger LOG = LoggerFactory.getLogger(TypesResource.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.TypesResource");
    private static AtlasTypeRegistry typeRegistry;
    private final TypesREST typesREST;
    private final AtlasTypeDefStore typeDefStore;
    @Context
    private ResourceContext resourceContext;

    @Inject
    public TypesResource(AtlasTypeRegistry typeRegistry, TypesREST typesREST, AtlasTypeDefStore typeDefStore) {
        TypesResource.typeRegistry = typeRegistry;
        this.typesREST = typesREST;
        this.typeDefStore = typeDefStore;
    }

    @POST
    @Consumes(value={"application/json; charset=UTF-8", "application/json"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response submit(@Context HttpServletRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TypesResource.submit()");
        }
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"TypesResource.submit()");
        }
        try {
            String typeDefinition = Servlets.getRequestPayload(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating type with definition {} ", (Object)typeDefinition);
            }
            AtlasTypesDef createTypesDef = TypeConverterUtil.toAtlasTypesDef((String)typeDefinition, (AtlasTypeRegistry)typeRegistry);
            AtlasTypesDef createdTypesDef = this.typesREST.createAtlasTypeDefs(createTypesDef);
            List typeNames = TypeConverterUtil.getTypeNames((AtlasTypesDef)createdTypesDef);
            ArrayList<Map<String, String>> typesResponse = new ArrayList<Map<String, String>>(typeNames.size());
            for (String typeName : typeNames) {
                typesResponse.add(Collections.singletonMap("name", typeName));
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("requestId", Servlets.getRequestId());
            response.put("types", typesResponse);
            Response response2 = Response.status((Response.StatusType)ClientResponse.Status.CREATED).entity((Object)AtlasJson.toV1Json(response)).build();
            return response2;
        }
        catch (AtlasBaseException e) {
            LOG.error("Type creation failed", (Throwable)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unable to persist types", (Throwable)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (WebApplicationException e) {
            LOG.error("Unable to persist types", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LOG.error("Unable to persist types", e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
        finally {
            AtlasPerfTracer.log((AtlasPerfTracer)perf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== TypesResource.submit()");
            }
        }
    }

    @PUT
    @Consumes(value={"application/json; charset=UTF-8", "application/json"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response update(@Context HttpServletRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TypesResource.update()");
        }
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)"TypesResource.update()");
        }
        try {
            String typeDefinition = Servlets.getRequestPayload(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating type with definition {} ", (Object)typeDefinition);
            }
            AtlasTypesDef updateTypesDef = TypeConverterUtil.toAtlasTypesDef((String)typeDefinition, (AtlasTypeRegistry)typeRegistry);
            AtlasTypesDef updatedTypesDef = this.typeDefStore.createUpdateTypesDef(updateTypesDef);
            List typeNames = TypeConverterUtil.getTypeNames((AtlasTypesDef)updatedTypesDef);
            ArrayList<Map<String, String>> typesResponse = new ArrayList<Map<String, String>>(typeNames.size());
            for (String typeName : typeNames) {
                typesResponse.add(Collections.singletonMap("name", typeName));
            }
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("requestId", Servlets.getRequestId());
            response.put("types", typesResponse);
            Response response2 = Response.ok().entity((Object)AtlasJson.toV1Json(response)).build();
            return response2;
        }
        catch (AtlasBaseException e) {
            LOG.error("Unable to persist types", (Throwable)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unable to persist types", (Throwable)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (WebApplicationException e) {
            LOG.error("Unable to persist types", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LOG.error("Unable to persist types", e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
        finally {
            AtlasPerfTracer.log((AtlasPerfTracer)perf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== TypesResource.update()");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="{typeName}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getDefinition(@Context HttpServletRequest request, @PathParam(value="typeName") String typeName) {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TypesResource.getDefinition({})", (Object)typeName);
        }
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("TypesResource.getDefinition(" + typeName + ")"));
        }
        HashMap<String, String> response2 = new HashMap<String, String>();
        try {
            TypesDef typesDef = TypeConverterUtil.toTypesDef((AtlasType)typeRegistry.getType(typeName), (AtlasTypeRegistry)typeRegistry);
            response2.put("typeName", typeName);
            response2.put("definition", (String)typesDef);
            response2.put("requestId", Servlets.getRequestId());
            response = Response.ok((Object)AtlasJson.toV1Json(response2)).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.error("Unable to get type definition for type {}", (Object)typeName, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e));
                catch (IllegalArgumentException e2) {
                    LOG.error("Unable to get type definition for type {}", (Object)typeName, (Object)e2);
                    throw new WebApplicationException(Servlets.getErrorResponse(e2, Response.Status.BAD_REQUEST));
                }
                catch (WebApplicationException e3) {
                    LOG.error("Unable to get type definition for type {}", (Object)typeName, (Object)e3);
                    throw e3;
                }
                catch (Throwable e4) {
                    LOG.error("Unable to get type definition for type {}", (Object)typeName, (Object)e4);
                    throw new WebApplicationException(Servlets.getErrorResponse(e4, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== TypesResource.getDefinition({})", (Object)typeName);
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TypesResource.getDefinition({})", (Object)typeName);
        }
        return response;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getTypesByFilter(@Context HttpServletRequest request, @QueryParam(value="type") String typeCategory, @QueryParam(value="supertype") String supertype, @QueryParam(value="notsupertype") String notsupertype) throws AtlasBaseException {
        Response response;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TypesResource.getTypesByFilter({}, {}, {})", new Object[]{typeCategory, supertype, notsupertype});
        }
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("TypesResource.getTypesByFilter(" + typeCategory + ", " + supertype + ", " + notsupertype + ")"));
        }
        HashMap<String, Object> response2 = new HashMap<String, Object>();
        try {
            List result = TypeConverterUtil.getTypeNames(this.typesREST.getTypeDefHeaders(request));
            response2.put("results", result);
            response2.put("count", result.size());
            response2.put("requestId", Servlets.getRequestId());
            response = Response.ok((Object)AtlasJson.toV1Json(response2)).build();
        }
        catch (AtlasBaseException e) {
            try {
                LOG.warn("TypesREST exception: {} {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)e.getMessage());
                throw new WebApplicationException(Servlets.getErrorResponse(e));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get types list", (Throwable)e2);
                    throw e2;
                }
                catch (Throwable e3) {
                    LOG.error("Unable to get types list", e3);
                    throw new WebApplicationException(Servlets.getErrorResponse(e3, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== TypesResource.getTypesByFilter({}, {}, {})", new Object[]{typeCategory, supertype, notsupertype});
                }
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TypesResource.getTypesByFilter({}, {}, {})", new Object[]{typeCategory, supertype, notsupertype});
        }
        return response;
    }
}

