/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.rest;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.SortOrder;
import org.apache.atlas.annotation.Timed;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.discovery.EntityDiscoveryService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasQuickSearchResult;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.AtlasSuggestionsResult;
import org.apache.atlas.model.discovery.QuickSearchParameters;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.profile.AtlasUserSavedSearch;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Path(value="v2/search")
@Singleton
@Service
@Consumes(value={"application/json; charset=UTF-8", "application/json"})
@Produces(value={"application/json; charset=UTF-8", "application/json"})
public class DiscoveryREST {
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.DiscoveryREST");
    @Context
    private HttpServletRequest httpServletRequest;
    private final int maxFullTextQueryLength;
    private final int maxDslQueryLength;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasDiscoveryService discoveryService;

    @Inject
    public DiscoveryREST(AtlasTypeRegistry typeRegistry, AtlasDiscoveryService discoveryService, Configuration configuration) {
        this.typeRegistry = typeRegistry;
        this.discoveryService = discoveryService;
        this.maxFullTextQueryLength = configuration.getInt("atlas.graph.fulltext-max-query-str-length", 4096);
        this.maxDslQueryLength = configuration.getInt("atlas.graph.dsl-max-query-str-length", 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/dsl")
    @Timed
    public AtlasSearchResult searchUsingDSL(@QueryParam(value="query") String query, @QueryParam(value="typeName") String typeName, @QueryParam(value="classification") String classification, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        Servlets.validateQueryParamLength("classification", classification);
        if (StringUtils.isNotEmpty((CharSequence)query) && query.length() > this.maxDslQueryLength) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_QUERY_LENGTH, new String[]{"atlas.graph.dsl-max-query-str-length"});
        }
        AtlasPerfTracer perf = null;
        try {
            query = Servlets.decodeQueryString(query);
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.searchUsingDSL(" + query + "," + typeName + "," + classification + "," + limit + "," + offset + ")"));
            }
            String queryStr = this.discoveryService.getDslQueryUsingTypeNameClassification(query, typeName, classification);
            AtlasSearchResult atlasSearchResult = this.discoveryService.searchUsingDslQuery(queryStr, limit, offset);
            return atlasSearchResult;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/fulltext")
    @Timed
    public AtlasSearchResult searchUsingFullText(@QueryParam(value="query") String query, @QueryParam(value="excludeDeletedEntities") boolean excludeDeletedEntities, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws AtlasBaseException {
        if (StringUtils.isNotEmpty((CharSequence)query) && query.length() > this.maxFullTextQueryLength) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_QUERY_LENGTH, new String[]{"atlas.graph.fulltext-max-query-str-length"});
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.searchUsingFullText(" + query + "," + limit + "," + offset + ")"));
            }
            AtlasSearchResult atlasSearchResult = this.discoveryService.searchUsingFullTextQuery(query, excludeDeletedEntities, limit, offset);
            return atlasSearchResult;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/basic")
    @Timed
    public AtlasSearchResult searchUsingBasic(@QueryParam(value="query") String query, @QueryParam(value="typeName") String typeName, @QueryParam(value="classification") String classification, @QueryParam(value="sortBy") String sortByAttribute, @QueryParam(value="sortOrder") SortOrder sortOrder, @QueryParam(value="excludeDeletedEntities") boolean excludeDeletedEntities, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset, @QueryParam(value="marker") String marker) throws AtlasBaseException {
        AtlasSearchResult atlasSearchResult;
        Servlets.validateQueryParamLength("typeName", typeName);
        Servlets.validateQueryParamLength("classification", classification);
        Servlets.validateQueryParamLength("sortBy", sortByAttribute);
        if (StringUtils.isNotEmpty((CharSequence)query) && query.length() > this.maxFullTextQueryLength) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_QUERY_LENGTH, new String[]{"atlas.graph.fulltext-max-query-str-length"});
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.searchUsingBasic(" + query + "," + typeName + "," + classification + "," + limit + "," + offset + ")"));
            }
            SearchParameters searchParameters = new SearchParameters();
            searchParameters.setTypeName(typeName);
            searchParameters.setClassification(classification);
            searchParameters.setQuery(query);
            searchParameters.setExcludeDeletedEntities(excludeDeletedEntities);
            searchParameters.setLimit(limit);
            searchParameters.setOffset(offset);
            searchParameters.setMarker(marker);
            searchParameters.setSortBy(sortByAttribute);
            searchParameters.setSortOrder(sortOrder);
            atlasSearchResult = this.discoveryService.searchWithParameters(searchParameters);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasSearchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/attribute")
    @Timed
    public AtlasSearchResult searchUsingAttribute(@QueryParam(value="attrName") String attrName, @QueryParam(value="attrValuePrefix") String attrValuePrefix, @QueryParam(value="typeName") String typeName, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws AtlasBaseException {
        AtlasSearchResult atlasSearchResult;
        Servlets.validateQueryParamLength("attrName", attrName);
        Servlets.validateQueryParamLength("attrValuePrefix", attrValuePrefix);
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.searchUsingAttribute(" + attrName + "," + attrValuePrefix + "," + typeName + "," + limit + "," + offset + ")"));
            }
            if (StringUtils.isEmpty((CharSequence)attrName) && StringUtils.isEmpty((CharSequence)attrValuePrefix)) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{String.format("attrName : %s, attrValue: %s for attribute search.", attrName, attrValuePrefix)});
            }
            if (StringUtils.isEmpty((CharSequence)attrName)) {
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
                if (entityType != null) {
                    AtlasSearchResult defaultAttrNames;
                    for (String defaultAttrName : defaultAttrNames = new AtlasSearchResult[]{"qualifiedName", "name"}) {
                        AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(defaultAttrName);
                        if (attribute == null) continue;
                        attrName = defaultAttrName;
                        break;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)attrName)) {
                    attrName = "qualifiedName";
                }
            }
            SearchParameters searchParams = new SearchParameters();
            SearchParameters.FilterCriteria attrFilter = new SearchParameters.FilterCriteria();
            attrFilter.setAttributeName(StringUtils.isEmpty((CharSequence)attrName) ? "qualifiedName" : attrName);
            attrFilter.setOperator(SearchParameters.Operator.STARTS_WITH);
            attrFilter.setAttributeValue(attrValuePrefix);
            searchParams.setTypeName(typeName);
            searchParams.setEntityFilters(attrFilter);
            searchParams.setOffset(offset);
            searchParams.setLimit(limit);
            atlasSearchResult = this.searchWithParameters(searchParams);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasSearchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="basic")
    @POST
    @Timed
    public AtlasSearchResult searchWithParameters(SearchParameters parameters) throws AtlasBaseException {
        AtlasSearchResult atlasSearchResult;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.searchWithParameters(" + parameters + ")"));
            }
            if (parameters.getLimit() < 0 || parameters.getOffset() < 0) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Limit/offset should be non-negative"});
            }
            if (StringUtils.isEmpty((CharSequence)parameters.getTypeName()) && !this.isEmpty(parameters.getEntityFilters())) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"EntityFilters specified without Type name"});
            }
            if (StringUtils.isEmpty((CharSequence)parameters.getClassification()) && !this.isEmpty(parameters.getTagFilters())) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"TagFilters specified without tag name"});
            }
            if (StringUtils.isEmpty((CharSequence)parameters.getTypeName()) && StringUtils.isEmpty((CharSequence)parameters.getClassification()) && StringUtils.isEmpty((CharSequence)parameters.getQuery()) && StringUtils.isEmpty((CharSequence)parameters.getTermName())) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_SEARCH_PARAMS, new String[0]);
            }
            this.validateSearchParameters(parameters);
            atlasSearchResult = this.discoveryService.searchWithParameters(parameters);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasSearchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="relationship")
    @Timed
    public AtlasSearchResult searchRelatedEntities(@QueryParam(value="guid") String guid, @QueryParam(value="relation") String relation, @QueryParam(value="attributes") Set<String> attributes, @QueryParam(value="sortBy") String sortByAttribute, @QueryParam(value="sortOrder") SortOrder sortOrder, @QueryParam(value="excludeDeletedEntities") boolean excludeDeletedEntities, @QueryParam(value="includeClassificationAttributes") boolean includeClassificationAttributes, @QueryParam(value="getApproximateCount") boolean getApproximateCount, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        Servlets.validateQueryParamLength("relation", relation);
        Servlets.validateQueryParamLength("sortBy", sortByAttribute);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.relatedEntitiesSearch(" + guid + ", " + relation + ", " + sortByAttribute + ", " + sortOrder + ", " + excludeDeletedEntities + ", " + getApproximateCount + ", " + limit + ", " + offset + ")"));
            }
            SearchParameters parameters = new SearchParameters();
            parameters.setAttributes(attributes);
            parameters.setSortBy(sortByAttribute);
            parameters.setSortOrder(sortOrder);
            parameters.setExcludeDeletedEntities(excludeDeletedEntities);
            parameters.setLimit(limit);
            parameters.setOffset(offset);
            parameters.setIncludeClassificationAttributes(includeClassificationAttributes);
            AtlasSearchResult atlasSearchResult = this.discoveryService.searchRelatedEntities(guid, relation, getApproximateCount, parameters);
            return atlasSearchResult;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="saved")
    @Timed
    public AtlasUserSavedSearch addSavedSearch(AtlasUserSavedSearch savedSearch) throws AtlasBaseException, IOException {
        this.validateUserSavedSearch(savedSearch);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.addSavedSearch(userName=" + savedSearch.getOwnerName() + ", name=" + savedSearch.getName() + ", searchType=" + savedSearch.getSearchType() + ")"));
            }
            AtlasUserSavedSearch atlasUserSavedSearch = this.discoveryService.addSavedSearch(AtlasAuthorizationUtils.getCurrentUserName(), savedSearch);
            return atlasUserSavedSearch;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="saved")
    @Timed
    public AtlasUserSavedSearch updateSavedSearch(AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        this.validateUserSavedSearch(savedSearch);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.updateSavedSearch(userName=" + savedSearch.getOwnerName() + ", name=" + savedSearch.getName() + ", searchType=" + savedSearch.getSearchType() + ")"));
            }
            AtlasUserSavedSearch atlasUserSavedSearch = this.discoveryService.updateSavedSearch(AtlasAuthorizationUtils.getCurrentUserName(), savedSearch);
            return atlasUserSavedSearch;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="saved/{name}")
    @Timed
    public AtlasUserSavedSearch getSavedSearch(@PathParam(value="name") String searchName, @QueryParam(value="user") String userName) throws AtlasBaseException {
        Servlets.validateQueryParamLength("name", searchName);
        Servlets.validateQueryParamLength("user", userName);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.getSavedSearch(userName=" + userName + ", name=" + searchName + ")"));
            }
            AtlasUserSavedSearch atlasUserSavedSearch = this.discoveryService.getSavedSearchByName(AtlasAuthorizationUtils.getCurrentUserName(), userName, searchName);
            return atlasUserSavedSearch;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="saved")
    @Timed
    public List<AtlasUserSavedSearch> getSavedSearches(@QueryParam(value="user") String userName) throws AtlasBaseException {
        Servlets.validateQueryParamLength("user", userName);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.getSavedSearches(userName=" + userName + ")"));
            }
            List list = this.discoveryService.getSavedSearches(AtlasAuthorizationUtils.getCurrentUserName(), userName);
            return list;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    @DELETE
    @Path(value="saved/{guid}")
    @Timed
    public void deleteSavedSearch(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.deleteSavedSearch(guid=" + guid + ")"));
            }
            this.discoveryService.deleteSavedSearch(AtlasAuthorizationUtils.getCurrentUserName(), guid);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="saved/execute/{name}")
    @GET
    @Timed
    public AtlasSearchResult executeSavedSearchByName(@PathParam(value="name") String searchName, @QueryParam(value="user") String userName) throws AtlasBaseException {
        Servlets.validateQueryParamLength("name", searchName);
        Servlets.validateQueryParamLength("user", userName);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.executeSavedSearchByName(userName=" + userName + ", name=" + searchName + ")"));
            }
            AtlasUserSavedSearch savedSearch = this.discoveryService.getSavedSearchByName(AtlasAuthorizationUtils.getCurrentUserName(), userName, searchName);
            AtlasSearchResult atlasSearchResult = this.executeSavedSearch(savedSearch);
            return atlasSearchResult;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="saved/execute/guid/{guid}")
    @GET
    @Timed
    public AtlasSearchResult executeSavedSearchByGuid(@PathParam(value="guid") String searchGuid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", searchGuid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.executeSavedSearchByGuid(" + searchGuid + ")"));
            }
            AtlasUserSavedSearch savedSearch = this.discoveryService.getSavedSearchByGuid(AtlasAuthorizationUtils.getCurrentUserName(), searchGuid);
            AtlasSearchResult atlasSearchResult = this.executeSavedSearch(savedSearch);
            return atlasSearchResult;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/quick")
    @GET
    @Timed
    public AtlasQuickSearchResult quickSearch(@QueryParam(value="query") String query, @QueryParam(value="typeName") String typeName, @QueryParam(value="excludeDeletedEntities") boolean excludeDeletedEntities, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit) throws AtlasBaseException {
        if (StringUtils.isNotEmpty((CharSequence)query) && query.length() > this.maxFullTextQueryLength) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_QUERY_LENGTH, new String[]{"atlas.graph.fulltext-max-query-str-length"});
        }
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.quick(" + query + ",excludeDeletedEntities:" + excludeDeletedEntities + "," + limit + "," + offset + ")"));
            }
            QuickSearchParameters quickSearchParameters = new QuickSearchParameters(query, typeName, null, false, excludeDeletedEntities, offset, limit, null);
            AtlasQuickSearchResult atlasQuickSearchResult = this.discoveryService.quickSearch(quickSearchParameters);
            return atlasQuickSearchResult;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/quick")
    @POST
    @Timed
    public AtlasQuickSearchResult quickSearch(QuickSearchParameters quickSearchParameters) throws AtlasBaseException {
        AtlasQuickSearchResult atlasQuickSearchResult;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.searchWithParameters(" + quickSearchParameters + ")"));
            }
            if (quickSearchParameters.getLimit() < 0 || quickSearchParameters.getOffset() < 0) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"Limit/offset should be non-negative"});
            }
            if (StringUtils.isEmpty((CharSequence)quickSearchParameters.getTypeName()) && !this.isEmpty(quickSearchParameters.getEntityFilters())) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"EntityFilters specified without Type name"});
            }
            if (StringUtils.isEmpty((CharSequence)quickSearchParameters.getTypeName()) && StringUtils.isEmpty((CharSequence)quickSearchParameters.getQuery())) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_SEARCH_PARAMS, new String[0]);
            }
            this.validateSearchParameters(quickSearchParameters);
            atlasQuickSearchResult = this.discoveryService.quickSearch(quickSearchParameters);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasQuickSearchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="suggestions")
    @GET
    @Timed
    public AtlasSuggestionsResult getSuggestions(@QueryParam(value="prefixString") String prefixString, @QueryParam(value="fieldName") String fieldName) {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DiscoveryREST.getSuggestions(" + prefixString + "," + fieldName + ")"));
            }
            AtlasSuggestionsResult atlasSuggestionsResult = this.discoveryService.getSuggestions(prefixString, fieldName);
            return atlasSuggestionsResult;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    private boolean isEmpty(SearchParameters.FilterCriteria filterCriteria) {
        return filterCriteria == null || StringUtils.isEmpty((CharSequence)filterCriteria.getAttributeName()) && CollectionUtils.isEmpty((Collection)filterCriteria.getCriterion());
    }

    private AtlasSearchResult executeSavedSearch(AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        SearchParameters sp = savedSearch.getSearchParameters();
        if (savedSearch.getSearchType() == AtlasUserSavedSearch.SavedSearchType.ADVANCED) {
            String dslQuery = this.discoveryService.getDslQueryUsingTypeNameClassification(sp.getQuery(), sp.getTypeName(), sp.getClassification());
            return this.discoveryService.searchUsingDslQuery(dslQuery, sp.getLimit(), sp.getOffset());
        }
        return this.discoveryService.searchWithParameters(sp);
    }

    private void validateUserSavedSearch(AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        if (savedSearch != null) {
            Servlets.validateQueryParamLength("name", savedSearch.getName());
            Servlets.validateQueryParamLength("ownerName", savedSearch.getOwnerName());
            Servlets.validateQueryParamLength("guid", savedSearch.getGuid());
            this.validateSearchParameters(savedSearch.getSearchParameters());
        }
    }

    private void validateSearchParameters(SearchParameters parameters) throws AtlasBaseException {
        if (parameters != null) {
            Servlets.validateQueryParamLength("typeName", parameters.getTypeName());
            Servlets.validateQueryParamLength("classification", parameters.getClassification());
            Servlets.validateQueryParamLength("sortBy", parameters.getSortBy());
            if (StringUtils.isNotEmpty((CharSequence)parameters.getQuery()) && parameters.getQuery().length() > this.maxFullTextQueryLength) {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_QUERY_LENGTH, new String[]{"atlas.graph.fulltext-max-query-str-length"});
            }
        }
    }

    private void validateSearchParameters(QuickSearchParameters parameters) throws AtlasBaseException {
        if (parameters != null) {
            this.validateSearchParameters(EntityDiscoveryService.createSearchParameters((QuickSearchParameters)parameters));
        }
    }
}

