/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class AtlasAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static Logger LOG = LoggerFactory.getLogger(AuthenticationSuccessHandler.class);

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LOG.debug("Login Success " + authentication.getPrincipal());
        JSONObject json = new JSONObject();
        json.put((Object)"msgDesc", (Object)"Success");
        if (request.getSession() != null) {
            request.getSession().setAttribute("locallogin", (Object)"true");
            request.getServletContext().setAttribute(request.getSession().getId(), (Object)"locallogin");
        }
        response.setContentType("application/json");
        response.setStatus(200);
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(json.toJSONString());
    }
}

