/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.web.security.AtlasAbstractAuthenticationProvider;
import org.apache.commons.configuration.Configuration;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.adapters.springsecurity.authentication.KeycloakAuthenticationProvider;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class AtlasKeycloakAuthenticationProvider
extends AtlasAbstractAuthenticationProvider {
    private final boolean groupsFromUGI;
    private final String groupsClaim;
    private final KeycloakAuthenticationProvider keycloakAuthenticationProvider = new KeycloakAuthenticationProvider();

    public AtlasKeycloakAuthenticationProvider() throws Exception {
        Configuration configuration = ApplicationProperties.get();
        this.groupsFromUGI = configuration.getBoolean("atlas.authentication.method.keycloak.ugi-groups", true);
        this.groupsClaim = configuration.getString("atlas.authentication.method.keycloak.groups_claim");
    }

    public Authentication authenticate(Authentication authentication) {
        KeycloakAuthenticationToken token;
        Map claims;
        authentication = this.keycloakAuthenticationProvider.authenticate(authentication);
        if (this.groupsFromUGI) {
            List<GrantedAuthority> groups = AtlasKeycloakAuthenticationProvider.getAuthoritiesFromUGI(authentication.getName());
            KeycloakAuthenticationToken token2 = (KeycloakAuthenticationToken)authentication;
            authentication = new KeycloakAuthenticationToken((KeycloakAccount)token2.getAccount(), token2.isInteractive(), groups);
        } else if (this.groupsClaim != null && (claims = (token = (KeycloakAuthenticationToken)authentication).getAccount().getKeycloakSecurityContext().getToken().getOtherClaims()).containsKey(this.groupsClaim)) {
            List membership = (List)claims.get(this.groupsClaim);
            ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
            for (String group : membership) {
                grantedAuthorities.add(new SimpleGrantedAuthority(group));
            }
            authentication = new KeycloakAuthenticationToken((KeycloakAccount)token.getAccount(), token.isInteractive(), grantedAuthorities);
        }
        return authentication;
    }

    @Override
    public boolean supports(Class<?> aClass) {
        return this.keycloakAuthenticationProvider.supports(aClass);
    }
}

