/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Downsampling;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.io.util.MemoryOutputStream;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.WrappedSharedCloseable;

public class IndexSummary
extends WrappedSharedCloseable {
    public static final IndexSummarySerializer serializer = new IndexSummarySerializer();
    private final int minIndexInterval;
    private final IPartitioner partitioner;
    private final int sizeAtFullSampling;
    private final Memory offsets;
    private final int offsetCount;
    private final Memory entries;
    private final long entriesLength;
    private final int samplingLevel;

    public IndexSummary(IPartitioner partitioner, Memory offsets, int offsetCount, Memory entries, long entriesLength, int sizeAtFullSampling, int minIndexInterval, int samplingLevel) {
        super(new Memory[]{offsets, entries});
        assert (offsets.getInt(0L) == 0);
        this.partitioner = partitioner;
        this.minIndexInterval = minIndexInterval;
        this.offsetCount = offsetCount;
        this.entriesLength = entriesLength;
        this.sizeAtFullSampling = sizeAtFullSampling;
        this.offsets = offsets;
        this.entries = entries;
        this.samplingLevel = samplingLevel;
        assert (samplingLevel > 0);
    }

    private IndexSummary(IndexSummary copy) {
        super(copy);
        this.partitioner = copy.partitioner;
        this.minIndexInterval = copy.minIndexInterval;
        this.offsetCount = copy.offsetCount;
        this.entriesLength = copy.entriesLength;
        this.sizeAtFullSampling = copy.sizeAtFullSampling;
        this.offsets = copy.offsets;
        this.entries = copy.entries;
        this.samplingLevel = copy.samplingLevel;
    }

    public int binarySearch(RowPosition key) {
        int low = 0;
        int mid = this.offsetCount;
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = -DecoratedKey.compareTo(this.partitioner, ByteBuffer.wrap(this.getKey(mid)), key);
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    public int getPositionInSummary(int index) {
        return this.offsets.getInt(index << 2);
    }

    public byte[] getKey(int index) {
        long start = this.getPositionInSummary(index);
        int keySize = (int)(this.calculateEnd(index) - start - 8L);
        byte[] key = new byte[keySize];
        this.entries.getBytes(start, key, 0, keySize);
        return key;
    }

    public long getPosition(int index) {
        return this.entries.getLong(this.calculateEnd(index) - 8L);
    }

    public long getEndInSummary(int index) {
        return this.calculateEnd(index);
    }

    private long calculateEnd(int index) {
        return index == this.offsetCount - 1 ? this.entriesLength : (long)this.getPositionInSummary(index + 1);
    }

    public int getMinIndexInterval() {
        return this.minIndexInterval;
    }

    public double getEffectiveIndexInterval() {
        return 128.0 / (double)this.samplingLevel * (double)this.minIndexInterval;
    }

    public long getEstimatedKeyCount() {
        return ((long)this.getMaxNumberOfEntries() + 1L) * (long)this.minIndexInterval;
    }

    public int size() {
        return this.offsetCount;
    }

    public int getSamplingLevel() {
        return this.samplingLevel;
    }

    public int getMaxNumberOfEntries() {
        return this.sizeAtFullSampling;
    }

    long getEntriesLength() {
        return this.entriesLength;
    }

    Memory getOffsets() {
        return this.offsets;
    }

    Memory getEntries() {
        return this.entries;
    }

    long getOffHeapSize() {
        return (long)(this.offsetCount * 4) + this.entriesLength;
    }

    public int getEffectiveIndexIntervalAfterIndex(int index) {
        return Downsampling.getEffectiveIndexIntervalAfterIndex(index, this.samplingLevel, this.minIndexInterval);
    }

    @Override
    public IndexSummary sharedCopy() {
        return new IndexSummary(this);
    }

    public static class IndexSummarySerializer {
        public void serialize(IndexSummary t, DataOutputPlus out, boolean withSamplingLevel) throws IOException {
            out.writeInt(t.minIndexInterval);
            out.writeInt(t.offsetCount);
            out.writeLong(t.getOffHeapSize());
            if (withSamplingLevel) {
                out.writeInt(t.samplingLevel);
                out.writeInt(t.sizeAtFullSampling);
            }
            int baseOffset = t.offsetCount * 4;
            for (int i = 0; i < t.offsetCount; ++i) {
                int offset = t.offsets.getInt(i * 4) + baseOffset;
                if (ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN) {
                    offset = Integer.reverseBytes(offset);
                }
                out.writeInt(offset);
            }
            out.write(t.entries, 0L, t.entriesLength);
        }

        public IndexSummary deserialize(DataInputStream in, IPartitioner partitioner, boolean haveSamplingLevel, int expectedMinIndexInterval, int maxIndexInterval) throws IOException {
            int fullSamplingSummarySize;
            int samplingLevel;
            int minIndexInterval = in.readInt();
            if (minIndexInterval != expectedMinIndexInterval) {
                throw new IOException(String.format("Cannot read index summary because min_index_interval changed from %d to %d.", minIndexInterval, expectedMinIndexInterval));
            }
            int offsetCount = in.readInt();
            long offheapSize = in.readLong();
            if (haveSamplingLevel) {
                samplingLevel = in.readInt();
                fullSamplingSummarySize = in.readInt();
            } else {
                samplingLevel = 128;
                fullSamplingSummarySize = offsetCount;
            }
            int effectiveIndexInterval = (int)Math.ceil(128.0 / (double)samplingLevel * (double)minIndexInterval);
            if (effectiveIndexInterval > maxIndexInterval) {
                throw new IOException(String.format("Rebuilding index summary because the effective index interval (%d) is higher than the current max index interval (%d)", effectiveIndexInterval, maxIndexInterval));
            }
            Memory offsets = Memory.allocate(offsetCount * 4);
            Memory entries = Memory.allocate(offheapSize - offsets.size());
            FBUtilities.copy(in, new MemoryOutputStream(offsets), offsets.size());
            FBUtilities.copy(in, new MemoryOutputStream(entries), entries.size());
            int i = 0;
            while ((long)i < offsets.size()) {
                offsets.setInt(i, (int)((long)offsets.getInt(i) - offsets.size()));
                i += 4;
            }
            return new IndexSummary(partitioner, offsets, offsetCount, entries, entries.size(), fullSamplingSummarySize, minIndexInterval, samplingLevel);
        }
    }
}

