/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.remote;

import java.lang.reflect.Constructor;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;

public interface RemoteConnection
extends AutoCloseable {
    public static final String GREMLIN_REMOTE = "gremlin.remote.";
    public static final String GREMLIN_REMOTE_CONNECTION_CLASS = "gremlin.remote.remoteConnectionClass";

    public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(Bytecode var1) throws RemoteConnectionException;

    public static RemoteConnection from(Configuration conf) {
        if (!conf.containsKey(GREMLIN_REMOTE_CONNECTION_CLASS)) {
            throw new IllegalArgumentException("Configuration must contain the 'gremlin.remote.remoteConnectionClass' key");
        }
        try {
            Class<RemoteConnection> clazz = Class.forName(conf.getString(GREMLIN_REMOTE_CONNECTION_CLASS)).asSubclass(RemoteConnection.class);
            Constructor<RemoteConnection> ctor = clazz.getConstructor(Configuration.class);
            return ctor.newInstance(conf);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

