/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class BytecodeHelper {
    private BytecodeHelper() {
    }

    public static <A extends TraversalStrategy> Iterator<A> findStrategies(Bytecode bytecode, Class<A> clazz) {
        return IteratorUtils.map(IteratorUtils.filter(bytecode.getSourceInstructions().iterator(), s -> s.getOperator().equals("withStrategies") && clazz.isAssignableFrom(s.getArguments()[0].getClass())), os -> (TraversalStrategy)os.getArguments()[0]);
    }

    public static Bytecode filterInstructions(Bytecode bytecode, Predicate<Bytecode.Instruction> predicate) {
        Bytecode clone = new Bytecode();
        for (Bytecode.Instruction instruction : bytecode.getSourceInstructions()) {
            if (!predicate.test(instruction)) continue;
            clone.addSource(instruction.getOperator(), instruction.getArguments());
        }
        for (Bytecode.Instruction instruction : bytecode.getStepInstructions()) {
            if (!predicate.test(instruction)) continue;
            clone.addStep(instruction.getOperator(), instruction.getArguments());
        }
        return clone;
    }

    public static Optional<String> getLambdaLanguage(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            for (Object object : instruction.getArguments()) {
                Optional<String> temp;
                if (object instanceof Lambda) {
                    return Optional.of(((Lambda)object).getLambdaLanguage());
                }
                if (!(object instanceof Bytecode) || !(temp = BytecodeHelper.getLambdaLanguage((Bytecode)object)).isPresent()) continue;
                return temp;
            }
        }
        return Optional.empty();
    }

    public static void removeBindings(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            Object[] arguments = instruction.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] instanceof Bytecode.Binding) {
                    arguments[i] = ((Bytecode.Binding)arguments[i]).value();
                    continue;
                }
                if (!(arguments[i] instanceof Bytecode)) continue;
                BytecodeHelper.removeBindings((Bytecode)arguments[i]);
            }
        }
    }

    public static void detachElements(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            Object[] arguments = instruction.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] instanceof Bytecode) {
                    BytecodeHelper.detachElements((Bytecode)arguments[i]);
                    continue;
                }
                if (arguments[i] instanceof List) {
                    ArrayList list = new ArrayList();
                    for (Object object : (List)arguments[i]) {
                        list.add(DetachedFactory.detach(object, false));
                    }
                    arguments[i] = list;
                    continue;
                }
                arguments[i] = DetachedFactory.detach(arguments[i], false);
            }
        }
    }
}

