/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.internal;

import com.google.common.base.Preconditions;

public class ElementLifeCycle {
    public static final byte New = 1;
    public static final byte Loaded = 2;
    private static final byte AddedRelations = 3;
    private static final byte RemovedRelations = 4;
    private static final byte Modified = 5;
    public static final byte Removed = 6;

    public static boolean isModified(byte lifecycle) {
        return lifecycle >= 3 && lifecycle <= 5;
    }

    public static boolean hasRemovedRelations(byte lifecycle) {
        return lifecycle == 4 || lifecycle == 5;
    }

    public static boolean hasAddedRelations(byte lifecycle) {
        return lifecycle == 3 || lifecycle == 5;
    }

    public static boolean isNew(byte lifecycle) {
        return lifecycle == 1;
    }

    public static boolean isLoaded(byte lifecycle) {
        return lifecycle == 2;
    }

    public static boolean isRemoved(byte lifecycle) {
        return lifecycle == 6;
    }

    public static boolean isValid(byte lifecycle) {
        return lifecycle >= 1 && lifecycle <= 6;
    }

    public static byte update(byte lifecycle, Event event) {
        Preconditions.checkArgument((boolean)ElementLifeCycle.isValid(lifecycle), (Object)("Invalid element state: " + lifecycle));
        if (event == Event.REMOVED) {
            return 6;
        }
        if (lifecycle == 1 || lifecycle == 5) {
            return lifecycle;
        }
        if (lifecycle == 6) {
            throw new IllegalStateException("No event can occur on deleted vertices: " + (Object)((Object)event));
        }
        if (event == Event.REMOVED_RELATION) {
            switch (lifecycle) {
                case 2: {
                    return 4;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 4;
                }
            }
            throw new IllegalStateException("Unexpected state: " + lifecycle + " - " + (Object)((Object)event));
        }
        if (event == Event.ADDED_RELATION) {
            switch (lifecycle) {
                case 2: {
                    return 3;
                }
                case 4: {
                    return 5;
                }
                case 3: {
                    return 3;
                }
            }
            throw new IllegalStateException("Unexpected state: " + lifecycle + " - " + (Object)((Object)event));
        }
        if (event == Event.UPDATE) {
            return 5;
        }
        throw new IllegalStateException("Unexpected state event: " + lifecycle + " - " + (Object)((Object)event));
    }

    public static enum Event {
        REMOVED,
        REMOVED_RELATION,
        ADDED_RELATION,
        UPDATE;

    }
}

