/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.serialize.AttributeHandler;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.StandardRelationTypeMaker;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;

public class StandardPropertyKeyMaker
extends StandardRelationTypeMaker
implements PropertyKeyMaker {
    private Class<?> dataType;
    private boolean cardinalityIsSet;

    public StandardPropertyKeyMaker(StandardJanusGraphTx tx, String name, IndexSerializer indexSerializer, AttributeHandler attributeHandler) {
        super(tx, name, indexSerializer, attributeHandler);
        this.cardinality(Cardinality.SINGLE);
        this.cardinalityIsSet = false;
    }

    @Override
    JanusGraphSchemaCategory getSchemaCategory() {
        return JanusGraphSchemaCategory.PROPERTYKEY;
    }

    @Override
    public StandardPropertyKeyMaker dataType(Class<?> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Need to specify a data type");
        this.dataType = clazz;
        return this;
    }

    @Override
    public StandardPropertyKeyMaker cardinality(Cardinality cardinality) {
        super.multiplicity(Multiplicity.convert(cardinality));
        this.cardinalityIsSet = true;
        return this;
    }

    @Override
    public StandardPropertyKeyMaker cardinality(VertexProperty.Cardinality cardinality) {
        super.multiplicity(Multiplicity.convert(cardinality));
        this.cardinalityIsSet = true;
        return this;
    }

    @Override
    public boolean cardinalityIsSet() {
        return this.cardinalityIsSet;
    }

    @Override
    public StandardPropertyKeyMaker invisible() {
        super.invisible();
        return this;
    }

    @Override
    public StandardPropertyKeyMaker signature(PropertyKey ... types) {
        super.signature(types);
        return this;
    }

    @Override
    public StandardPropertyKeyMaker sortKey(PropertyKey ... types) {
        super.sortKey(types);
        return this;
    }

    @Override
    public StandardPropertyKeyMaker sortOrder(Order order) {
        super.sortOrder(order);
        return this;
    }

    @Override
    public PropertyKey make() {
        Preconditions.checkArgument((this.dataType != null ? 1 : 0) != 0, (Object)"Need to specify a datatype");
        Preconditions.checkArgument((boolean)this.tx.validDataType(this.dataType), (String)"Not a supported data type: %s", (Object[])new Object[]{this.dataType});
        Preconditions.checkArgument((!this.dataType.isPrimitive() ? 1 : 0) != 0, (String)"Primitive types are not supported. Use the corresponding wrapper class, e.g. Integer.class instead of int.class [%s]", (Object[])new Object[]{this.dataType});
        Preconditions.checkArgument((!this.dataType.isInterface() ? 1 : 0) != 0, (String)"Datatype must be a class and not an interface: %s", (Object[])new Object[]{this.dataType});
        Preconditions.checkArgument((this.dataType.isArray() || !Modifier.isAbstract(this.dataType.getModifiers()) ? 1 : 0) != 0, (String)"Datatype cannot be an abstract class: %s", (Object[])new Object[]{this.dataType});
        TypeDefinitionMap definition = this.makeDefinition();
        definition.setValue(TypeDefinitionCategory.DATATYPE, this.dataType);
        return this.tx.makePropertyKey(this.getName(), definition);
    }
}

