/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.scan;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.formats.cql.CqlBinaryInputFormat;
import org.janusgraph.hadoop.scan.AbstractHadoopScanRunner;
import org.janusgraph.hadoop.scan.HadoopScanRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLHadoopScanRunner
extends AbstractHadoopScanRunner<CQLHadoopScanRunner> {
    private static final Logger log = LoggerFactory.getLogger(CQLHadoopScanRunner.class);
    private static final String CASSANDRA_PARTITIONER_KEY = "cassandra.input.partitioner.class";
    private String partitionerOverride;

    public CQLHadoopScanRunner(ScanJob scanJob) {
        super(scanJob);
    }

    public CQLHadoopScanRunner(VertexScanJob vertexScanJob) {
        super(vertexScanJob);
    }

    protected CQLHadoopScanRunner self() {
        return this;
    }

    public CQLHadoopScanRunner partitionerOverride(String partitionerOverride) {
        this.partitionerOverride = partitionerOverride;
        return this;
    }

    public ScanMetrics run() throws InterruptedException, IOException, ClassNotFoundException {
        org.apache.hadoop.conf.Configuration hadoopConf;
        org.apache.hadoop.conf.Configuration configuration = hadoopConf = null != this.baseHadoopConf ? this.baseHadoopConf : new org.apache.hadoop.conf.Configuration();
        if (null != this.janusgraphConf) {
            for (String k : this.janusgraphConf.getKeys("")) {
                String prefix = ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".";
                hadoopConf.set(prefix + k, this.janusgraphConf.get(k, Object.class).toString());
                log.debug("Set: {}={}", (Object)(prefix + k), (Object)this.janusgraphConf.get(k, Object.class).toString());
            }
        }
        if (null != this.partitionerOverride) {
            hadoopConf.set(CASSANDRA_PARTITIONER_KEY, this.partitionerOverride);
        }
        if (null == hadoopConf.get(CASSANDRA_PARTITIONER_KEY)) {
            throw new IllegalArgumentException("cassandra.input.partitioner.class must be provided in either the base Hadoop Configuration object or by the partitionerOverride method");
        }
        log.debug("Partitioner: {}={}", (Object)CASSANDRA_PARTITIONER_KEY, (Object)hadoopConf.get(CASSANDRA_PARTITIONER_KEY));
        Preconditions.checkNotNull((Object)hadoopConf);
        if (null != this.scanJob) {
            return HadoopScanRunner.runScanJob((ScanJob)this.scanJob, (Configuration)this.scanJobConf, (String)this.scanJobConfRoot, (org.apache.hadoop.conf.Configuration)hadoopConf, CqlBinaryInputFormat.class);
        }
        return HadoopScanRunner.runVertexScanJob((VertexScanJob)this.vertexScanJob, (Configuration)this.scanJobConf, (String)this.scanJobConfRoot, (org.apache.hadoop.conf.Configuration)hadoopConf, CqlBinaryInputFormat.class);
    }
}

