/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.google.common.collect.Iterators;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Attributes;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFName;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnCondition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnNameBuilder;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Operation;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Relation;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.UpdateParameters;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.VariableSpecifications;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.ModificationStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Restriction;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletionInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class DeleteStatement
extends ModificationStatement {
    private DeleteStatement(ModificationStatement.StatementType type, CFMetaData cfm, Attributes attrs) {
        super(type, cfm, attrs);
    }

    @Override
    public boolean requireFullClusteringKey() {
        return false;
    }

    @Override
    public void addUpdateForKey(ColumnFamily cf, ByteBuffer key, ColumnNameBuilder builder, UpdateParameters params) throws InvalidRequestException {
        boolean isRange;
        boolean fullKey;
        CFDefinition cfDef = this.cfm.getCfDef();
        List<Operation> deletions = this.getOperations();
        boolean bl = fullKey = builder.componentCount() == cfDef.clusteringColumnsCount();
        boolean bl2 = cfDef.isCompact ? !fullKey : (isRange = !fullKey || deletions.isEmpty());
        if (!deletions.isEmpty() && isRange) {
            for (Operation deletion : deletions) {
                if (this.cfm.getCfDef().get((ColumnIdentifier)deletion.columnName).kind == CFDefinition.Name.Kind.STATIC) continue;
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s since %s specified", this.getFirstEmptyKey(), deletion.columnName));
            }
            throw new AssertionError();
        }
        if (deletions.isEmpty() && builder.componentCount() == 0) {
            cf.delete(new DeletionInfo(params.timestamp, params.localDeletionTime));
        } else if (isRange) {
            assert (deletions.isEmpty());
            ByteBuffer start = builder.build();
            ByteBuffer end = builder.buildAsEndOfRange();
            cf.addAtom(params.makeRangeTombstone(start, end));
        } else if (cfDef.isCompact) {
            ByteBuffer columnName = builder.build();
            cf.addColumn(params.makeTombstone(columnName));
        } else {
            for (Operation deletion : deletions) {
                deletion.execute(key, cf, builder.copy(), params);
            }
        }
    }

    @Override
    protected void validateWhereClauseForConditions() throws InvalidRequestException {
        Iterator iterator = Iterators.concat(this.cfm.getCfDef().partitionKeys().iterator(), this.cfm.getCfDef().clusteringColumns().iterator());
        while (iterator.hasNext()) {
            CFDefinition.Name name = (CFDefinition.Name)iterator.next();
            Restriction restriction = (Restriction)this.processedKeys.get(name.name);
            if (restriction != null && (restriction.isEQ() || restriction.isIN())) continue;
            throw new InvalidRequestException(String.format("DELETE statements must restrict all PRIMARY KEY columns with equality relations in order to use IF conditions, but column '%s' is not restricted", name.name));
        }
    }

    public static class Parsed
    extends ModificationStatement.Parsed {
        private final List<Operation.RawDeletion> deletions;
        private final List<Relation> whereClause;

        public Parsed(CFName name, Attributes.Raw attrs, List<Operation.RawDeletion> deletions, List<Relation> whereClause, List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions, boolean ifExists) {
            super(name, attrs, conditions, false, ifExists);
            this.deletions = deletions;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFDefinition cfDef, VariableSpecifications boundNames, Attributes attrs) throws InvalidRequestException {
            DeleteStatement stmt = new DeleteStatement(ModificationStatement.StatementType.DELETE, cfDef.cfm, attrs);
            for (Operation.RawDeletion deletion : this.deletions) {
                ColumnIdentifier id = deletion.affectedColumn().prepare(cfDef.cfm);
                CFDefinition.Name name = cfDef.get(id);
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", id));
                }
                if (name.isPrimaryKeyColumn()) {
                    throw new InvalidRequestException(String.format("Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", name));
                }
                Operation op = deletion.prepare(name, cfDef.cfm);
                op.collectMarkerSpecification(boundNames);
                stmt.addOperation(op);
            }
            stmt.processWhereClause(this.whereClause, boundNames);
            return stmt;
        }
    }
}

