/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Auth;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.DataResource;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.IResource;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Permission;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.PermissionDetails;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Resources;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnSpecification;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ResultSet;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.AuthorizationStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.UTF8Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestExecutionException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ListPermissionsStatement
extends AuthorizationStatement {
    private static final String KS = "system_auth";
    private static final String CF = "permissions";
    private static final List<ColumnSpecification> metadata;
    private final Set<Permission> permissions;
    private DataResource resource;
    private final String username;
    private final boolean recursive;

    public ListPermissionsStatement(Set<Permission> permissions, IResource resource, String username, boolean recursive) {
        this.permissions = permissions;
        this.resource = (DataResource)resource;
        this.username = username;
        this.recursive = recursive;
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (this.username != null && !Auth.isExistingUser(this.username)) {
            throw new InvalidRequestException(String.format("User %s doesn't exist", this.username));
        }
        if (this.resource != null) {
            this.resource = ListPermissionsStatement.maybeCorrectResource(this.resource, state);
            if (!this.resource.exists()) {
                throw new InvalidRequestException(String.format("%s doesn't exist", this.resource));
            }
        }
    }

    @Override
    public void checkAccess(ClientState state) {
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        ArrayList<PermissionDetails> details = new ArrayList<PermissionDetails>();
        if (this.resource != null && this.recursive) {
            for (IResource iResource : Resources.chain(this.resource)) {
                details.addAll(this.list(state, iResource));
            }
        } else {
            details.addAll(this.list(state, this.resource));
        }
        Collections.sort(details);
        return this.resultMessage(details);
    }

    private ResultMessage resultMessage(List<PermissionDetails> details) {
        if (details.isEmpty()) {
            return new ResultMessage.Void();
        }
        ResultSet result = new ResultSet(metadata);
        for (PermissionDetails pd : details) {
            result.addColumnValue(UTF8Type.instance.decompose(pd.username));
            result.addColumnValue(UTF8Type.instance.decompose(pd.resource.toString()));
            result.addColumnValue(UTF8Type.instance.decompose(pd.permission.toString()));
        }
        return new ResultMessage.Rows(result);
    }

    private Set<PermissionDetails> list(ClientState state, IResource resource) throws RequestValidationException, RequestExecutionException {
        return DatabaseDescriptor.getAuthorizer().list(state.getUser(), this.permissions, resource, this.username);
    }

    static {
        ArrayList<ColumnSpecification> columns = new ArrayList<ColumnSpecification>(4);
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("username", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("resource", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("permission", true), UTF8Type.instance));
        metadata = Collections.unmodifiableList(columns);
    }
}

