/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.CounterMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class CounterMutationSerializer
implements IVersionedSerializer<CounterMutation> {
    CounterMutationSerializer() {
    }

    @Override
    public void serialize(CounterMutation cm, DataOutput out, int version) throws IOException {
        RowMutation.serializer.serialize(cm.rowMutation(), out, version);
        out.writeUTF(cm.consistency().name());
    }

    @Override
    public CounterMutation deserialize(DataInput in, int version) throws IOException {
        RowMutation rm = RowMutation.serializer.deserialize(in, version);
        ConsistencyLevel consistency = Enum.valueOf(ConsistencyLevel.class, in.readUTF());
        return new CounterMutation(rm, consistency);
    }

    @Override
    public long serializedSize(CounterMutation cm, int version) {
        return RowMutation.serializer.serializedSize(cm.rowMutation(), version) + (long)TypeSizes.NATIVE.sizeof(cm.consistency().name());
    }
}

