/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.dht;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Bounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.IPartitioner;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Range;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.RingPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractBounds<T extends RingPosition>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final AbstractBoundsSerializer serializer = new AbstractBoundsSerializer();
    public final T left;
    public final T right;
    protected final transient IPartitioner partitioner;

    public AbstractBounds(T left, T right, IPartitioner partitioner) {
        this.left = left;
        this.right = right;
        this.partitioner = partitioner;
    }

    public abstract Pair<AbstractBounds<T>, AbstractBounds<T>> split(T var1);

    public int hashCode() {
        return 31 * this.left.hashCode() + this.right.hashCode();
    }

    public boolean intersects(Iterable<Range<T>> ranges) {
        for (Range<T> range2 : ranges) {
            if (!range2.intersects(this)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean contains(T var1);

    public abstract List<? extends AbstractBounds<T>> unwrap();

    public String getString(AbstractType<?> keyValidator) {
        return this.getOpeningString() + this.format(this.left, keyValidator) + ", " + this.format(this.right, keyValidator) + this.getClosingString();
    }

    private String format(T value, AbstractType<?> keyValidator) {
        if (value instanceof DecoratedKey) {
            return keyValidator.getString(((DecoratedKey)value).key);
        }
        return value.toString();
    }

    protected abstract String getOpeningString();

    protected abstract String getClosingString();

    public abstract AbstractBounds<RowPosition> toRowBounds();

    public abstract AbstractBounds<Token> toTokenBounds();

    public abstract AbstractBounds<T> withNewRight(T var1);

    public static class AbstractBoundsSerializer
    implements IVersionedSerializer<AbstractBounds<?>> {
        @Override
        public void serialize(AbstractBounds<?> range, DataOutput out, int version) throws IOException {
            out.writeInt(this.kindInt(range));
            if (range.left instanceof Token) {
                Token.serializer.serialize((Token)range.left, out);
                Token.serializer.serialize((Token)range.right, out);
            } else {
                RowPosition.serializer.serialize((RowPosition)range.left, out);
                RowPosition.serializer.serialize((RowPosition)range.right, out);
            }
        }

        private int kindInt(AbstractBounds<?> ab) {
            int kind;
            int n = kind = ab instanceof Range ? Type.RANGE.ordinal() : Type.BOUNDS.ordinal();
            if (!(ab.left instanceof Token)) {
                kind = -(kind + 1);
            }
            return kind;
        }

        @Override
        public AbstractBounds<?> deserialize(DataInput in, int version) throws IOException {
            RingPosition right;
            RingPosition left;
            boolean isToken;
            int kind = in.readInt();
            boolean bl = isToken = kind >= 0;
            if (!isToken) {
                kind = -(kind + 1);
            }
            if (isToken) {
                left = Token.serializer.deserialize(in);
                right = Token.serializer.deserialize(in);
            } else {
                left = RowPosition.serializer.deserialize(in);
                right = RowPosition.serializer.deserialize(in);
            }
            if (kind == Type.RANGE.ordinal()) {
                return new Range<Token>((Token)left, (Token)right);
            }
            return new Bounds<Token>((Token)left, (Token)right);
        }

        @Override
        public long serializedSize(AbstractBounds<?> ab, int version) {
            int size = TypeSizes.NATIVE.sizeof(this.kindInt(ab));
            if (ab.left instanceof Token) {
                size = (int)((long)size + Token.serializer.serializedSize((Token)ab.left, TypeSizes.NATIVE));
                size = (int)((long)size + Token.serializer.serializedSize((Token)ab.right, TypeSizes.NATIVE));
            } else {
                size = (int)((long)size + RowPosition.serializer.serializedSize((RowPosition)ab.left, TypeSizes.NATIVE));
                size = (int)((long)size + RowPosition.serializer.serializedSize((RowPosition)ab.right, TypeSizes.NATIVE));
            }
            return size;
        }
    }

    private static enum Type {
        RANGE,
        BOUNDS;

    }
}

