/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.dht;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.IntegerType;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.AbstractPartitioner;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.BigIntegerToken;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.GuidGenerator;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RandomPartitioner
extends AbstractPartitioner<BigIntegerToken> {
    public static final BigInteger ZERO = new BigInteger("0");
    public static final BigIntegerToken MINIMUM = new BigIntegerToken("-1");
    public static final BigInteger MAXIMUM = new BigInteger("2").pow(127);
    private final Token.TokenFactory<BigInteger> tokenFactory = new Token.TokenFactory<BigInteger>(){

        @Override
        public ByteBuffer toByteArray(Token<BigInteger> bigIntegerToken) {
            return ByteBuffer.wrap(((BigInteger)bigIntegerToken.token).toByteArray());
        }

        @Override
        public Token<BigInteger> fromByteArray(ByteBuffer bytes) {
            return new BigIntegerToken(new BigInteger(ByteBufferUtil.getArray(bytes)));
        }

        @Override
        public String toString(Token<BigInteger> bigIntegerToken) {
            return ((BigInteger)bigIntegerToken.token).toString();
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            try {
                BigInteger i = new BigInteger(token);
                if (i.compareTo(ZERO) < 0) {
                    throw new ConfigurationException("Token must be >= 0");
                }
                if (i.compareTo(MAXIMUM) > 0) {
                    throw new ConfigurationException("Token must be <= 2**127");
                }
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e.getMessage());
            }
        }

        @Override
        public Token<BigInteger> fromString(String string) {
            return new BigIntegerToken(new BigInteger(string));
        }
    };

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        return new DecoratedKey(this.getToken(key), key);
    }

    @Override
    public Token midpoint(Token ltoken, Token rtoken) {
        BigInteger left = ltoken.equals(MINIMUM) ? ZERO : (BigInteger)((BigIntegerToken)ltoken).token;
        BigInteger right = rtoken.equals(MINIMUM) ? ZERO : (BigInteger)((BigIntegerToken)rtoken).token;
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 127);
        return new BigIntegerToken((BigInteger)midpair.left);
    }

    @Override
    public BigIntegerToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BigIntegerToken getRandomToken() {
        BigInteger token = FBUtilities.hashToBigInteger(GuidGenerator.guidAsBytes());
        if (token.signum() == -1) {
            token = token.multiply(BigInteger.valueOf(-1L));
        }
        return new BigIntegerToken(token);
    }

    @Override
    public Token.TokenFactory<BigInteger> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return false;
    }

    @Override
    public BigIntegerToken getToken(ByteBuffer key) {
        if (key.remaining() == 0) {
            return MINIMUM;
        }
        return new BigIntegerToken(FBUtilities.hashToBigInteger(key));
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> ownerships = new HashMap<Token, Float>();
        Iterator<Token> i = sortedTokens.iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("No nodes present in the cluster. Has this node finished starting up?");
        }
        if (sortedTokens.size() == 1) {
            ownerships.put(i.next(), new Float(1.0));
        } else {
            float x;
            BigInteger ti;
            BigInteger ri = MAXIMUM;
            BigDecimal r = new BigDecimal(ri);
            Token start = i.next();
            BigInteger tim1 = ti = (BigInteger)((BigIntegerToken)start).token;
            while (i.hasNext()) {
                Token t = i.next();
                ti = (BigInteger)((BigIntegerToken)t).token;
                x = new BigDecimal(ti.subtract(tim1).add(ri).mod(ri)).divide(r).floatValue();
                ownerships.put(t, Float.valueOf(x));
                tim1 = ti;
            }
            x = new BigDecimal(((BigInteger)((BigIntegerToken)start).token).subtract(ti).add(ri).mod(ri)).divide(r).floatValue();
            ownerships.put(start, Float.valueOf(x));
        }
        return ownerships;
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return IntegerType.instance;
    }
}

