/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.dht;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.IPartitioner;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.RingPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.ISerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;

public abstract class Token<T>
implements RingPosition<Token<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final TokenSerializer serializer = new TokenSerializer();
    public final T token;

    protected Token(T token) {
        this.token = token;
    }

    @Override
    public abstract int compareTo(Token<T> var1);

    public String toString() {
        return this.token.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.token.equals(((Token)obj).token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    @Override
    public Token<T> getToken() {
        return this;
    }

    @Override
    public boolean isMinimum(IPartitioner partitioner) {
        return this.equals(partitioner.getMinimumToken());
    }

    public boolean isMinimum() {
        return this.isMinimum(StorageService.getPartitioner());
    }

    public KeyBound minKeyBound(IPartitioner partitioner) {
        return new KeyBound(this, true);
    }

    public KeyBound minKeyBound() {
        return this.minKeyBound(null);
    }

    public KeyBound maxKeyBound(IPartitioner partitioner) {
        if (this.isMinimum(partitioner)) {
            return this.minKeyBound();
        }
        return new KeyBound(this, false);
    }

    public KeyBound maxKeyBound() {
        return this.maxKeyBound(StorageService.getPartitioner());
    }

    public <R extends RingPosition> R upperBound(Class<R> klass) {
        if (klass.equals(this.getClass())) {
            return (R)this;
        }
        return (R)this.maxKeyBound();
    }

    public static class KeyBound
    extends RowPosition {
        private final Token token;
        public final boolean isMinimumBound;

        private KeyBound(Token t, boolean isMinimumBound) {
            this.token = t;
            this.isMinimumBound = isMinimumBound;
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        @Override
        public int compareTo(RowPosition pos) {
            if (this == pos) {
                return 0;
            }
            int cmp = this.getToken().compareTo(pos.getToken());
            if (cmp != 0) {
                return cmp;
            }
            if (this.isMinimumBound) {
                return pos instanceof KeyBound && ((KeyBound)pos).isMinimumBound ? 0 : -1;
            }
            return pos instanceof KeyBound && !((KeyBound)pos).isMinimumBound ? 0 : 1;
        }

        @Override
        public boolean isMinimum(IPartitioner partitioner) {
            return this.getToken().isMinimum(partitioner);
        }

        @Override
        public RowPosition.Kind kind() {
            return this.isMinimumBound ? RowPosition.Kind.MIN_BOUND : RowPosition.Kind.MAX_BOUND;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            KeyBound other = (KeyBound)obj;
            return this.token.equals(other.token) && this.isMinimumBound == other.isMinimumBound;
        }

        public int hashCode() {
            return this.getToken().hashCode() + (this.isMinimumBound ? 0 : 1);
        }

        public String toString() {
            return String.format("%s(%s)", this.isMinimumBound ? "min" : "max", this.getToken().toString());
        }
    }

    public static class TokenSerializer
    implements ISerializer<Token> {
        @Override
        public void serialize(Token token, DataOutput out) throws IOException {
            IPartitioner p = StorageService.getPartitioner();
            ByteBuffer b = p.getTokenFactory().toByteArray(token);
            ByteBufferUtil.writeWithLength(b, out);
        }

        @Override
        public Token deserialize(DataInput in) throws IOException {
            IPartitioner p = StorageService.getPartitioner();
            int size = in.readInt();
            byte[] bytes = new byte[size];
            in.readFully(bytes);
            return p.getTokenFactory().fromByteArray(ByteBuffer.wrap(bytes));
        }

        @Override
        public long serializedSize(Token object, TypeSizes typeSizes) {
            IPartitioner p = StorageService.getPartitioner();
            ByteBuffer b = p.getTokenFactory().toByteArray(object);
            return TypeSizes.NATIVE.sizeof(b.remaining()) + b.remaining();
        }
    }

    public static abstract class TokenFactory<T> {
        public abstract ByteBuffer toByteArray(Token<T> var1);

        public abstract Token<T> fromByteArray(ByteBuffer var1);

        public abstract String toString(Token<T> var1);

        public abstract Token<T> fromString(String var1);

        public abstract void validate(String var1) throws ConfigurationException;
    }
}

