/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.serializers;

import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class CollectionSerializer<T>
implements TypeSerializer<T> {
    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
    }

    protected static ByteBuffer pack(List<ByteBuffer> buffers, int elements, int size) {
        ByteBuffer result = ByteBuffer.allocate(2 + size);
        result.putShort((short)elements);
        for (ByteBuffer bb : buffers) {
            result.putShort((short)bb.remaining());
            result.put(bb.duplicate());
        }
        return (ByteBuffer)result.flip();
    }

    public static ByteBuffer pack(List<ByteBuffer> buffers, int elements) {
        int size = 0;
        for (ByteBuffer bb : buffers) {
            size += 2 + bb.remaining();
        }
        return CollectionSerializer.pack(buffers, elements, size);
    }
}

