/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.serializers;

import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.CollectionSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListSerializer<T>
extends CollectionSerializer<List<T>> {
    private static final Map<TypeSerializer<?>, ListSerializer> instances = new HashMap();
    public final TypeSerializer<T> elements;

    public static synchronized <T> ListSerializer<T> getInstance(TypeSerializer<T> elements) {
        ListSerializer<T> t = instances.get(elements);
        if (t == null) {
            t = new ListSerializer<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    private ListSerializer(TypeSerializer<T> elements) {
        this.elements = elements;
    }

    @Override
    public List<T> deserialize(ByteBuffer bytes) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = ByteBufferUtil.readShortLength(input);
            ArrayList<T> l = new ArrayList<T>(n);
            for (int i = 0; i < n; ++i) {
                ByteBuffer databb = ByteBufferUtil.readBytesWithShortLength(input);
                this.elements.validate(databb);
                l.add(this.elements.deserialize(databb));
            }
            if (input.hasRemaining()) {
                throw new MarshalException("Unexpected extraneous bytes after list value");
            }
            return l;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    @Override
    public ByteBuffer serialize(List<T> value) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(value.size());
        int size = 0;
        for (T elt : value) {
            ByteBuffer bb = this.elements.serialize(elt);
            bbs.add(bb);
            size += 2 + bb.remaining();
        }
        return ListSerializer.pack(bbs, value.size(), size);
    }

    @Override
    public String toString(List<T> value) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("; ");
            }
            sb.append(this.elements.toString(element));
        }
        return sb.toString();
    }

    @Override
    public Class<List<T>> getType() {
        return List.class;
    }
}

