/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Range;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class StreamRequest {
    public static final IVersionedSerializer<StreamRequest> serializer = new StreamRequestSerializer();
    public final String keyspace;
    public final Collection<Range<Token>> ranges;
    public final Collection<String> columnFamilies = new HashSet<String>();

    public StreamRequest(String keyspace, Collection<Range<Token>> ranges, Collection<String> columnFamilies) {
        this.keyspace = keyspace;
        this.ranges = ranges;
        this.columnFamilies.addAll(columnFamilies);
    }

    public static class StreamRequestSerializer
    implements IVersionedSerializer<StreamRequest> {
        @Override
        public void serialize(StreamRequest request, DataOutput out, int version) throws IOException {
            out.writeUTF(request.keyspace);
            out.writeInt(request.ranges.size());
            for (Range<Token> range : request.ranges) {
                Token.serializer.serialize((Token)range.left, out);
                Token.serializer.serialize((Token)range.right, out);
            }
            out.writeInt(request.columnFamilies.size());
            for (String cf : request.columnFamilies) {
                out.writeUTF(cf);
            }
        }

        @Override
        public StreamRequest deserialize(DataInput in, int version) throws IOException {
            String keyspace = in.readUTF();
            int rangeCount = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(rangeCount);
            for (int i = 0; i < rangeCount; ++i) {
                Token left = Token.serializer.deserialize(in);
                Token right = Token.serializer.deserialize(in);
                ranges.add(new Range<Token>(left, right));
            }
            int cfCount = in.readInt();
            ArrayList<String> columnFamilies = new ArrayList<String>(cfCount);
            for (int i = 0; i < cfCount; ++i) {
                columnFamilies.add(in.readUTF());
            }
            return new StreamRequest(keyspace, ranges, columnFamilies);
        }

        @Override
        public long serializedSize(StreamRequest request, int version) {
            int size = TypeSizes.NATIVE.sizeof(request.keyspace);
            size += TypeSizes.NATIVE.sizeof(request.ranges.size());
            for (Range<Token> range : request.ranges) {
                size = (int)((long)size + Token.serializer.serializedSize((Token)range.left, TypeSizes.NATIVE));
                size = (int)((long)size + Token.serializer.serializedSize((Token)range.right, TypeSizes.NATIVE));
            }
            size += TypeSizes.NATIVE.sizeof(request.columnFamilies.size());
            for (String cf : request.columnFamilies) {
                size += TypeSizes.NATIVE.sizeof(cf);
            }
            return size;
        }
    }
}

