/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamSession;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.CompleteMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.IncomingFileMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.OutgoingFileMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.PrepareMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.ReceivedMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.RetryMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.SessionFailedMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public abstract class StreamMessage {
    public static final int CURRENT_VERSION = 1;
    public final Type type;

    public static void serialize(StreamMessage message, WritableByteChannel out, int version, StreamSession session) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate(1);
        buff.put(message.type.type);
        buff.flip();
        while (buff.hasRemaining()) {
            out.write(buff);
        }
        message.type.outSerializer.serialize(message, out, version, session);
    }

    public static StreamMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate(1);
        if (in.read(buff) > 0) {
            buff.flip();
            Type type = Type.get(buff.get());
            return type.inSerializer.deserialize(in, version, session);
        }
        return null;
    }

    protected StreamMessage(Type type) {
        this.type = type;
    }

    public int getPriority() {
        return this.type.priority;
    }

    public static enum Type {
        PREPARE(1, 5, PrepareMessage.serializer),
        FILE(2, 0, IncomingFileMessage.serializer, OutgoingFileMessage.serializer),
        RECEIVED(3, 4, ReceivedMessage.serializer),
        RETRY(4, 4, RetryMessage.serializer),
        COMPLETE(5, 1, CompleteMessage.serializer),
        SESSION_FAILED(6, 5, SessionFailedMessage.serializer);

        private final byte type;
        public final int priority;
        public final Serializer<StreamMessage> inSerializer;
        public final Serializer<StreamMessage> outSerializer;

        public static Type get(byte type) {
            for (Type t : Type.values()) {
                if (t.type != type) continue;
                return t;
            }
            throw new IllegalArgumentException("Unknown type " + type);
        }

        private Type(int type, int priority, Serializer serializer) {
            this(type, priority, serializer, serializer);
        }

        private Type(int type, int priority, Serializer inSerializer, Serializer outSerializer) {
            this.type = (byte)type;
            this.priority = priority;
            this.inSerializer = inSerializer;
            this.outSerializer = outSerializer;
        }
    }

    public static interface Serializer<V extends StreamMessage> {
        public V deserialize(ReadableByteChannel var1, int var2, StreamSession var3) throws IOException;

        public void serialize(V var1, WritableByteChannel var2, int var3, StreamSession var4) throws IOException;
    }
}

