/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasAccessRequest {
    private static Logger LOG = LoggerFactory.getLogger(AtlasAccessRequest.class);
    private static final String DEFAULT_ENTITY_ID_ATTRIBUTE = "qualifiedName";
    private final AtlasPrivilege action;
    private final Date accessTime;
    private String user = null;
    private Set<String> userGroups = null;
    private String clientIPAddress = null;
    private List<String> forwardedAddresses;
    private String remoteIPAddress;

    protected AtlasAccessRequest(AtlasPrivilege action) {
        this(action, null, null, new Date(), null);
    }

    protected AtlasAccessRequest(AtlasPrivilege action, String user, Set<String> userGroups) {
        this(action, user, userGroups, new Date(), null, null, null);
    }

    protected AtlasAccessRequest(AtlasPrivilege action, String user, Set<String> userGroups, Date accessTime, String clientIPAddress, List<String> forwardedAddresses, String remoteIPAddress) {
        this(action, user, userGroups, accessTime, clientIPAddress);
        this.forwardedAddresses = forwardedAddresses;
        this.remoteIPAddress = remoteIPAddress;
    }

    protected AtlasAccessRequest(AtlasPrivilege action, String user, Set<String> userGroups, Date accessTime, String clientIPAddress) {
        this.action = action;
        this.user = user;
        this.userGroups = userGroups;
        this.accessTime = accessTime;
        this.clientIPAddress = clientIPAddress;
    }

    public AtlasPrivilege getAction() {
        return this.action;
    }

    public Date getAccessTime() {
        return this.accessTime;
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    public void setUser(String user, Set<String> userGroups) {
        this.user = user;
        this.userGroups = userGroups;
    }

    public List<String> getForwardedAddresses() {
        return this.forwardedAddresses;
    }

    public String getRemoteIPAddress() {
        return this.remoteIPAddress;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setForwardedAddresses(List<String> forwardedAddresses) {
        this.forwardedAddresses = forwardedAddresses;
    }

    public void setRemoteIPAddress(String remoteIPAddress) {
        this.remoteIPAddress = remoteIPAddress;
    }

    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }

    public Set<String> getEntityTypeAndAllSuperTypes(String entityType, AtlasTypeRegistry typeRegistry) {
        AtlasEntityType entType;
        Set<String> ret = entityType == null ? Collections.emptySet() : (typeRegistry == null ? Collections.singleton(entityType) : ((entType = typeRegistry.getEntityTypeByName(entityType)) != null ? entType.getTypeAndAllSuperTypes() : Collections.singleton(entityType)));
        return ret;
    }

    public Set<String> getClassificationTypeAndAllSuperTypes(String classificationName, AtlasTypeRegistry typeRegistry) {
        Set<String> ret;
        if (classificationName == null) {
            ret = Collections.emptySet();
        } else if (typeRegistry == null) {
            ret = Collections.singleton(classificationName);
        } else {
            AtlasClassificationType classificationType = typeRegistry.getClassificationTypeByName(classificationName);
            return classificationType != null ? classificationType.getTypeAndAllSuperTypes() : Collections.singleton(classificationName);
        }
        return ret;
    }

    public String getEntityId(AtlasEntityHeader entity) {
        return this.getEntityId(entity, null);
    }

    public String getEntityId(AtlasEntityHeader entity, AtlasTypeRegistry typeRegistry) {
        Object ret;
        block3: {
            Map uniqAttributes;
            ret = null;
            if (entity == null) break block3;
            AtlasEntityType entityType = typeRegistry == null ? null : typeRegistry.getEntityTypeByName(entity.getTypeName());
            Map map = uniqAttributes = entityType == null ? null : entityType.getUniqAttributes();
            if (MapUtils.isEmpty((Map)uniqAttributes)) {
                ret = entity.getAttribute(DEFAULT_ENTITY_ID_ATTRIBUTE);
            } else {
                AtlasStructType.AtlasAttribute uniqAttribute;
                Iterator iterator = uniqAttributes.values().iterator();
                while (iterator.hasNext() && (ret = entity.getAttribute((uniqAttribute = (AtlasStructType.AtlasAttribute)iterator.next()).getName())) == null) {
                }
            }
        }
        return ret == null ? "" : ret.toString();
    }

    public Set<String> getClassificationNames(AtlasEntityHeader entity) {
        Set<String> ret;
        if (entity == null || entity.getClassifications() == null) {
            ret = Collections.emptySet();
        } else {
            ret = new HashSet<String>();
            for (AtlasClassification classify : entity.getClassifications()) {
                ret.add(classify.getTypeName());
            }
        }
        return ret;
    }

    public String toString() {
        return "AtlasAccessRequest[action=" + (Object)((Object)this.action) + ", accessTime=" + this.accessTime + ", user='" + this.user + '\'' + ", userGroups=" + this.userGroups + ", clientIPAddress='" + this.clientIPAddress + '\'' + ", forwardedAddresses=" + this.forwardedAddresses + ", remoteIPAddress='" + this.remoteIPAddress + '\'' + ']';
    }
}

