/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasNoneAuthorizer;
import org.apache.atlas.authorize.simple.AtlasSimpleAuthorizer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasAuthorizerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthorizerFactory.class);
    private static final String NONE_AUTHORIZER = AtlasNoneAuthorizer.class.getName();
    private static final String SIMPLE_AUTHORIZER = AtlasSimpleAuthorizer.class.getName();
    private static final String RANGER_AUTHORIZER = "org.apache.ranger.authorization.atlas.authorizer.RangerAtlasAuthorizer";
    private static volatile AtlasAuthorizer INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AtlasAuthorizer getAtlasAuthorizer() throws AtlasAuthorizationException {
        AtlasAuthorizer ret = INSTANCE;
        if (ret != null) return ret;
        Class<AtlasAuthorizerFactory> clazz = AtlasAuthorizerFactory.class;
        synchronized (AtlasAuthorizerFactory.class) {
            String authorizerClass;
            if (INSTANCE != null) return INSTANCE;
            Configuration configuration = null;
            try {
                configuration = ApplicationProperties.get();
            }
            catch (AtlasException e) {
                LOG.error("Exception while fetching configuration", (Throwable)e);
            }
            String string = authorizerClass = configuration != null ? configuration.getString("atlas.authorizer.impl") : "SIMPLE";
            if (StringUtils.isNotEmpty((String)authorizerClass)) {
                if (StringUtils.equalsIgnoreCase((String)authorizerClass, (String)"SIMPLE")) {
                    authorizerClass = SIMPLE_AUTHORIZER;
                } else if (StringUtils.equalsIgnoreCase((String)authorizerClass, (String)"RANGER")) {
                    authorizerClass = RANGER_AUTHORIZER;
                } else if (StringUtils.equalsIgnoreCase((String)authorizerClass, (String)"NONE")) {
                    authorizerClass = NONE_AUTHORIZER;
                }
            } else {
                authorizerClass = SIMPLE_AUTHORIZER;
            }
            LOG.info("Initializing Authorizer {}", (Object)authorizerClass);
            try {
                Class<?> authorizerMetaObject = Class.forName(authorizerClass);
                if (authorizerMetaObject == null) return INSTANCE;
                INSTANCE = (AtlasAuthorizer)authorizerMetaObject.newInstance();
                INSTANCE.init();
                return INSTANCE;
            }
            catch (Exception e) {
                LOG.error("Error while creating authorizer of type {}", (Object)authorizerClass, (Object)e);
                throw new AtlasAuthorizationException("Error while creating authorizer of type '" + authorizerClass + "'", e);
            }
        }
    }
}

