/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.authorize.AtlasAccessRequest;
import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasRelationshipAccessRequest;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.authorize.AtlasTypesDefFilterRequest;
import org.apache.atlas.authorize.simple.AtlasSimpleAuthzPolicy;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.utils.AtlasJson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtlasSimpleAuthorizer
implements AtlasAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasSimpleAuthorizer.class);
    private static final String WILDCARD_ASTERISK = "*";
    private static final Set<AtlasPrivilege> CLASSIFICATION_PRIVILEGES = new HashSet<AtlasPrivilege>(){
        {
            this.add(AtlasPrivilege.ENTITY_ADD_CLASSIFICATION);
            this.add(AtlasPrivilege.ENTITY_REMOVE_CLASSIFICATION);
            this.add(AtlasPrivilege.ENTITY_UPDATE_CLASSIFICATION);
        }
    };
    private AtlasSimpleAuthzPolicy authzPolicy;

    @Override
    public void init() {
        LOG.info("==> SimpleAtlasAuthorizer.init()");
        InputStream inputStream = null;
        try {
            inputStream = ApplicationProperties.getFileAsInputStream((Configuration)ApplicationProperties.get(), (String)"atlas.authorizer.simple.authz.policy.file", (String)"atlas-simple-authz-policy.json");
            this.authzPolicy = (AtlasSimpleAuthzPolicy)AtlasJson.fromJson((InputStream)inputStream, AtlasSimpleAuthzPolicy.class);
            this.addImpliedTypeReadPrivilege(this.authzPolicy);
        }
        catch (IOException | AtlasException e) {
            LOG.error("SimpleAtlasAuthorizer.init(): initialization failed", e);
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        LOG.info("<== SimpleAtlasAuthorizer.init()");
    }

    @Override
    public void cleanUp() {
        LOG.info("==> SimpleAtlasAuthorizer.cleanUp()");
        this.authzPolicy = null;
        LOG.info("<== SimpleAtlasAuthorizer.cleanUp()");
    }

    @Override
    public boolean isAccessAllowed(AtlasAdminAccessRequest request) throws AtlasAuthorizationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SimpleAtlasAuthorizer.isAccessAllowed({})", (Object)request);
        }
        boolean ret = false;
        Set<String> roles = this.getRoles(request.getUser(), request.getUserGroups());
        block0: for (String role : roles) {
            List<AtlasSimpleAuthzPolicy.AtlasAdminPermission> permissions = this.getAdminPermissionsForRole(role);
            if (permissions == null) continue;
            String action = request.getAction() != null ? request.getAction().getType() : null;
            for (AtlasSimpleAuthzPolicy.AtlasAdminPermission permission : permissions) {
                if (!this.isMatch(action, permission.getPrivileges())) continue;
                ret = true;
                continue block0;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== SimpleAtlasAuthorizer.isAccessAllowed({}): {}", (Object)request, (Object)ret);
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(AtlasTypeAccessRequest request) throws AtlasAuthorizationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SimpleAtlasAuthorizer.isAccessAllowed({})", (Object)request);
        }
        boolean ret = false;
        Set<String> roles = this.getRoles(request.getUser(), request.getUserGroups());
        block0: for (String role : roles) {
            List<AtlasSimpleAuthzPolicy.AtlasTypePermission> permissions = this.getTypePermissionsForRole(role);
            if (permissions == null) continue;
            String action = request.getAction() != null ? request.getAction().getType() : null;
            String typeCategory = request.getTypeDef() != null ? request.getTypeDef().getCategory().name() : null;
            String typeName = request.getTypeDef() != null ? request.getTypeDef().getName() : null;
            for (AtlasSimpleAuthzPolicy.AtlasTypePermission permission : permissions) {
                if (!this.isMatch(action, permission.getPrivileges()) || !this.isMatch(typeCategory, permission.getTypeCategories()) || !this.isMatch(typeName, permission.getTypeNames())) continue;
                ret = true;
                continue block0;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== SimpleAtlasAuthorizer.isAccessAllowed({}): {}", (Object)request, (Object)ret);
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(AtlasRelationshipAccessRequest request) throws AtlasAuthorizationException {
        Set<String> roles = this.getRoles(request.getUser(), request.getUserGroups());
        String relationShipType = request.getRelationshipType();
        Set<String> end1EntityTypeAndSuperTypes = request.getEnd1EntityTypeAndAllSuperTypes();
        HashSet<String> end1Classifications = new HashSet<String>(request.getEnd1EntityClassifications());
        String end1EntityId = request.getEnd1EntityId();
        Set<String> end2EntityTypeAndSuperTypes = request.getEnd2EntityTypeAndAllSuperTypes();
        HashSet<String> end2Classifications = new HashSet<String>(request.getEnd2EntityClassifications());
        String end2EntityId = request.getEnd2EntityId();
        String action = request.getAction() != null ? request.getAction().getType() : null;
        boolean hasEnd1EntityAccess = false;
        boolean hasEnd2EntityAccess = false;
        for (String role : roles) {
            List<AtlasSimpleAuthzPolicy.AtlasRelationshipPermission> permissions = this.getRelationshipPermissionsForRole(role);
            if (permissions == null) continue;
            for (AtlasSimpleAuthzPolicy.AtlasRelationshipPermission permission : permissions) {
                String entityClassification;
                Iterator iter;
                if (!this.isMatch(relationShipType, permission.getRelationshipTypes()) || !this.isMatch(action, permission.getPrivileges())) continue;
                if (!hasEnd1EntityAccess && this.isMatchAny(end1EntityTypeAndSuperTypes, permission.getEnd1EntityType()) && this.isMatch(end1EntityId, permission.getEnd1EntityId())) {
                    iter = end1Classifications.iterator();
                    while (iter.hasNext()) {
                        entityClassification = (String)iter.next();
                        if (!this.isMatchAny(request.getClassificationTypeAndAllSuperTypes(entityClassification), permission.getEnd1EntityClassification())) continue;
                        iter.remove();
                    }
                    hasEnd1EntityAccess = CollectionUtils.isEmpty(end1Classifications);
                }
                if (hasEnd2EntityAccess || !this.isMatchAny(end2EntityTypeAndSuperTypes, permission.getEnd2EntityType()) || !this.isMatch(end2EntityId, permission.getEnd2EntityId())) continue;
                iter = end2Classifications.iterator();
                while (iter.hasNext()) {
                    entityClassification = (String)iter.next();
                    if (!this.isMatchAny(request.getClassificationTypeAndAllSuperTypes(entityClassification), permission.getEnd2EntityClassification())) continue;
                    iter.remove();
                }
                hasEnd2EntityAccess = CollectionUtils.isEmpty(end2Classifications);
            }
        }
        return hasEnd1EntityAccess && hasEnd2EntityAccess;
    }

    @Override
    public boolean isAccessAllowed(AtlasEntityAccessRequest request) throws AtlasAuthorizationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SimpleAtlasAuthorizer.isAccessAllowed({})", (Object)request);
        }
        boolean ret = false;
        String action = request.getAction() != null ? request.getAction().getType() : null;
        Set<String> entityTypes = request.getEntityTypeAndAllSuperTypes();
        String entityId = request.getEntityId();
        String attribute = request.getAttributeName();
        HashSet<String> entClsToAuthz = new HashSet<String>(request.getEntityClassifications());
        Set<String> roles = this.getRoles(request.getUser(), request.getUserGroups());
        block0: for (String role : roles) {
            List<AtlasSimpleAuthzPolicy.AtlasEntityPermission> permissions = this.getEntityPermissionsForRole(role);
            if (permissions == null) continue;
            for (AtlasSimpleAuthzPolicy.AtlasEntityPermission permission : permissions) {
                if (!this.isMatch(action, permission.getPrivileges()) || !this.isMatchAny(entityTypes, permission.getEntityTypes()) || !this.isMatch(entityId, permission.getEntityIds()) || !this.isMatch(attribute, permission.getAttributes()) || !this.isLabelMatch(request, permission) || !this.isBusinessMetadataMatch(request, permission) || !this.isClassificationMatch(request, permission)) continue;
                Iterator iter = entClsToAuthz.iterator();
                while (iter.hasNext()) {
                    String entityClassification = (String)iter.next();
                    if (!this.isMatchAny(request.getClassificationTypeAndAllSuperTypes(entityClassification), permission.getEntityClassifications())) continue;
                    iter.remove();
                }
                ret = CollectionUtils.isEmpty(entClsToAuthz);
                if (!ret) continue;
                continue block0;
            }
        }
        if (LOG.isDebugEnabled()) {
            if (!ret) {
                LOG.debug("isAccessAllowed={}; classificationsWithNoAccess={}", (Object)ret, entClsToAuthz);
            }
            LOG.debug("<== SimpleAtlasAuthorizer.isAccessAllowed({}): {}", (Object)request, (Object)ret);
        }
        return ret;
    }

    @Override
    public void scrubSearchResults(AtlasSearchResultScrubRequest request) throws AtlasAuthorizationException {
        AtlasSearchResult result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SimpleAtlasAuthorizer.scrubSearchResults({})", (Object)request);
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = request.getSearchResult()).getEntities())) {
            for (AtlasEntityHeader entity : result.getEntities()) {
                this.checkAccessAndScrub(entity, request);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)result.getFullTextResult())) {
            for (AtlasSearchResult.AtlasFullTextResult fullTextResult : result.getFullTextResult()) {
                if (fullTextResult == null) continue;
                this.checkAccessAndScrub(fullTextResult.getEntity(), request);
            }
        }
        if (MapUtils.isNotEmpty((Map)result.getReferredEntities())) {
            for (AtlasEntityHeader entity : result.getReferredEntities().values()) {
                this.checkAccessAndScrub(entity, request);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== SimpleAtlasAuthorizer.scrubSearchResults({}): {}", (Object)request, (Object)result);
        }
    }

    @Override
    public void filterTypesDef(AtlasTypesDefFilterRequest request) throws AtlasAuthorizationException {
        AtlasTypesDef typesDef = request.getTypesDef();
        this.filterTypes(request, typesDef.getEnumDefs());
        this.filterTypes(request, typesDef.getStructDefs());
        this.filterTypes(request, typesDef.getEntityDefs());
        this.filterTypes(request, typesDef.getClassificationDefs());
        this.filterTypes(request, typesDef.getRelationshipDefs());
        this.filterTypes(request, typesDef.getBusinessMetadataDefs());
    }

    private Set<String> getRoles(String userName, Set<String> userGroups) {
        HashSet<String> ret = new HashSet<String>();
        if (this.authzPolicy != null) {
            List<String> userRoles;
            if (userName != null && this.authzPolicy.getUserRoles() != null && (userRoles = this.authzPolicy.getUserRoles().get(userName)) != null) {
                ret.addAll(userRoles);
            }
            if (userGroups != null && this.authzPolicy.getGroupRoles() != null) {
                for (String groupName : userGroups) {
                    List<String> groupRoles = this.authzPolicy.getGroupRoles().get(groupName);
                    if (groupRoles == null) continue;
                    ret.addAll(groupRoles);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getRoles({}, {}): {}", new Object[]{userName, userGroups, ret});
        }
        return ret;
    }

    private List<AtlasSimpleAuthzPolicy.AtlasAdminPermission> getAdminPermissionsForRole(String roleName) {
        List<AtlasSimpleAuthzPolicy.AtlasAdminPermission> ret = null;
        if (this.authzPolicy != null && roleName != null) {
            AtlasSimpleAuthzPolicy.AtlasAuthzRole role = this.authzPolicy.getRoles().get(roleName);
            ret = role != null ? role.getAdminPermissions() : null;
        }
        return ret;
    }

    private List<AtlasSimpleAuthzPolicy.AtlasTypePermission> getTypePermissionsForRole(String roleName) {
        List<AtlasSimpleAuthzPolicy.AtlasTypePermission> ret = null;
        if (this.authzPolicy != null && roleName != null) {
            AtlasSimpleAuthzPolicy.AtlasAuthzRole role = this.authzPolicy.getRoles().get(roleName);
            ret = role != null ? role.getTypePermissions() : null;
        }
        return ret;
    }

    private List<AtlasSimpleAuthzPolicy.AtlasEntityPermission> getEntityPermissionsForRole(String roleName) {
        List<AtlasSimpleAuthzPolicy.AtlasEntityPermission> ret = null;
        if (this.authzPolicy != null && roleName != null) {
            AtlasSimpleAuthzPolicy.AtlasAuthzRole role = this.authzPolicy.getRoles().get(roleName);
            ret = role != null ? role.getEntityPermissions() : null;
        }
        return ret;
    }

    private List<AtlasSimpleAuthzPolicy.AtlasRelationshipPermission> getRelationshipPermissionsForRole(String roleName) {
        List<AtlasSimpleAuthzPolicy.AtlasRelationshipPermission> ret = null;
        if (this.authzPolicy != null && roleName != null) {
            AtlasSimpleAuthzPolicy.AtlasAuthzRole role = this.authzPolicy.getRoles().get(roleName);
            ret = role != null ? role.getRelationshipPermissions() : null;
        }
        return ret;
    }

    private boolean isMatch(String value, List<String> patterns) {
        boolean ret = false;
        if (value == null) {
            ret = true;
        }
        if (CollectionUtils.isNotEmpty(patterns)) {
            for (String pattern : patterns) {
                if (!this.isMatch(value, pattern)) continue;
                ret = true;
                break;
            }
        }
        if (!ret && LOG.isDebugEnabled()) {
            LOG.debug("<== isMatch({}, {}): {}", new Object[]{value, patterns, ret});
        }
        return ret;
    }

    private boolean isMatchAny(Set<String> values, List<String> patterns) {
        boolean ret = false;
        if (CollectionUtils.isEmpty(values)) {
            ret = true;
        }
        if (CollectionUtils.isNotEmpty(patterns)) {
            for (String value : values) {
                if (!this.isMatch(value, patterns)) continue;
                ret = true;
                break;
            }
        }
        if (!ret && LOG.isDebugEnabled()) {
            LOG.debug("<== isMatchAny({}, {}): {}", new Object[]{values, patterns, ret});
        }
        return ret;
    }

    private boolean isMatch(String value, String pattern) {
        boolean ret = value == null ? true : StringUtils.equalsIgnoreCase((String)value, (String)pattern) || value.matches(pattern);
        return ret;
    }

    private void checkAccessAndScrub(AtlasEntityHeader entity, AtlasSearchResultScrubRequest request) throws AtlasAuthorizationException {
        if (entity != null && request != null) {
            AtlasEntityAccessRequest entityAccessRequest = new AtlasEntityAccessRequest(request.getTypeRegistry(), AtlasPrivilege.ENTITY_READ, entity, request.getUser(), request.getUserGroups());
            entityAccessRequest.setClientIPAddress(request.getClientIPAddress());
            if (!this.isAccessAllowed(entityAccessRequest)) {
                this.scrubEntityHeader(entity);
            }
        }
    }

    private boolean isLabelMatch(AtlasEntityAccessRequest request, AtlasSimpleAuthzPolicy.AtlasEntityPermission permission) {
        return AtlasPrivilege.ENTITY_ADD_LABEL.equals((Object)request.getAction()) || AtlasPrivilege.ENTITY_REMOVE_LABEL.equals((Object)request.getAction()) ? this.isMatch(request.getLabel(), permission.getLabels()) : true;
    }

    private boolean isBusinessMetadataMatch(AtlasEntityAccessRequest request, AtlasSimpleAuthzPolicy.AtlasEntityPermission permission) {
        return AtlasPrivilege.ENTITY_UPDATE_BUSINESS_METADATA.equals((Object)request.getAction()) ? this.isMatch(request.getBusinessMetadata(), permission.getBusinessMetadata()) : true;
    }

    private boolean isClassificationMatch(AtlasEntityAccessRequest request, AtlasSimpleAuthzPolicy.AtlasEntityPermission permission) {
        return CLASSIFICATION_PRIVILEGES.contains((Object)request.getAction()) && request.getClassification() != null ? this.isMatch(request.getClassification().getTypeName(), permission.getClassifications()) : true;
    }

    private void filterTypes(AtlasAccessRequest request, List<? extends AtlasBaseTypeDef> typeDefs) throws AtlasAuthorizationException {
        if (typeDefs != null) {
            ListIterator<? extends AtlasBaseTypeDef> iter = typeDefs.listIterator();
            while (iter.hasNext()) {
                AtlasBaseTypeDef typeDef = iter.next();
                AtlasTypeAccessRequest typeRequest = new AtlasTypeAccessRequest(request.getAction(), typeDef, request.getUser(), request.getUserGroups());
                typeRequest.setClientIPAddress(request.getClientIPAddress());
                typeRequest.setForwardedAddresses(request.getForwardedAddresses());
                typeRequest.setRemoteIPAddress(request.getRemoteIPAddress());
                if (this.isAccessAllowed(typeRequest)) continue;
                iter.remove();
            }
        }
    }

    private void addImpliedTypeReadPrivilege(AtlasSimpleAuthzPolicy policy) {
        if (policy != null && policy.getRoles() != null) {
            for (AtlasSimpleAuthzPolicy.AtlasAuthzRole role : policy.getRoles().values()) {
                if (role.getTypePermissions() == null) continue;
                for (AtlasSimpleAuthzPolicy.AtlasTypePermission permission : role.getTypePermissions()) {
                    List<String> privileges = permission.getPrivileges();
                    if (CollectionUtils.isEmpty(privileges) || privileges.contains(AtlasPrivilege.TYPE_READ.name()) || !privileges.contains(AtlasPrivilege.TYPE_CREATE.name()) && !privileges.contains(AtlasPrivilege.TYPE_UPDATE.name()) && !privileges.contains(AtlasPrivilege.TYPE_DELETE.name())) continue;
                    privileges.add(AtlasPrivilege.TYPE_READ.name());
                }
            }
        }
    }
}

