/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasSchemaViolationException;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.graphson.AtlasGraphSONMode;
import org.apache.atlas.repository.graphdb.janus.graphson.AtlasGraphSONUtility;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.SchemaViolationException;

public class AtlasJanusElement<T extends Element>
implements AtlasElement {
    private T element;
    protected AtlasJanusGraph graph;

    public AtlasJanusElement(AtlasJanusGraph graph, T element) {
        this.element = element;
        this.graph = graph;
    }

    public <T> T getProperty(String propertyName, Class<T> clazz) {
        Property p = this.getWrappedElement().property(propertyName);
        if (p.isPresent()) {
            Object propertyValue = p.value();
            if (propertyValue == null) {
                return null;
            }
            if (AtlasEdge.class == clazz) {
                return (T)this.graph.getEdge(propertyValue.toString());
            }
            if (AtlasVertex.class == clazz) {
                return (T)this.graph.getVertex(propertyValue.toString());
            }
            return (T)propertyValue;
        }
        return null;
    }

    public <T> Collection<T> getPropertyValues(String propertyName, Class<T> type) {
        return Collections.singleton(this.getProperty(propertyName, type));
    }

    public Set<String> getPropertyKeys() {
        return this.getWrappedElement().keys();
    }

    public void removeProperty(String propertyName) {
        Iterator it = this.getWrappedElement().properties(new String[]{propertyName});
        while (it.hasNext()) {
            Property property = (Property)it.next();
            property.remove();
        }
    }

    public void removePropertyValue(String propertyName, Object propertyValue) {
        Iterator it = this.getWrappedElement().properties(new String[]{propertyName});
        while (it.hasNext()) {
            Property currentProperty = (Property)it.next();
            Object currentPropertyValue = currentProperty.value();
            if (!Objects.equals(currentPropertyValue, propertyValue)) continue;
            currentProperty.remove();
            break;
        }
    }

    public void removeAllPropertyValue(String propertyName, Object propertyValue) {
        Iterator it = this.getWrappedElement().properties(new String[]{propertyName});
        while (it.hasNext()) {
            Property currentProperty = (Property)it.next();
            Object currentPropertyValue = currentProperty.value();
            if (!Objects.equals(currentPropertyValue, propertyValue)) continue;
            currentProperty.remove();
        }
    }

    public void setProperty(String propertyName, Object value) {
        try {
            if (value == null) {
                Object existingVal = this.getProperty(propertyName, Object.class);
                if (existingVal != null) {
                    this.removeProperty(propertyName);
                }
            } else {
                this.getWrappedElement().property(propertyName, value);
            }
        }
        catch (SchemaViolationException e) {
            throw new AtlasSchemaViolationException((Throwable)e);
        }
    }

    public Object getId() {
        return this.element.id();
    }

    public T getWrappedElement() {
        return this.element;
    }

    public JSONObject toJson(Set<String> propertyKeys) throws JSONException {
        return AtlasGraphSONUtility.jsonFromElement(this, propertyKeys, AtlasGraphSONMode.NORMAL);
    }

    public int hashCode() {
        int result = 37;
        result = 17 * result + this.getClass().hashCode();
        result = 17 * result + this.getWrappedElement().hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        AtlasJanusElement otherElement = (AtlasJanusElement)other;
        return this.getWrappedElement().equals(otherElement.getWrappedElement());
    }

    public List<String> getListProperty(String propertyName) {
        List value = this.getProperty(propertyName, List.class);
        return value;
    }

    public void setListProperty(String propertyName, List<String> values) {
        this.setProperty(propertyName, values);
    }

    public boolean exists() {
        try {
            return !((JanusGraphElement)this.element).isRemoved();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public <T> void setJsonProperty(String propertyName, T value) {
        this.setProperty(propertyName, value);
    }

    public <T> T getJsonProperty(String propertyName) {
        return (T)this.getProperty(propertyName, String.class);
    }

    public String getIdForDisplay() {
        return this.getId().toString();
    }

    public <V> List<V> getListProperty(String propertyName, Class<V> elementType) {
        List<String> value = this.getListProperty(propertyName);
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (AtlasEdge.class.isAssignableFrom(elementType)) {
            return Lists.transform(value, (Function)new Function<String, AtlasEdge>(){

                public AtlasEdge apply(String input) {
                    return AtlasJanusElement.this.graph.getEdge(input);
                }
            });
        }
        if (AtlasVertex.class.isAssignableFrom(elementType)) {
            return Lists.transform(value, (Function)new Function<String, AtlasVertex>(){

                public AtlasVertex apply(String input) {
                    return AtlasJanusElement.this.graph.getVertex(input);
                }
            });
        }
        return value;
    }

    public void setPropertyFromElementsIds(String propertyName, List<AtlasElement> values) {
        ArrayList<String> propertyValue = new ArrayList<String>(values.size());
        for (AtlasElement value : values) {
            propertyValue.add(value.getId().toString());
        }
        this.setProperty(propertyName, propertyValue);
    }

    public void setPropertyFromElementId(String propertyName, AtlasElement value) {
        this.setProperty(propertyName, value.getId().toString());
    }

    public boolean isIdAssigned() {
        return true;
    }
}

