/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.atlas.notification.spool.models.IndexRecord;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Archiver {
    private static final Logger LOG = LoggerFactory.getLogger(Archiver.class);
    private final String source;
    private final File indexDoneFile;
    private final File archiveFolder;
    private final int maxArchiveFiles;

    public Archiver(String source, File indexDoneFile, File archiveFolder, int maxArchiveFiles) {
        this.source = source;
        this.indexDoneFile = indexDoneFile;
        this.archiveFolder = archiveFolder;
        this.maxArchiveFiles = maxArchiveFiles;
    }

    public void archive(IndexRecord indexRecord) {
        this.moveToArchiveDir(indexRecord);
        this.removeOldFiles();
    }

    private void moveToArchiveDir(IndexRecord indexRecord) {
        File spoolFile = null;
        File archiveFile = null;
        try {
            spoolFile = new File(indexRecord.getPath());
            archiveFile = new File(this.archiveFolder, spoolFile.getName());
            LOG.info("{}: moving spoolFile={} to archiveFile={}", new Object[]{this.source, spoolFile, archiveFile});
            FileUtils.moveFile((File)spoolFile, (File)archiveFile);
        }
        catch (FileNotFoundException excp) {
            LOG.warn("{}: failed while moving spoolFile={} to archiveFile={}", new Object[]{this.source, spoolFile, archiveFile, excp});
        }
        catch (IOException excp) {
            LOG.error("{}: failed while moving spoolFile={} to archiveFile={}", new Object[]{this.source, spoolFile, archiveFile, excp});
        }
    }

    private void removeOldFiles() {
        block23: {
            try {
                int filesToDelete;
                File[] logFiles = this.archiveFolder == null ? null : this.archiveFolder.listFiles(pathname -> StringUtils.endsWithIgnoreCase((String)pathname.getName(), (String)".log"));
                int n = filesToDelete = logFiles == null ? 0 : logFiles.length - this.maxArchiveFiles;
                if (filesToDelete <= 0) break block23;
                try (BufferedReader br = new BufferedReader(new FileReader(this.indexDoneFile));){
                    int filesDeletedCount = 0;
                    String line = br.readLine();
                    while (line != null) {
                        if (!StringUtils.isEmpty((String)(line = line.trim()))) {
                            try {
                                IndexRecord record = (IndexRecord)AtlasType.fromJson((String)line, IndexRecord.class);
                                File logFile = new File(record.getPath());
                                String fileName = logFile.getName();
                                File archiveFile = new File(this.archiveFolder, fileName);
                                if (!archiveFile.exists()) {
                                    LOG.warn("archive file does not exist: {}", (Object)archiveFile);
                                } else {
                                    LOG.info("Deleting archive file: {}", (Object)archiveFile);
                                    boolean ret = archiveFile.delete();
                                    if (!ret) {
                                        LOG.error("{}: Error deleting archive file. File: {}", (Object)this.source, (Object)archiveFile);
                                    } else {
                                        ++filesDeletedCount;
                                    }
                                    if (filesDeletedCount >= filesToDelete) {
                                        break;
                                    }
                                }
                            }
                            catch (Exception excp) {
                                LOG.error("{}: Error deleting older archive file in index-record: {}", new Object[]{this.source, line, excp});
                            }
                        }
                        line = br.readLine();
                    }
                    LOG.info("{}: Deleted: {} archived files", (Object)this.source, (Object)filesDeletedCount);
                }
            }
            catch (Exception exception) {
                LOG.error("{}: Error deleting older files from archive folder. Folder: {}", new Object[]{this.source, this.archiveFolder, exception});
            }
        }
    }
}

