/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool.utils.local;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.atlas.notification.spool.utils.local.FileOperation;

public class FileLockedReadWrite
extends FileOperation {
    private RandomAccessFile raf;
    private FileChannel channel;
    private FileLock lock;

    public FileLockedReadWrite(String source) {
        super(source);
    }

    @Override
    public FileLock run(RandomAccessFile randomAccessFile, FileChannel channel, String json) throws IOException {
        this.raf = randomAccessFile;
        this.channel = channel;
        this.lock = channel.tryLock();
        return this.lock;
    }

    public DataInput getInput(File file) throws IOException {
        return this.getRaf(file);
    }

    public DataOutput getOutput(File file) throws IOException {
        return this.getRaf(file);
    }

    public void flush() throws IOException {
        if (this.channel != null) {
            this.channel.force(true);
        }
    }

    public void close() {
        super.close(this.raf, this.channel, this.lock);
    }

    private RandomAccessFile getRaf(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rws");
        this.run(raf, raf.getChannel(), "");
        return raf;
    }
}

