/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryService;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBusinessMetadataType;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExportTypeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ExportTypeProcessor.class);
    private static final String RELATIONSHIP_ATTR_MEANINGS = "meanings";
    private AtlasTypeRegistry typeRegistry;
    private GlossaryService glossaryService;

    ExportTypeProcessor(AtlasTypeRegistry typeRegistry, GlossaryService glossaryService) {
        this.typeRegistry = typeRegistry;
        this.glossaryService = glossaryService;
    }

    public void addTypes(AtlasEntity entity, ExportService.ExportContext context) {
        this.addEntityType(entity.getTypeName(), context);
        if (CollectionUtils.isNotEmpty((Collection)entity.getClassifications())) {
            for (AtlasClassification c : entity.getClassifications()) {
                this.addClassificationType(c.getTypeName(), context);
            }
        }
        this.addTerms(entity, context);
    }

    private void addTerms(AtlasEntity entity, ExportService.ExportContext context) {
        Object relAttrMeanings = entity.getRelationshipAttribute(RELATIONSHIP_ATTR_MEANINGS);
        if (relAttrMeanings == null || !(relAttrMeanings instanceof List)) {
            return;
        }
        List list = (List)relAttrMeanings;
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (Object objectId : list) {
            if (!(objectId instanceof AtlasRelatedObjectId)) continue;
            AtlasRelatedObjectId termObjectId = (AtlasRelatedObjectId)objectId;
            try {
                AtlasGlossaryTerm term = this.glossaryService.getTerm(termObjectId.getGuid());
                context.termsGlossary.put(termObjectId.getGuid(), term.getAnchor().getGlossaryGuid());
            }
            catch (AtlasBaseException e) {
                LOG.warn("Error fetching term details: {}", (Object)termObjectId);
            }
        }
    }

    private void addType(String typeName, ExportService.ExportContext context) {
        AtlasType type = null;
        try {
            type = this.typeRegistry.getType(typeName);
            this.addType(type, context);
        }
        catch (AtlasBaseException excp) {
            LOG.error("unknown type {}", (Object)typeName);
        }
    }

    private void addEntityType(String typeName, ExportService.ExportContext context) {
        if (!context.entityTypes.contains(typeName)) {
            AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
            this.addEntityType(entityType, context);
        }
    }

    private void addClassificationType(String typeName, ExportService.ExportContext context) {
        if (!context.classificationTypes.contains(typeName)) {
            AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(typeName);
            this.addClassificationType(classificationType, context);
        }
    }

    private void addType(AtlasType type, ExportService.ExportContext context) {
        if (type.getTypeCategory() == TypeCategory.PRIMITIVE) {
            return;
        }
        if (type instanceof AtlasArrayType) {
            AtlasArrayType arrayType = (AtlasArrayType)type;
            this.addType(arrayType.getElementType(), context);
        } else if (type instanceof AtlasMapType) {
            AtlasMapType mapType = (AtlasMapType)type;
            this.addType(mapType.getKeyType(), context);
            this.addType(mapType.getValueType(), context);
        } else if (type instanceof AtlasEntityType) {
            this.addEntityType((AtlasEntityType)type, context);
        } else if (type instanceof AtlasClassificationType) {
            this.addClassificationType((AtlasClassificationType)type, context);
        } else if (type instanceof AtlasRelationshipType) {
            this.addRelationshipType(type.getTypeName(), context);
        } else if (type instanceof AtlasBusinessMetadataType) {
            this.addBusinessMetadataType((AtlasBusinessMetadataType)type, context);
        } else if (type instanceof AtlasStructType) {
            this.addStructType((AtlasStructType)type, context);
        } else if (type instanceof AtlasEnumType) {
            this.addEnumType((AtlasEnumType)type, context);
        }
    }

    private void addEntityType(AtlasEntityType entityType, ExportService.ExportContext context) {
        if (!context.entityTypes.contains(entityType.getTypeName())) {
            context.entityTypes.add(entityType.getTypeName());
            this.addAttributeTypes((AtlasStructType)entityType, context);
            this.addRelationshipTypes(entityType, context);
            this.addBusinessMetadataType(entityType, context);
            if (CollectionUtils.isNotEmpty((Collection)entityType.getAllSuperTypes())) {
                for (String superType : entityType.getAllSuperTypes()) {
                    this.addEntityType(superType, context);
                }
            }
        }
    }

    private void addClassificationType(AtlasClassificationType classificationType, ExportService.ExportContext context) {
        if (!context.classificationTypes.contains(classificationType.getTypeName())) {
            context.classificationTypes.add(classificationType.getTypeName());
            this.addAttributeTypes((AtlasStructType)classificationType, context);
            if (CollectionUtils.isNotEmpty((Collection)classificationType.getAllSuperTypes())) {
                for (String superType : classificationType.getAllSuperTypes()) {
                    this.addClassificationType(superType, context);
                }
            }
        }
    }

    private void addStructType(AtlasStructType structType, ExportService.ExportContext context) {
        if (!context.structTypes.contains(structType.getTypeName())) {
            context.structTypes.add(structType.getTypeName());
            this.addAttributeTypes(structType, context);
        }
    }

    private void addEnumType(AtlasEnumType enumType, ExportService.ExportContext context) {
        if (!context.enumTypes.contains(enumType.getTypeName())) {
            context.enumTypes.add(enumType.getTypeName());
        }
    }

    private void addRelationshipType(String relationshipTypeName, ExportService.ExportContext context) {
        AtlasRelationshipType relationshipType;
        if (!context.relationshipTypes.contains(relationshipTypeName) && (relationshipType = this.typeRegistry.getRelationshipTypeByName(relationshipTypeName)) != null) {
            context.relationshipTypes.add(relationshipTypeName);
            this.addAttributeTypes((AtlasStructType)relationshipType, context);
            this.addEntityType(relationshipType.getEnd1Type(), context);
            this.addEntityType(relationshipType.getEnd2Type(), context);
        }
    }

    private void addBusinessMetadataType(AtlasBusinessMetadataType businessMetadataType, ExportService.ExportContext context) {
        if (!context.businessMetadataTypes.contains(businessMetadataType.getTypeName())) {
            context.businessMetadataTypes.add(businessMetadataType.getTypeName());
            this.addAttributeTypes((AtlasStructType)businessMetadataType, context);
        }
    }

    private void addBusinessMetadataType(AtlasEntityType entityType, ExportService.ExportContext context) {
        for (String bmTypeName : entityType.getBusinessAttributes().keySet()) {
            AtlasBusinessMetadataType bmType = this.typeRegistry.getBusinessMetadataTypeByName(bmTypeName);
            this.addBusinessMetadataType(bmType, context);
        }
    }

    private void addAttributeTypes(AtlasStructType structType, ExportService.ExportContext context) {
        for (AtlasStructDef.AtlasAttributeDef attributeDef : structType.getStructDef().getAttributeDefs()) {
            this.addType(attributeDef.getTypeName(), context);
        }
    }

    private void addRelationshipTypes(AtlasEntityType entityType, ExportService.ExportContext context) {
        for (Map.Entry entry : entityType.getRelationshipAttributes().entrySet()) {
            for (String relationshipType : ((Map)entry.getValue()).keySet()) {
                this.addRelationshipType(relationshipType, context);
            }
        }
    }
}

