/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasEntityUtil;
import org.apache.commons.collections.MapUtils;

public class AtlasEntityComparator {
    private final AtlasTypeRegistry typeRegistry;
    private final EntityGraphRetriever entityRetriever;
    private final Map<String, String> guidRefMap;
    private final boolean skipClassificationCompare;
    private final boolean skipBusinessAttributeCompare;

    public AtlasEntityComparator(AtlasTypeRegistry typeRegistry, EntityGraphRetriever entityRetriever, Map<String, String> guidRefMap, boolean skipClassificationCompare, boolean skipBusinessAttributeCompare) {
        this.typeRegistry = typeRegistry;
        this.entityRetriever = entityRetriever;
        this.guidRefMap = guidRefMap;
        this.skipClassificationCompare = skipClassificationCompare;
        this.skipBusinessAttributeCompare = skipBusinessAttributeCompare;
    }

    public AtlasEntityDiffResult getDiffResult(AtlasEntity updatedEntity, AtlasEntity storedEntity, boolean findOnlyFirstDiff) throws AtlasBaseException {
        return this.getDiffResult(updatedEntity, storedEntity, null, findOnlyFirstDiff);
    }

    public AtlasEntityDiffResult getDiffResult(AtlasEntity updatedEntity, AtlasVertex storedVertex, boolean findOnlyFirstDiff) throws AtlasBaseException {
        return this.getDiffResult(updatedEntity, null, storedVertex, findOnlyFirstDiff);
    }

    private AtlasEntityDiffResult getDiffResult(AtlasEntity updatedEntity, AtlasEntity storedEntity, AtlasVertex storedVertex, boolean findOnlyFirstDiff) throws AtlasBaseException {
        String attrName;
        AtlasEntity diffEntity = new AtlasEntity(updatedEntity.getTypeName());
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(updatedEntity.getTypeName());
        Map entityTypeAttributes = entityType.getAllAttributes();
        Map entityTypeRelationshipAttributes = entityType.getRelationshipAttributes();
        int sectionsWithDiff = 0;
        boolean hasDiffInAttributes = false;
        boolean hasDiffInRelationshipAttributes = false;
        boolean hasDiffInCustomAttributes = false;
        boolean hasDiffInBusinessAttributes = false;
        diffEntity.setGuid(updatedEntity.getGuid());
        if (MapUtils.isNotEmpty((Map)updatedEntity.getAttributes())) {
            for (Map.Entry entry : updatedEntity.getAttributes().entrySet()) {
                Object currVal;
                attrName = (String)entry.getKey();
                AtlasStructType.AtlasAttribute attribute = (AtlasStructType.AtlasAttribute)entityTypeAttributes.get(attrName);
                if (attribute == null) continue;
                Object newVal = entry.getValue();
                Object object = currVal = storedEntity != null ? storedEntity.getAttribute(attrName) : this.entityRetriever.getEntityAttribute(storedVertex, attribute);
                if (attribute.getAttributeType().areEqualValues(currVal, newVal, this.guidRefMap)) continue;
                hasDiffInAttributes = true;
                diffEntity.setAttribute(attrName, newVal);
                if (!findOnlyFirstDiff) continue;
                return new AtlasEntityDiffResult(diffEntity, true, false, false);
            }
            if (hasDiffInAttributes) {
                ++sectionsWithDiff;
            }
        }
        if (MapUtils.isNotEmpty((Map)updatedEntity.getRelationshipAttributes())) {
            for (Map.Entry entry : updatedEntity.getRelationshipAttributes().entrySet()) {
                Object currVal;
                attrName = (String)entry.getKey();
                if (!entityTypeRelationshipAttributes.containsKey(attrName)) continue;
                Object newVal = entry.getValue();
                String relationshipType = AtlasEntityUtil.getRelationshipType(newVal);
                AtlasStructType.AtlasAttribute attribute = entityType.getRelationshipAttribute(attrName, relationshipType);
                Object object = currVal = storedEntity != null ? storedEntity.getRelationshipAttribute(attrName) : this.entityRetriever.getEntityAttribute(storedVertex, attribute);
                if (attribute.getAttributeType().areEqualValues(currVal, newVal, this.guidRefMap)) continue;
                hasDiffInRelationshipAttributes = true;
                diffEntity.setRelationshipAttribute(attrName, newVal);
                if (!findOnlyFirstDiff) continue;
                return new AtlasEntityDiffResult(diffEntity, true, false, false);
            }
            if (hasDiffInRelationshipAttributes) {
                ++sectionsWithDiff;
            }
        }
        if (!this.skipClassificationCompare) {
            List<AtlasClassification> currVal;
            List newVal = updatedEntity.getClassifications();
            List<AtlasClassification> list = currVal = storedEntity != null ? storedEntity.getClassifications() : this.entityRetriever.getAllClassifications(storedVertex);
            if (!Objects.equals(currVal, newVal)) {
                diffEntity.setClassifications(newVal);
                ++sectionsWithDiff;
                if (findOnlyFirstDiff) {
                    return new AtlasEntityDiffResult(diffEntity, true, false, false);
                }
            }
        }
        if (updatedEntity.getCustomAttributes() != null) {
            Map currCustomAttributes;
            Map newCustomAttributes = updatedEntity.getCustomAttributes();
            Map map = currCustomAttributes = storedEntity != null ? storedEntity.getCustomAttributes() : GraphHelper.getCustomAttributes((AtlasElement)storedVertex);
            if (!Objects.equals(currCustomAttributes, newCustomAttributes)) {
                diffEntity.setCustomAttributes(newCustomAttributes);
                hasDiffInCustomAttributes = true;
                if (findOnlyFirstDiff && ++sectionsWithDiff > 1) {
                    return new AtlasEntityDiffResult(diffEntity, true, false, false);
                }
            }
        }
        if (!this.skipBusinessAttributeCompare) {
            Map<String, Map<String, Object>> currBusinessMetadata;
            Map newBusinessMetadata = updatedEntity.getBusinessAttributes();
            Map<String, Map<String, Object>> map = currBusinessMetadata = storedEntity != null ? storedEntity.getBusinessAttributes() : this.entityRetriever.getBusinessMetadata(storedVertex);
            if (!Objects.equals(currBusinessMetadata, newBusinessMetadata)) {
                diffEntity.setBusinessAttributes(newBusinessMetadata);
                hasDiffInBusinessAttributes = true;
                if (findOnlyFirstDiff && ++sectionsWithDiff > 1) {
                    return new AtlasEntityDiffResult(diffEntity, true, false, false);
                }
            }
        }
        return new AtlasEntityDiffResult(diffEntity, sectionsWithDiff > 0, sectionsWithDiff == 1 && hasDiffInCustomAttributes, sectionsWithDiff == 1 && hasDiffInBusinessAttributes);
    }

    public static class AtlasEntityDiffResult {
        private final AtlasEntity diffEntity;
        private final boolean hasDifference;
        private final boolean hasDifferenceOnlyInCustomAttributes;
        private final boolean hasDifferenceOnlyInBusinessAttributes;

        AtlasEntityDiffResult(AtlasEntity diffEntity, boolean hasDifference, boolean hasDifferenceOnlyInCustomAttributes, boolean hasDifferenceOnlyInBusinessAttributes) {
            this.diffEntity = diffEntity;
            this.hasDifference = hasDifference;
            this.hasDifferenceOnlyInCustomAttributes = hasDifferenceOnlyInCustomAttributes;
            this.hasDifferenceOnlyInBusinessAttributes = hasDifferenceOnlyInBusinessAttributes;
        }

        public AtlasEntity getDiffEntity() {
            return this.diffEntity;
        }

        public boolean hasDifference() {
            return this.hasDifference;
        }

        public boolean hasDifferenceOnlyInCustomAttributes() {
            return this.hasDifferenceOnlyInCustomAttributes;
        }

        public boolean hasDifferenceOnlyInBusinessAttributes() {
            return this.hasDifferenceOnlyInBusinessAttributes;
        }
    }
}

