/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import com.sun.jersey.multipart.FormDataParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.audit.AtlasAuditEntry;
import org.apache.atlas.model.audit.AuditSearchParameters;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.impexp.AtlasServer;
import org.apache.atlas.model.impexp.ExportImportAuditEntry;
import org.apache.atlas.model.impexp.MigrationStatus;
import org.apache.atlas.model.instance.AtlasCheckStateRequest;
import org.apache.atlas.model.instance.AtlasCheckStateResult;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.metrics.AtlasMetrics;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.audit.AtlasAuditService;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.impexp.AtlasServerService;
import org.apache.atlas.repository.impexp.ExportImportAuditService;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.MigrationProgressService;
import org.apache.atlas.repository.impexp.ZipSink;
import org.apache.atlas.repository.patches.AtlasPatchManager;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.services.MetricsService;
import org.apache.atlas.tasks.TaskManagement;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.SearchTracker;
import org.apache.atlas.utils.AtlasJson;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.web.filters.AtlasCSRFPreventionFilter;
import org.apache.atlas.web.service.AtlasDebugMetricsSink;
import org.apache.atlas.web.service.ServiceState;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Path(value="admin")
@Singleton
@Service
public class AdminResource {
    private static final Logger LOG = LoggerFactory.getLogger(AdminResource.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"AdminResource");
    private static final String isCSRF_ENABLED = "atlas.rest-csrf.enabled";
    private static final String BROWSER_USER_AGENT_PARAM = "atlas.rest-csrf.browser-useragents-regex";
    private static final String CUSTOM_METHODS_TO_IGNORE_PARAM = "atlas.rest-csrf.methods-to-ignore";
    private static final String CUSTOM_HEADER_PARAM = "atlas.rest-csrf.custom-header";
    private static final String isEntityUpdateAllowed = "atlas.entity.update.allowed";
    private static final String isEntityCreateAllowed = "atlas.entity.create.allowed";
    private static final String editableEntityTypes = "atlas.ui.editable.entity.types";
    private static final String DEFAULT_EDITABLE_ENTITY_TYPES = "hdfs_path";
    private static final String DEFAULT_UI_VERSION = "atlas.ui.default.version";
    private static final String UI_VERSION_V2 = "v2";
    private static final String UI_DATE_TIMEZONE_FORMAT_ENABLED = "atlas.ui.date.timezone.format.enabled";
    private static final String UI_DATE_FORMAT = "atlas.ui.date.format";
    private static final String UI_DATE_DEFAULT_FORMAT = "MM/DD/YYYY hh:mm:ss A";
    private static final String OPERATION_STATUS = "operationStatus";
    private static final List TIMEZONE_LIST = Arrays.asList(TimeZone.getAvailableIDs());
    @Context
    private HttpServletRequest httpServletRequest;
    @Context
    private HttpServletResponse httpServletResponse;
    private Response version;
    private static Configuration atlasProperties;
    private final ServiceState serviceState;
    private final MetricsService metricsService;
    private final ExportService exportService;
    private final ImportService importService;
    private final SearchTracker activeSearches;
    private final AtlasTypeRegistry typeRegistry;
    private final MigrationProgressService migrationProgressService;
    private final ReentrantLock importExportOperationLock;
    private final ExportImportAuditService exportImportAuditService;
    private final TaskManagement taskManagement;
    private final AtlasServerService atlasServerService;
    private final AtlasEntityStore entityStore;
    private final AtlasPatchManager patchManager;
    private final AtlasAuditService auditService;
    private final String defaultUIVersion;
    private final EntityAuditRepository auditRepository;
    private final boolean isTimezoneFormatEnabled;
    private final String uiDateFormat;
    private final AtlasDebugMetricsSink debugMetricsRESTSink;
    private final boolean isDebugMetricsEnabled;
    private final boolean isTasksEnabled;

    @Inject
    public AdminResource(ServiceState serviceState, MetricsService metricsService, AtlasTypeRegistry typeRegistry, ExportService exportService, ImportService importService, SearchTracker activeSearches, MigrationProgressService migrationProgressService, AtlasServerService serverService, ExportImportAuditService exportImportAuditService, AtlasEntityStore entityStore, AtlasPatchManager patchManager, AtlasAuditService auditService, EntityAuditRepository auditRepository, TaskManagement taskManagement, AtlasDebugMetricsSink debugMetricsRESTSink) {
        this.serviceState = serviceState;
        this.metricsService = metricsService;
        this.exportService = exportService;
        this.importService = importService;
        this.activeSearches = activeSearches;
        this.typeRegistry = typeRegistry;
        this.migrationProgressService = migrationProgressService;
        this.atlasServerService = serverService;
        this.entityStore = entityStore;
        this.exportImportAuditService = exportImportAuditService;
        this.importExportOperationLock = new ReentrantLock();
        this.patchManager = patchManager;
        this.auditService = auditService;
        this.auditRepository = auditRepository;
        this.taskManagement = taskManagement;
        this.debugMetricsRESTSink = debugMetricsRESTSink;
        if (atlasProperties != null) {
            this.defaultUIVersion = atlasProperties.getString(DEFAULT_UI_VERSION, UI_VERSION_V2);
            this.isTimezoneFormatEnabled = atlasProperties.getBoolean(UI_DATE_TIMEZONE_FORMAT_ENABLED, true);
            this.uiDateFormat = atlasProperties.getString(UI_DATE_FORMAT, UI_DATE_DEFAULT_FORMAT);
            this.isDebugMetricsEnabled = AtlasConfiguration.DEBUG_METRICS_ENABLED.getBoolean();
            this.isTasksEnabled = AtlasConfiguration.TASKS_USE_ENABLED.getBoolean();
        } else {
            this.defaultUIVersion = UI_VERSION_V2;
            this.isTimezoneFormatEnabled = true;
            this.uiDateFormat = UI_DATE_DEFAULT_FORMAT;
            this.isDebugMetricsEnabled = false;
            this.isTasksEnabled = false;
        }
    }

    @GET
    @Path(value="stack")
    @Produces(value={"text/plain"})
    public String getThreadDump() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AdminResource.getThreadDump()");
        }
        ThreadGroup topThreadGroup = Thread.currentThread().getThreadGroup();
        while (topThreadGroup.getParent() != null) {
            topThreadGroup = topThreadGroup.getParent();
        }
        Thread[] threads = new Thread[topThreadGroup.activeCount()];
        int nr = topThreadGroup.enumerate(threads);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < nr; ++i) {
            builder.append(threads[i].getName()).append("\nState: ").append((Object)threads[i].getState()).append("\n");
            String stackTrace = StringUtils.join((Object[])threads[i].getStackTrace(), (String)"\n");
            builder.append(stackTrace);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AdminResource.getThreadDump()");
        }
        return builder.toString();
    }

    @GET
    @Path(value="version")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getVersion() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AdminResource.getVersion()");
        }
        if (this.version == null) {
            try {
                PropertiesConfiguration configProperties = new PropertiesConfiguration("atlas-buildinfo.properties");
                HashMap<String, String> response = new HashMap<String, String>();
                response.put("Version", configProperties.getString("build.version", "UNKNOWN"));
                response.put("Revision", configProperties.getString("vc.revision", "UNKNOWN"));
                response.put("Name", configProperties.getString("project.name", "apache-atlas"));
                response.put("Description", configProperties.getString("project.description", "Metadata Management and Data Governance Platform over Hadoop"));
                this.version = Response.ok((Object)AtlasJson.toV1Json(response)).build();
            }
            catch (ConfigurationException e) {
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AdminResource.getVersion()");
        }
        return this.version;
    }

    @GET
    @Path(value="status")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getStatus() {
        MigrationStatus status;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AdminResource.getStatus()");
        }
        HashMap responseData = new HashMap(){
            {
                this.put("Status", AdminResource.this.serviceState.getState().toString());
            }
        };
        if (this.serviceState.isInstanceInMigration() && (status = this.migrationProgressService.getStatus()) != null) {
            responseData.put("MigrationStatus", status);
        }
        Response response = Response.ok((Object)AtlasJson.toV1Json((Object)responseData)).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AdminResource.getStatus()");
        }
        return response;
    }

    @GET
    @Path(value="session")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getUserProfile(@Context HttpServletRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AdminResource.getUserProfile()");
        }
        boolean isEntityUpdateAccessAllowed = false;
        boolean isEntityCreateAccessAllowed = false;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = null;
        HashSet<String> groups = new HashSet<String>();
        if (auth != null) {
            userName = auth.getName();
            Collection authorities = auth.getAuthorities();
            for (GrantedAuthority c : authorities) {
                groups.add(c.getAuthority());
            }
            isEntityUpdateAccessAllowed = AtlasAuthorizationUtils.isAccessAllowed((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_UPDATE));
            isEntityCreateAccessAllowed = AtlasAuthorizationUtils.isAccessAllowed((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.typeRegistry, AtlasPrivilege.ENTITY_CREATE));
        }
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put(isCSRF_ENABLED, AtlasCSRFPreventionFilter.isCSRF_ENABLED);
        responseData.put(BROWSER_USER_AGENT_PARAM, "^Mozilla.*,^Opera.*,^Chrome");
        responseData.put(CUSTOM_METHODS_TO_IGNORE_PARAM, "GET,OPTIONS,HEAD,TRACE");
        responseData.put(CUSTOM_HEADER_PARAM, "X-XSRF-HEADER");
        responseData.put(isEntityUpdateAllowed, isEntityUpdateAccessAllowed);
        responseData.put(isEntityCreateAllowed, isEntityCreateAccessAllowed);
        responseData.put(editableEntityTypes, this.getEditableEntityTypes(atlasProperties));
        responseData.put(DEFAULT_UI_VERSION, this.defaultUIVersion);
        responseData.put("userName", userName);
        responseData.put("groups", groups);
        responseData.put("timezones", TIMEZONE_LIST);
        responseData.put(UI_DATE_TIMEZONE_FORMAT_ENABLED, this.isTimezoneFormatEnabled);
        responseData.put(UI_DATE_FORMAT, this.uiDateFormat);
        responseData.put(AtlasConfiguration.DEBUG_METRICS_ENABLED.getPropertyName(), this.isDebugMetricsEnabled);
        responseData.put(AtlasConfiguration.TASKS_USE_ENABLED.getPropertyName(), this.isTasksEnabled);
        String salt = (String)request.getSession().getAttribute("_csrfToken");
        if (StringUtils.isEmpty((String)salt)) {
            salt = RandomStringUtils.random((int)20, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new SecureRandom());
            request.getSession().setAttribute("_csrfToken", (Object)salt);
        }
        responseData.put("_csrfToken", salt);
        Response response = Response.ok((Object)AtlasJson.toV1Json(responseData)).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AdminResource.getUserProfile()");
        }
        return response;
    }

    @GET
    @Path(value="metrics")
    @Produces(value={"application/json; charset=UTF-8"})
    public AtlasMetrics getMetrics() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AdminResource.getMetrics()");
        }
        AtlasMetrics metrics = this.metricsService.getMetrics();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AdminResource.getMetrics()");
        }
        return metrics;
    }

    private void releaseExportImportLock() {
        this.importExportOperationLock.unlock();
    }

    @POST
    @Path(value="/export")
    @Consumes(value={"application/json; charset=UTF-8"})
    public Response export(AtlasExportRequest request) throws AtlasBaseException {
        Response response;
        AtlasExportResult result;
        boolean isSuccessful;
        block11: {
            boolean preventMultipleRequests;
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> AdminResource.export()");
            }
            AtlasAuthorizationUtils.verifyAccess((AtlasAdminAccessRequest)new AtlasAdminAccessRequest(AtlasPrivilege.ADMIN_EXPORT), (Object[])new Object[]{"export"});
            boolean bl = preventMultipleRequests = request != null && request.getOptions() != null && !request.getOptions().containsKey("skipLineage") && !request.getOptions().containsKey("replicatedTo");
            if (preventMultipleRequests) {
                this.acquireExportImportLock("export");
            }
            ZipSink exportSink = null;
            isSuccessful = false;
            result = null;
            try {
                exportSink = new ZipSink((OutputStream)this.httpServletResponse.getOutputStream());
                result = this.exportService.run(exportSink, request, AtlasAuthorizationUtils.getCurrentUserName(), Servlets.getHostName(this.httpServletRequest), AtlasAuthorizationUtils.getRequestIpAddress((HttpServletRequest)this.httpServletRequest));
                exportSink.close();
                this.httpServletResponse.addHeader("Content-Encoding", "gzip");
                this.httpServletResponse.setContentType("application/zip");
                this.httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + result.getClass().getSimpleName());
                this.httpServletResponse.setHeader("Transfer-Encoding", "chunked");
                this.httpServletResponse.getOutputStream().flush();
                isSuccessful = true;
                response = Response.ok().build();
                if (preventMultipleRequests) {
                    this.releaseExportImportLock();
                }
                if (exportSink == null) break block11;
            }
            catch (IOException excp) {
                try {
                    LOG.error("export() failed", (Throwable)excp);
                    throw new AtlasBaseException((Throwable)excp);
                }
                catch (Throwable throwable) {
                    if (preventMultipleRequests) {
                        this.releaseExportImportLock();
                    }
                    if (exportSink != null) {
                        exportSink.close();
                    }
                    this.addToExportOperationAudits(isSuccessful, result);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<== AdminResource.export()");
                    }
                    throw throwable;
                }
            }
            exportSink.close();
        }
        this.addToExportOperationAudits(isSuccessful, result);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AdminResource.export()");
        }
        return response;
    }

    @POST
    @Path(value="/import")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public AtlasImportResult importData(@DefaultValue(value="{}") @FormDataParam(value="request") String jsonData, @FormDataParam(value="data") InputStream inputStream) throws AtlasBaseException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AdminResource.importData(jsonData={}, inputStream={})", (Object)jsonData, (Object)(inputStream != null ? 1 : 0));
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasAdminAccessRequest)new AtlasAdminAccessRequest(AtlasPrivilege.ADMIN_IMPORT), (Object[])new Object[]{"importData"});
        AtlasImportResult result = null;
        boolean preventMultipleRequests = true;
        try {
            AtlasImportRequest request = (AtlasImportRequest)AtlasType.fromJson((String)jsonData, AtlasImportRequest.class);
            boolean bl = preventMultipleRequests = request != null && request.getOptions() != null && !request.getOptions().containsKey("replicatedFrom");
            if (preventMultipleRequests) {
                this.acquireExportImportLock("import");
            }
            result = this.importService.run(inputStream, request, Servlets.getUserName(this.httpServletRequest), Servlets.getHostName(this.httpServletRequest), AtlasAuthorizationUtils.getRequestIpAddress((HttpServletRequest)this.httpServletRequest));
        }
        catch (AtlasBaseException excp) {
            if (excp.getAtlasErrorCode().equals((Object)AtlasErrorCode.IMPORT_ATTEMPTING_EMPTY_ZIP)) {
                LOG.info(excp.getMessage());
                AtlasImportResult atlasImportResult = new AtlasImportResult();
                return atlasImportResult;
            }
            LOG.error("importData(binary) failed", (Throwable)excp);
            throw excp;
        }
        catch (Exception excp) {
            LOG.error("importData(binary) failed", (Throwable)excp);
            throw new AtlasBaseException((Throwable)excp);
        }
        finally {
            if (preventMultipleRequests) {
                this.releaseExportImportLock();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AdminResource.importData(binary)");
            }
        }
        this.addToImportOperationAudits(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/purge")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public EntityMutationResponse purgeByIds(Set<String> guids) throws AtlasBaseException {
        EntityMutationResponse entityMutationResponse;
        if (CollectionUtils.isNotEmpty(guids)) {
            for (String guid : guids) {
                Servlets.validateQueryParamLength("guid", guid);
            }
        }
        AtlasPerfTracer perf = null;
        try {
            EntityMutationResponse resp;
            List purgedEntities;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("AdminResource.purgeByIds(" + guids + ")"));
            }
            if ((purgedEntities = (resp = this.entityStore.purgeByIds(guids)).getPurgedEntities()) != null && purgedEntities.size() > 0) {
                this.auditService.add(AtlasAuditEntry.AuditOperation.PURGE, guids.toString(), resp.getPurgedEntitiesIds(), (long)resp.getPurgedEntities().size());
            }
            entityMutationResponse = resp;
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return entityMutationResponse;
    }

    @POST
    @Path(value="/importfile")
    @Produces(value={"application/json; charset=UTF-8"})
    public AtlasImportResult importFile(String jsonData) throws AtlasBaseException {
        AtlasImportResult result;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AdminResource.importFile()");
        }
        AtlasAuthorizationUtils.verifyAccess((AtlasAdminAccessRequest)new AtlasAdminAccessRequest(AtlasPrivilege.ADMIN_IMPORT), (Object[])new Object[]{"importFile"});
        boolean preventMultipleRequests = true;
        try {
            AtlasImportRequest request = (AtlasImportRequest)AtlasType.fromJson((String)jsonData, AtlasImportRequest.class);
            boolean bl = preventMultipleRequests = request != null && request.getOptions() != null && request.getOptions().containsKey("replicatedFrom");
            if (preventMultipleRequests) {
                this.acquireExportImportLock("importFile");
            }
            result = this.importService.run(request, AtlasAuthorizationUtils.getCurrentUserName(), Servlets.getHostName(this.httpServletRequest), AtlasAuthorizationUtils.getRequestIpAddress((HttpServletRequest)this.httpServletRequest));
        }
        catch (AtlasBaseException excp) {
            if (excp.getAtlasErrorCode().getErrorCode().equals(AtlasErrorCode.IMPORT_ATTEMPTING_EMPTY_ZIP)) {
                LOG.info(excp.getMessage());
            } else {
                LOG.error("importData(binary) failed", (Throwable)excp);
            }
            throw excp;
        }
        catch (Exception excp) {
            LOG.error("importFile() failed", (Throwable)excp);
            throw new AtlasBaseException((Throwable)excp);
        }
        finally {
            if (preventMultipleRequests) {
                this.releaseExportImportLock();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== AdminResource.importFile()");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/server/{serverName}")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public AtlasServer getCluster(@PathParam(value="serverName") String serverName) throws AtlasBaseException {
        AtlasServer atlasServer;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("cluster.getServer(" + serverName + ")"));
            }
            AtlasServer cluster = new AtlasServer(serverName, serverName);
            atlasServer = this.atlasServerService.get(cluster);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return atlasServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/expimp/audit")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public List<ExportImportAuditEntry> getExportImportAudit(@QueryParam(value="serverName") String serverName, @QueryParam(value="userName") String userName, @QueryParam(value="operation") String operation, @QueryParam(value="startTime") String startTime, @QueryParam(value="endTime") String endTime, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws AtlasBaseException {
        List list;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("getExportImportAudit(" + serverName + ")"));
            }
            list = this.exportImportAuditService.get(userName, operation, serverName, startTime, endTime, limit, offset);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/audits")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public List<AtlasAuditEntry> getAtlasAudits(AuditSearchParameters auditSearchParameters) throws AtlasBaseException {
        List list;
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("AdminResource.getAtlasAudits(" + auditSearchParameters + ")"));
            }
            AtlasAuthorizationUtils.verifyAccess((AtlasAdminAccessRequest)new AtlasAdminAccessRequest(AtlasPrivilege.ADMIN_AUDITS), (Object[])new Object[]{"Admin Audits"});
            list = this.auditService.get(auditSearchParameters);
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/audit/{auditGuid}/details")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public List<AtlasEntityHeader> getAuditDetails(@PathParam(value="auditGuid") String auditGuid, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("AdminResource.getAuditDetails(" + auditGuid + ", " + limit + ", " + offset + ")"));
            }
            ArrayList<AtlasEntityHeader> ret = new ArrayList<AtlasEntityHeader>();
            AtlasAuditEntry auditEntry = this.auditService.toAtlasAuditEntry(this.entityStore.getById(auditGuid, false, true));
            if (auditEntry != null && StringUtils.isNotEmpty((String)auditEntry.getResult())) {
                String[] listOfResultGuid = auditEntry.getResult().split(",");
                EntityAuditEventV2.EntityAuditActionV2 auditAction = auditEntry.getOperation().toEntityAuditActionV2();
                if (offset <= listOfResultGuid.length) {
                    for (int index = offset; index < listOfResultGuid.length && index < offset + limit; ++index) {
                        List events = this.auditRepository.listEventsV2(listOfResultGuid[index], auditAction, null, (short)1);
                        for (EntityAuditEventV2 event : events) {
                            AtlasEntityHeader entityHeader = event.getEntityHeader();
                            if (entityHeader == null) continue;
                            ret.add(entityHeader);
                        }
                    }
                }
            }
            ArrayList<AtlasEntityHeader> arrayList = ret;
            return arrayList;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    @GET
    @Path(value="activeSearches")
    @Produces(value={"application/json; charset=UTF-8"})
    public Set<String> getActiveSearches() {
        return this.activeSearches.getActiveSearches();
    }

    @DELETE
    @Path(value="activeSearches/{id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public boolean terminateActiveSearch(@PathParam(value="id") String searchId) {
        SearchContext terminate = this.activeSearches.terminate(searchId);
        return null != terminate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="checkstate")
    @Produces(value={"application/json; charset=UTF-8"})
    @Consumes(value={"application/json; charset=UTF-8"})
    public AtlasCheckStateResult checkState(AtlasCheckStateRequest request) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            AtlasCheckStateResult ret;
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("checkState(" + request + ")"));
            }
            AtlasCheckStateResult atlasCheckStateResult = ret = this.entityStore.checkState(request);
            return atlasCheckStateResult;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    @GET
    @Path(value="patches")
    @Produces(value={"application/json; charset=UTF-8"})
    public AtlasPatch.AtlasPatches getAtlasPatches() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AdminResource.getAtlasPatches()");
        }
        AtlasPatch.AtlasPatches ret = this.patchManager.getAllPatches();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AdminResource.getAtlasPatches()");
        }
        return ret;
    }

    @GET
    @Path(value="/tasks")
    @Produces(value={"application/json; charset=UTF-8"})
    public List<AtlasTask> getTaskStatus(@QueryParam(value="guids") List<String> guids) throws AtlasBaseException {
        return CollectionUtils.isNotEmpty(guids) ? this.taskManagement.getByGuids(guids) : this.taskManagement.getAll();
    }

    @DELETE
    @Path(value="/tasks")
    @Produces(value={"application/json; charset=UTF-8"})
    public void deleteTask(@QueryParam(value="guids") List<String> guids) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(guids)) {
            this.taskManagement.deleteByGuids(guids);
        }
    }

    @GET
    @Path(value="/debug/metrics")
    @Produces(value={"application/json"})
    public Map getDebugMetrics() {
        return this.debugMetricsRESTSink.getMetrics();
    }

    private String getEditableEntityTypes(Configuration config) {
        String ret = DEFAULT_EDITABLE_ENTITY_TYPES;
        if (config != null && config.containsKey(editableEntityTypes)) {
            Object value = config.getProperty(editableEntityTypes);
            if (value instanceof String) {
                ret = (String)value;
            } else if (value instanceof Collection) {
                StringBuilder sb = new StringBuilder();
                for (Object elem : (Collection)value) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(elem.toString());
                }
                ret = sb.toString();
            }
        }
        return ret;
    }

    private void acquireExportImportLock(String activity) throws AtlasBaseException {
        boolean alreadyLocked = this.importExportOperationLock.isLocked();
        if (alreadyLocked) {
            LOG.warn("Another export or import is currently in progress..aborting this " + activity, (Object)Thread.currentThread().getName());
            throw new AtlasBaseException(AtlasErrorCode.FAILED_TO_OBTAIN_IMPORT_EXPORT_LOCK, new String[0]);
        }
        this.importExportOperationLock.lock();
    }

    private void addToImportOperationAudits(AtlasImportResult result) throws AtlasBaseException {
        List objectIds = result.getExportResult().getRequest().getItemsToExport();
        HashMap<String, String> optionMap = new HashMap<String, String>();
        optionMap.put(OPERATION_STATUS, result.getOperationStatus().name());
        String params = AtlasJson.toJson(optionMap);
        this.auditImportExportOperations(objectIds, AtlasAuditEntry.AuditOperation.IMPORT, params);
    }

    private void addToExportOperationAudits(boolean isSuccessful, AtlasExportResult result) throws AtlasBaseException {
        if (!isSuccessful || CollectionUtils.isEmpty((Collection)result.getRequest().getItemsToExport()) || result.getRequest().getOptions() == null) {
            return;
        }
        Map optionMap = result.getRequest().getOptions();
        optionMap.put(OPERATION_STATUS, result.getOperationStatus().name());
        String params = AtlasJson.toJson((Object)optionMap);
        List objectIds = result.getRequest().getItemsToExport();
        this.auditImportExportOperations(objectIds, AtlasAuditEntry.AuditOperation.EXPORT, params);
    }

    private void auditImportExportOperations(List<AtlasObjectId> objectIds, AtlasAuditEntry.AuditOperation auditOperation, String params) throws AtlasBaseException {
        Map<String, Long> entityCountByType = objectIds.stream().collect(Collectors.groupingBy(AtlasObjectId::getTypeName, Collectors.counting()));
        int resultCount = objectIds.size();
        this.auditService.add(auditOperation, params, AtlasJson.toJson(entityCountByType), (long)resultCount);
    }

    static {
        try {
            atlasProperties = ApplicationProperties.get();
        }
        catch (Exception e) {
            LOG.info("Failed to load application properties", (Throwable)e);
        }
    }
}

