/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.web.model.User;
import org.apache.atlas.web.security.AtlasAbstractAuthenticationProvider;
import org.apache.atlas.web.security.AtlasAuthenticationException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.stereotype.Component;

@Component
public class AtlasADAuthenticationProvider
extends AtlasAbstractAuthenticationProvider {
    private static Logger LOG = LoggerFactory.getLogger(AtlasADAuthenticationProvider.class);
    private String adURL;
    private String adDomain;
    private String adBindDN;
    private String adBindPassword;
    private String adUserSearchFilter;
    private String adBase;
    private String adReferral;
    private String adDefaultRole;
    private boolean groupsFromUGI;

    @PostConstruct
    public void setup() {
        this.setADProperties();
    }

    public Authentication authenticate(Authentication authentication) {
        Authentication auth = this.getADBindAuthentication(authentication);
        if (auth != null && auth.isAuthenticated()) {
            return auth;
        }
        auth = this.getADAuthentication(authentication);
        if (auth != null && auth.isAuthenticated()) {
            return auth;
        }
        if (auth == null) {
            throw new AtlasAuthenticationException("AD Authentication Failed");
        }
        return auth;
    }

    private Authentication getADBindAuthentication(Authentication authentication) {
        try {
            String userName = authentication.getName();
            String userPassword = "";
            if (authentication.getCredentials() != null) {
                userPassword = authentication.getCredentials().toString();
            }
            DefaultSpringSecurityContextSource ldapContextSource = new DefaultSpringSecurityContextSource(this.adURL);
            ldapContextSource.setUserDn(this.adBindDN);
            ldapContextSource.setPassword(this.adBindPassword);
            ldapContextSource.setReferral(this.adReferral);
            ldapContextSource.setCacheEnvironmentProperties(true);
            ldapContextSource.setAnonymousReadOnly(false);
            ldapContextSource.setPooled(true);
            ldapContextSource.afterPropertiesSet();
            FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(this.adBase, this.adUserSearchFilter, (BaseLdapPathContextSource)ldapContextSource);
            userSearch.setSearchSubtree(true);
            BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)ldapContextSource);
            bindAuthenticator.setUserSearch((LdapUserSearch)userSearch);
            bindAuthenticator.afterPropertiesSet();
            LdapAuthenticationProvider ldapAuthenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator);
            if (userName != null && userPassword != null && !userName.trim().isEmpty() && !userPassword.trim().isEmpty()) {
                List<GrantedAuthority> grantedAuths = this.getAuthorities(userName);
                User principal = new User(userName, userPassword, grantedAuths);
                UsernamePasswordAuthenticationToken finalAuthentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)userPassword, grantedAuths);
                authentication = ldapAuthenticationProvider.authenticate((Authentication)finalAuthentication);
                if (this.groupsFromUGI) {
                    authentication = this.getAuthenticationWithGrantedAuthorityFromUGI(authentication);
                }
                return authentication;
            }
            LOG.error("AD Authentication Failed userName or userPassword is null or empty");
            return null;
        }
        catch (Exception e) {
            LOG.error("AD Authentication Failed:", (Throwable)e);
            return null;
        }
    }

    private Authentication getADAuthentication(Authentication authentication) {
        try {
            String userName = authentication.getName();
            String userPassword = "";
            if (authentication.getCredentials() != null) {
                userPassword = authentication.getCredentials().toString();
            }
            ActiveDirectoryLdapAuthenticationProvider adAuthenticationProvider = new ActiveDirectoryLdapAuthenticationProvider(this.adDomain, this.adURL);
            adAuthenticationProvider.setConvertSubErrorCodesToExceptions(true);
            adAuthenticationProvider.setUseAuthenticationRequestCredentials(true);
            adAuthenticationProvider.setSearchFilter(this.adUserSearchFilter);
            if (userName != null && userPassword != null && !userName.trim().isEmpty() && !userPassword.trim().isEmpty()) {
                List<GrantedAuthority> grantedAuths = this.getAuthorities(userName);
                User principal = new User(userName, userPassword, grantedAuths);
                UsernamePasswordAuthenticationToken finalAuthentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)userPassword, grantedAuths);
                authentication = adAuthenticationProvider.authenticate((Authentication)finalAuthentication);
                if (this.groupsFromUGI) {
                    authentication = this.getAuthenticationWithGrantedAuthorityFromUGI(authentication);
                }
                return authentication;
            }
            LOG.error("AD Authentication Failed userName or userPassword is null or empty");
            return null;
        }
        catch (Exception e) {
            LOG.error("AD Authentication Failed:", (Throwable)e);
            return null;
        }
    }

    private void setADProperties() {
        try {
            Configuration configuration = ApplicationProperties.get();
            Properties properties = ConfigurationConverter.getProperties((Configuration)configuration.subset("atlas.authentication.method.ldap.ad"));
            this.adDomain = properties.getProperty("domain");
            this.adURL = properties.getProperty("url");
            this.adBindDN = properties.getProperty("bind.dn");
            this.adBindPassword = properties.getProperty("bind.password");
            this.adUserSearchFilter = properties.getProperty("user.searchfilter");
            if (this.adUserSearchFilter == null || this.adUserSearchFilter.trim().isEmpty()) {
                this.adUserSearchFilter = "(sAMAccountName={0})";
            }
            this.adBase = properties.getProperty("base.dn");
            this.adReferral = properties.getProperty("referral");
            this.adDefaultRole = properties.getProperty("default.role");
            this.groupsFromUGI = configuration.getBoolean("atlas.authentication.method.ldap.ugi-groups", true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("AtlasADAuthenticationProvider{adURL='" + this.adURL + '\'' + ", adDomain='" + this.adDomain + '\'' + ", adBindDN='" + this.adBindDN + '\'' + ", adUserSearchFilter='" + this.adUserSearchFilter + '\'' + ", adBase='" + this.adBase + '\'' + ", adReferral='" + this.adReferral + '\'' + ", adDefaultRole='" + this.adDefaultRole + '\'' + ", groupsFromUGI=" + this.groupsFromUGI + '}');
            }
        }
        catch (Exception e) {
            LOG.error("Exception while setADProperties", (Throwable)e);
        }
    }
}

