/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.web.model.User;
import org.apache.atlas.web.security.AtlasAbstractAuthenticationProvider;
import org.apache.atlas.web.security.AtlasAuthenticationException;
import org.apache.atlas.web.security.UserAuthorityGranter;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.jaas.AuthorityGranter;
import org.springframework.security.authentication.jaas.DefaultJaasAuthenticationProvider;
import org.springframework.security.authentication.jaas.memory.InMemoryConfiguration;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class AtlasPamAuthenticationProvider
extends AtlasAbstractAuthenticationProvider {
    private static Logger LOG = LoggerFactory.getLogger(AtlasPamAuthenticationProvider.class);
    private boolean isDebugEnabled = LOG.isDebugEnabled();
    private static String loginModuleName = "org.apache.atlas.web.security.PamLoginModule";
    private static AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    private Map<String, String> options = new HashMap<String, String>();
    private boolean groupsFromUGI;
    private DefaultJaasAuthenticationProvider jaasAuthenticationProvider = new DefaultJaasAuthenticationProvider();

    @PostConstruct
    public void setup() {
        this.setPamProperties();
        this.init();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication auth = this.getPamAuthentication(authentication);
        if (auth != null && auth.isAuthenticated()) {
            return auth;
        }
        throw new AtlasAuthenticationException("PAM Authentication Failed");
    }

    private Authentication getPamAuthentication(Authentication authentication) {
        if (this.isDebugEnabled) {
            LOG.debug("==> AtlasPamAuthenticationProvider getPamAuthentication");
        }
        try {
            String userName = authentication.getName();
            String userPassword = "";
            if (authentication.getCredentials() != null) {
                userPassword = authentication.getCredentials().toString();
            }
            if (userName != null && userPassword != null && !userName.trim().isEmpty() && !userPassword.trim().isEmpty()) {
                List<GrantedAuthority> grantedAuths = this.getAuthorities(userName);
                User principal = new User(userName, userPassword, grantedAuths);
                UsernamePasswordAuthenticationToken finalAuthentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)userPassword, grantedAuths);
                authentication = this.jaasAuthenticationProvider.authenticate((Authentication)finalAuthentication);
                authentication = this.groupsFromUGI ? this.getAuthenticationWithGrantedAuthorityFromUGI(authentication) : this.getAuthenticationWithGrantedAuthority(authentication);
                return authentication;
            }
            return authentication;
        }
        catch (Exception e) {
            LOG.debug("Pam Authentication Failed:", (Throwable)e);
            if (this.isDebugEnabled) {
                LOG.debug("<== AtlasPamAuthenticationProvider getPamAuthentication : " + this.jaasAuthenticationProvider);
            }
            return authentication;
        }
    }

    private void setPamProperties() {
        try {
            this.groupsFromUGI = ApplicationProperties.get().getBoolean("atlas.authentication.method.pam.ugi-groups", true);
            Properties properties = ConfigurationConverter.getProperties((Configuration)ApplicationProperties.get().subset("atlas.authentication.method.pam"));
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getProperty(key);
                this.options.put(key, value);
            }
            if (!this.options.containsKey("service")) {
                this.options.put("service", "atlas-login");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("AtlasPAMAuthenticationProvider{groupsFromUGI= " + this.groupsFromUGI + '\'' + ", options=" + this.options + '}');
            }
        }
        catch (Exception e) {
            LOG.error("Exception while setLdapProperties", (Throwable)e);
        }
    }

    private void init() {
        try {
            AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(loginModuleName, controlFlag, this.options);
            AppConfigurationEntry[] appConfigurationEntries = new AppConfigurationEntry[]{appConfigurationEntry};
            HashMap<String, AppConfigurationEntry[]> appConfigurationEntriesOptions = new HashMap<String, AppConfigurationEntry[]>();
            appConfigurationEntriesOptions.put("SPRINGSECURITY", appConfigurationEntries);
            InMemoryConfiguration configuration = new InMemoryConfiguration(appConfigurationEntriesOptions);
            this.jaasAuthenticationProvider.setConfiguration((javax.security.auth.login.Configuration)configuration);
            UserAuthorityGranter authorityGranter = new UserAuthorityGranter();
            AuthorityGranter[] authorityGranters = new UserAuthorityGranter[]{authorityGranter};
            this.jaasAuthenticationProvider.setAuthorityGranters(authorityGranters);
            this.jaasAuthenticationProvider.afterPropertiesSet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("AtlasPAMAuthenticationProvider{jaasAuthenticationProvider='" + this.jaasAuthenticationProvider + '\'' + ", loginModuleName='" + loginModuleName + '\'' + ", controlFlag='" + controlFlag + '\'' + ", options='" + this.options + '}');
            }
        }
        catch (Exception e) {
            LOG.error("Failed to init PAM Authentication", (Throwable)e);
        }
    }
}

