/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.ByteArrayHashKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HashKey;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface RegionInfo {
    public static final RegionInfo UNDEFINED = RegionInfoBuilder.newBuilder(TableName.valueOf((String)"__UNDEFINED__")).build();
    @InterfaceAudience.Private
    public static final int ENC_SEPARATOR = 46;
    @InterfaceAudience.Private
    public static final int MD5_HEX_LENGTH = 32;
    @InterfaceAudience.Private
    public static final int DEFAULT_REPLICA_ID = 0;
    @InterfaceAudience.Private
    public static final String REPLICA_ID_FORMAT = "%04X";
    @InterfaceAudience.Private
    public static final byte REPLICA_ID_DELIMITER = 95;
    @InterfaceAudience.Private
    public static final String INVALID_REGION_NAME_FORMAT_MESSAGE = "Invalid regionName format";
    @InterfaceAudience.Private
    public static final Comparator<RegionInfo> COMPARATOR = (lhs, rhs) -> {
        if (rhs == null) {
            return 1;
        }
        int result = lhs.getTable().compareTo(rhs.getTable());
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo((byte[])lhs.getStartKey(), (byte[])rhs.getStartKey());
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo((byte[])lhs.getEndKey(), (byte[])rhs.getEndKey());
        if (result != 0) {
            if (lhs.getStartKey().length != 0 && lhs.getEndKey().length == 0) {
                return 1;
            }
            if (rhs.getStartKey().length != 0 && rhs.getEndKey().length == 0) {
                return -1;
            }
            return result;
        }
        if (lhs.getRegionId() > rhs.getRegionId()) {
            return 1;
        }
        if (lhs.getRegionId() < rhs.getRegionId()) {
            return -1;
        }
        int replicaDiff = lhs.getReplicaId() - rhs.getReplicaId();
        if (replicaDiff != 0) {
            return replicaDiff;
        }
        if (lhs.isOffline() == rhs.isOffline()) {
            return 0;
        }
        if (lhs.isOffline()) {
            return -1;
        }
        return 1;
    };

    public String getShortNameToLog();

    public long getRegionId();

    public byte[] getRegionName();

    public String getRegionNameAsString();

    public String getEncodedName();

    public byte[] getEncodedNameAsBytes();

    public byte[] getStartKey();

    public byte[] getEndKey();

    public TableName getTable();

    public int getReplicaId();

    public boolean isSplit();

    public boolean isOffline();

    public boolean isSplitParent();

    public boolean isMetaRegion();

    public boolean containsRange(byte[] var1, byte[] var2);

    public boolean containsRow(byte[] var1);

    @InterfaceAudience.Private
    public static boolean hasEncodedName(byte[] regionName) {
        return regionName.length >= 1 && regionName[regionName.length - 1] == 46;
    }

    @InterfaceAudience.Private
    public static String encodeRegionName(byte[] regionName) {
        String encodedName;
        if (RegionInfo.hasEncodedName(regionName)) {
            encodedName = Bytes.toString((byte[])regionName, (int)(regionName.length - 32 - 1), (int)32);
        } else {
            ByteArrayHashKey key = new ByteArrayHashKey(regionName, 0, regionName.length);
            int hashVal = Math.abs(JenkinsHash.getInstance().hash((HashKey)key, 0));
            encodedName = String.valueOf(hashVal);
        }
        return encodedName;
    }

    @InterfaceAudience.Private
    public static String getRegionNameAsString(byte[] regionName) {
        return RegionInfo.getRegionNameAsString(null, regionName);
    }

    @InterfaceAudience.Private
    public static String getRegionNameAsString(@CheckForNull RegionInfo ri, byte[] regionName) {
        if (RegionInfo.hasEncodedName(regionName)) {
            return Bytes.toStringBinary((byte[])regionName);
        }
        if (ri == null) {
            return Bytes.toStringBinary((byte[])regionName) + "." + RegionInfo.encodeRegionName(regionName);
        }
        return Bytes.toStringBinary((byte[])regionName) + "." + ri.getEncodedName();
    }

    public static String getShortNameToLog(RegionInfo ... hris) {
        return RegionInfo.getShortNameToLog(Arrays.asList(hris));
    }

    public static String getShortNameToLog(List<RegionInfo> ris) {
        return ris.stream().map(ri -> ri.getShortNameToLog()).collect(Collectors.toList()).toString();
    }

    @InterfaceAudience.Private
    public static TableName getTable(byte[] regionName) {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset <= 0) {
            throw new IllegalArgumentException("offset=" + offset);
        }
        byte[] buff = new byte[offset];
        System.arraycopy(regionName, 0, buff, 0, offset);
        return TableName.valueOf((byte[])buff);
    }

    public static byte[] getStartKey(byte[] regionName) throws IOException {
        return RegionInfo.parseRegionName(regionName)[1];
    }

    @InterfaceAudience.Private
    public static boolean isEncodedRegionName(byte[] regionName) throws IOException {
        return RegionInfo.parseRegionNameOrReturnNull(regionName) == null && regionName.length <= 32;
    }

    @InterfaceAudience.Private
    public static RegionInfo parseFromOrNull(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return RegionInfo.parseFromOrNull(bytes, 0, bytes.length);
    }

    @InterfaceAudience.Private
    public static RegionInfo parseFromOrNull(byte[] bytes, int offset, int len) {
        if (bytes == null || len <= 0) {
            return null;
        }
        try {
            return RegionInfo.parseFrom(bytes, offset, len);
        }
        catch (DeserializationException e) {
            return null;
        }
    }

    @InterfaceAudience.Private
    public static RegionInfo parseFrom(byte[] bytes) throws DeserializationException {
        if (bytes == null) {
            return null;
        }
        return RegionInfo.parseFrom(bytes, 0, bytes.length);
    }

    @InterfaceAudience.Private
    public static RegionInfo parseFrom(byte[] bytes, int offset, int len) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes, offset, len)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                HBaseProtos.RegionInfo.Builder builder = HBaseProtos.RegionInfo.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen + offset, len - pblen);
                HBaseProtos.RegionInfo ri = builder.build();
                return ProtobufUtil.toRegionInfo(ri);
            }
            catch (IOException e) {
                throw new DeserializationException((Throwable)e);
            }
        }
        throw new DeserializationException("PB encoded RegionInfo expected");
    }

    public static boolean areAdjacent(RegionInfo regionA, RegionInfo regionB) {
        if (regionA == null || regionB == null) {
            throw new IllegalArgumentException("Can't check whether adjacent for null region");
        }
        if (!regionA.getTable().equals((Object)regionB.getTable())) {
            return false;
        }
        RegionInfo a = regionA;
        RegionInfo b = regionB;
        if (Bytes.compareTo((byte[])a.getStartKey(), (byte[])b.getStartKey()) > 0) {
            a = regionB;
            b = regionA;
        }
        return Bytes.equals((byte[])a.getEndKey(), (byte[])b.getStartKey());
    }

    public static byte[] toByteArray(RegionInfo ri) {
        byte[] bytes = ProtobufUtil.toRegionInfo(ri).toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    public static String prettyPrint(String encodedRegionName) {
        if (encodedRegionName.equals("1028785192")) {
            return encodedRegionName + "/hbase:meta";
        }
        return encodedRegionName;
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, long regionid, boolean newFormat) {
        return RegionInfo.createRegionName(tableName, startKey, Long.toString(regionid), newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, String id, boolean newFormat) {
        return RegionInfo.createRegionName(tableName, startKey, Bytes.toBytes((String)id), newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, long regionid, int replicaId, boolean newFormat) {
        return RegionInfo.createRegionName(tableName, startKey, Bytes.toBytes((String)Long.toString(regionid)), replicaId, newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, byte[] id, boolean newFormat) {
        return RegionInfo.createRegionName(tableName, startKey, id, 0, newFormat);
    }

    public static byte[] createRegionName(TableName tableName, byte[] startKey, byte[] id, int replicaId, boolean newFormat) {
        int len = tableName.getName().length + 2 + id.length + (startKey == null ? 0 : startKey.length);
        if (newFormat) {
            len += 34;
        }
        byte[] replicaIdBytes = null;
        if (replicaId > 0) {
            replicaIdBytes = Bytes.toBytes((String)String.format(REPLICA_ID_FORMAT, replicaId));
            len += 1 + replicaIdBytes.length;
        }
        byte[] b = new byte[len];
        int offset = tableName.getName().length;
        System.arraycopy(tableName.getName(), 0, b, 0, offset);
        b[offset++] = 44;
        if (startKey != null && startKey.length > 0) {
            System.arraycopy(startKey, 0, b, offset, startKey.length);
            offset += startKey.length;
        }
        b[offset++] = 44;
        System.arraycopy(id, 0, b, offset, id.length);
        offset += id.length;
        if (replicaIdBytes != null) {
            b[offset++] = 95;
            System.arraycopy(replicaIdBytes, 0, b, offset, replicaIdBytes.length);
            offset += replicaIdBytes.length;
        }
        if (newFormat) {
            String md5Hash = MD5Hash.getMD5AsHex((byte[])b, (int)0, (int)offset);
            byte[] md5HashBytes = Bytes.toBytes((String)md5Hash);
            if (md5HashBytes.length != 32) {
                System.out.println("MD5-hash length mismatch: Expected=32; Got=" + md5HashBytes.length);
            }
            b[offset++] = 46;
            System.arraycopy(md5HashBytes, 0, b, offset, 32);
            b[offset += 32] = 46;
        }
        return b;
    }

    public static RegionInfo createMobRegionInfo(TableName tableName) {
        return RegionInfoBuilder.newBuilder(tableName).setStartKey(Bytes.toBytes((String)".mob")).setRegionId(0L).build();
    }

    public static byte[][] parseRegionName(byte[] regionName) throws IOException {
        byte[][] result = RegionInfo.parseRegionNameOrReturnNull(regionName);
        if (result == null) {
            throw new IOException("Invalid regionName format: " + Bytes.toStringBinary((byte[])regionName));
        }
        return result;
    }

    public static byte[][] parseRegionNameOrReturnNull(byte[] regionName) {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            return null;
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        offset = -1;
        int endOffset = regionName.length;
        if (regionName.length > 34 && regionName[regionName.length - 1] == 46 && regionName[regionName.length - 32 - 2] == 46) {
            endOffset = endOffset - 32 - 2;
        }
        byte[] replicaId = null;
        int idEndOffset = endOffset;
        for (int i = endOffset - 1; i > 0; --i) {
            if (regionName[i] == 95) {
                replicaId = new byte[endOffset - i - 1];
                System.arraycopy(regionName, i + 1, replicaId, 0, endOffset - i - 1);
                idEndOffset = i;
            }
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            return null;
        }
        byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        if (offset != tableName.length + 1) {
            startKey = new byte[offset - tableName.length - 1];
            System.arraycopy(regionName, tableName.length + 1, startKey, 0, offset - tableName.length - 1);
        }
        byte[] id = new byte[idEndOffset - offset - 1];
        System.arraycopy(regionName, offset + 1, id, 0, idEndOffset - offset - 1);
        byte[][] elements = new byte[replicaId == null ? 3 : 4][];
        elements[0] = tableName;
        elements[1] = startKey;
        elements[2] = id;
        if (replicaId != null) {
            elements[3] = replicaId;
        }
        return elements;
    }

    public static byte[] toDelimitedByteArray(RegionInfo ... infos) throws IOException {
        byte[][] bytes = new byte[infos.length][];
        int size = 0;
        for (int i = 0; i < infos.length; ++i) {
            bytes[i] = RegionInfo.toDelimitedByteArray(infos[i]);
            size += bytes[i].length;
        }
        byte[] result = new byte[size];
        int offset = 0;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, result, offset, b.length);
            offset += b.length;
        }
        return result;
    }

    public static byte[] toDelimitedByteArray(RegionInfo ri) throws IOException {
        return ProtobufUtil.toDelimitedByteArray((Message)ProtobufUtil.toRegionInfo(ri));
    }

    public static RegionInfo parseFrom(DataInputStream in) throws IOException {
        int read;
        int pblen = ProtobufUtil.lengthOfPBMagic();
        byte[] pbuf = new byte[pblen];
        if (in.markSupported()) {
            in.mark(pblen);
        }
        if ((read = in.read(pbuf)) != pblen) {
            throw new IOException("read=" + read + ", wanted=" + pblen);
        }
        if (ProtobufUtil.isPBMagicPrefix(pbuf)) {
            return ProtobufUtil.toRegionInfo(HBaseProtos.RegionInfo.parseDelimitedFrom((InputStream)in));
        }
        throw new IOException("PB encoded RegionInfo expected");
    }

    public static List<RegionInfo> parseDelimitedFrom(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException("Can't build an object with empty bytes array");
        }
        ArrayList<RegionInfo> ris = new ArrayList<RegionInfo>();
        try (DataInputBuffer in = new DataInputBuffer();){
            in.reset(bytes, offset, length);
            while (in.available() > 0) {
                RegionInfo ri = RegionInfo.parseFrom((DataInputStream)in);
                ris.add(ri);
            }
        }
        return ris;
    }

    default public boolean isFirst() {
        return Bytes.equals((byte[])this.getStartKey(), (byte[])HConstants.EMPTY_START_ROW);
    }

    default public boolean isLast() {
        return Bytes.equals((byte[])this.getEndKey(), (byte[])HConstants.EMPTY_END_ROW);
    }

    default public boolean isNext(RegionInfo after) {
        return this.getTable().equals((Object)after.getTable()) && Bytes.equals((byte[])this.getEndKey(), (byte[])after.getStartKey());
    }

    default public boolean isAdjacent(RegionInfo other) {
        return this.getTable().equals((Object)other.getTable()) && RegionInfo.areAdjacent(this, other);
    }

    default public boolean isDegenerate() {
        return !this.isLast() && Bytes.compareTo((byte[])this.getStartKey(), (byte[])this.getEndKey()) > 0;
    }

    default public boolean isOverlap(RegionInfo other) {
        if (other == null) {
            return false;
        }
        if (!this.getTable().equals((Object)other.getTable())) {
            return false;
        }
        int startKeyCompare = Bytes.compareTo((byte[])this.getStartKey(), (byte[])other.getStartKey());
        if (startKeyCompare == 0) {
            return true;
        }
        if (startKeyCompare < 0) {
            if (this.isLast()) {
                return true;
            }
            return Bytes.compareTo((byte[])this.getEndKey(), (byte[])other.getStartKey()) > 0;
        }
        if (other.isLast()) {
            return true;
        }
        return Bytes.compareTo((byte[])this.getStartKey(), (byte[])other.getEndKey()) < 0;
    }
}

