/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.IntegerType;
import java.nio.ByteBuffer;

public final class ShortSerializer
extends AbstractSerializer<Short> {
    private static final ShortSerializer instance = new ShortSerializer();

    public static ShortSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Short obj) {
        if (obj == null) {
            return null;
        }
        ByteBuffer b = ByteBuffer.allocate(2);
        b.putShort(obj);
        b.rewind();
        return b;
    }

    @Override
    public Short fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        ByteBuffer dup = byteBuffer.duplicate();
        short in = dup.getShort();
        return in;
    }

    @Override
    public ByteBuffer fromString(String str) {
        return this.toByteBuffer(Short.parseShort(str));
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return IntegerType.instance.getString(byteBuffer);
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        Short val = this.fromByteBuffer(byteBuffer.duplicate());
        if (val == Short.MAX_VALUE) {
            throw new ArithmeticException("Can't paginate past max short");
        }
        Short s = val;
        Short s2 = val = Short.valueOf((short)(val + 1));
        return this.toByteBuffer(val);
    }
}

