/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.BytesType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TypeParser;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.SyntaxException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadedTypeParser
extends TypeParser {
    private static final Logger Logger = LoggerFactory.getLogger(ShadedTypeParser.class);
    public static final String SHADED_PREFIX = "com.netflix.astyanax.shaded.";
    protected static TypeParser EMPTY_PARSER;
    protected static Field strField;
    protected static Field idxField;
    protected static Field cacheField;
    protected static Map<String, AbstractType<?>> cache;
    protected static Method skipBlankMethod;
    protected static Method skipBlankMethod2;
    protected static Method isEOSMethod;
    protected static Method isEOSMethod2;
    protected static Method isIdentifierCharMethod;

    protected static void init() throws ConfigurationException {
        try {
            strField = ShadedTypeParser.class.getSuperclass().getDeclaredField("str");
            strField.setAccessible(true);
            idxField = ShadedTypeParser.class.getSuperclass().getDeclaredField("idx");
            idxField.setAccessible(true);
            cacheField = ShadedTypeParser.class.getSuperclass().getDeclaredField("cache");
            cacheField.setAccessible(true);
            cache = (Map)cacheField.get(null);
            skipBlankMethod = ShadedTypeParser.class.getSuperclass().getDeclaredMethod("skipBlank", new Class[0]);
            skipBlankMethod.setAccessible(true);
            skipBlankMethod2 = ShadedTypeParser.class.getSuperclass().getDeclaredMethod("skipBlank", String.class, Integer.TYPE);
            skipBlankMethod2.setAccessible(true);
            isEOSMethod = ShadedTypeParser.class.getSuperclass().getDeclaredMethod("isEOS", new Class[0]);
            isEOSMethod.setAccessible(true);
            isEOSMethod2 = ShadedTypeParser.class.getSuperclass().getDeclaredMethod("isEOS", String.class, Integer.TYPE);
            isEOSMethod2.setAccessible(true);
            isIdentifierCharMethod = ShadedTypeParser.class.getSuperclass().getDeclaredMethod("isIdentifierChar", Integer.TYPE);
            isIdentifierCharMethod.setAccessible(true);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new ConfigurationException("ShadedTypeParser init() failed for reflection; message=" + e.getMessage(), (Throwable)e);
        }
    }

    protected String getStr() throws IllegalAccessException {
        return (String)strField.get((Object)this);
    }

    protected int getIdx() throws IllegalAccessException {
        return idxField.getInt((Object)this);
    }

    protected void setIdx(int idx) throws IllegalAccessException {
        idxField.setInt((Object)this, idx);
    }

    protected void skipBlank() throws InvocationTargetException, IllegalAccessException {
        skipBlankMethod.invoke((Object)this, new Object[0]);
    }

    protected static int skipBlank(String str, int i) throws InvocationTargetException, IllegalAccessException {
        return (Integer)skipBlankMethod2.invoke(null, str, i);
    }

    protected boolean isEOS() throws InvocationTargetException, IllegalAccessException {
        return (Boolean)isEOSMethod.invoke((Object)this, new Object[0]);
    }

    protected static boolean isEOS(String str, int i) throws InvocationTargetException, IllegalAccessException {
        return (Boolean)isEOSMethod2.invoke(null, str, i);
    }

    private static boolean isIdentifierChar(int c) throws InvocationTargetException, IllegalAccessException {
        return (Boolean)isIdentifierCharMethod.invoke(null, c);
    }

    protected static Method getRawAbstractTypeMethod(Class typeClass) throws NoSuchMethodException {
        return ShadedTypeParser.class.getSuperclass().getDeclaredMethod("getRawAbstractType", typeClass, EMPTY_PARSER.getClass());
    }

    public static ShadedTypeParser buildTypeParser(String str, int idx) throws ConfigurationException {
        return new ShadedTypeParser(str, idx);
    }

    public ShadedTypeParser(String str) throws ConfigurationException {
        this(str, 0);
    }

    public ShadedTypeParser(String str, int idx) throws ConfigurationException {
        super(str);
        ShadedTypeParser.init();
        try {
            this.setIdx(idx);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("ShadedTypeParser constructor failed for reflection; message=" + e.getMessage(), (Throwable)e);
        }
    }

    public static String getShadedClassName(String className) {
        if (className.startsWith(SHADED_PREFIX)) {
            return className;
        }
        if (className.contains(".")) {
            return SHADED_PREFIX + className;
        }
        return "com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal." + className;
    }

    public static String getShadedTypeName(String typeName) {
        if (typeName.startsWith("org.apache.cassandra.db.marshal.")) {
            return typeName.substring("org.apache.cassandra.db.marshal.".length());
        }
        if (typeName.startsWith("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.")) {
            return typeName.substring("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.".length());
        }
        return typeName;
    }

    public static AbstractType<?> parse(String str) throws SyntaxException, ConfigurationException {
        try {
            if (str == null) {
                return BytesType.instance;
            }
            str = ShadedTypeParser.getShadedClassName(str);
            AbstractType<?> type = null;
            type = cache.get(str);
            if (type != null) {
                return type;
            }
            int i = 0;
            int j = i = ShadedTypeParser.skipBlank(str, i);
            while (!ShadedTypeParser.isEOS(str, i) && ShadedTypeParser.isIdentifierChar(str.charAt(i))) {
                ++i;
            }
            if (i == j) {
                return BytesType.instance;
            }
            String name = str.substring(j, i);
            name = ShadedTypeParser.getShadedClassName(name);
            if (!ShadedTypeParser.isEOS(str, i = ShadedTypeParser.skipBlank(str, i)) && str.charAt(i) == '(') {
                ShadedTypeParser typeParser = ShadedTypeParser.buildTypeParser(str, i);
                type = ShadedTypeParser.getAbstractType(name, typeParser);
            } else {
                type = ShadedTypeParser.getAbstractType(name);
            }
            cache.put(str, type);
            return type;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigurationException("ShadedTypeParser parse(String) failed for reflection; message=" + e.getMessage(), (Throwable)e);
        }
    }

    public AbstractType<?> parse() throws SyntaxException, ConfigurationException {
        try {
            this.skipBlank();
            String name = this.readNextIdentifier();
            name = ShadedTypeParser.getShadedClassName(name);
            this.skipBlank();
            return !this.isEOS() && this.getStr().charAt(this.getIdx()) == '(' ? ShadedTypeParser.getAbstractType(name, this) : ShadedTypeParser.getAbstractType(name);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConfigurationException("ShadedTypeParser parse() failed for reflection; message=" + e.getMessage(), (Throwable)e);
        }
    }

    protected static AbstractType<?> getAbstractType(String compareWith) throws ConfigurationException {
        String className = ShadedTypeParser.getShadedClassName(compareWith);
        Class typeClass = FBUtilities.classForName((String)className, (String)"abstract-type");
        try {
            Field field = typeClass.getDeclaredField("instance");
            return (AbstractType)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException var4) {
            try {
                Method getRawAbstractTypeMethod = ShadedTypeParser.getRawAbstractTypeMethod(typeClass);
                return (AbstractType)getRawAbstractTypeMethod.invoke(null, typeClass, EMPTY_PARSER);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConfigurationException("ShadedTypeParser getAbstractType failed for reflection; message=" + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static AbstractType<?> getAbstractType(String compareWith, TypeParser parser) throws SyntaxException, ConfigurationException {
        String className = ShadedTypeParser.getShadedClassName(compareWith);
        Class typeClass = FBUtilities.classForName((String)className, (String)"abstract-type");
        try {
            Method method = typeClass.getDeclaredMethod("getInstance", TypeParser.class);
            return (AbstractType)method.invoke(null, parser);
        }
        catch (IllegalAccessException | NoSuchMethodException var6) {
            AbstractType type;
            try {
                Method getRawAbstractTypeMethod = ShadedTypeParser.getRawAbstractTypeMethod(typeClass);
                type = (AbstractType)getRawAbstractTypeMethod.invoke(null, typeClass);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConfigurationException("ShadedTypeParser getAbstractType() failed for reflection; message=" + e.getMessage(), (Throwable)e);
            }
            return AbstractType.parseDefaultParameters((AbstractType)type, (TypeParser)parser);
        }
        catch (InvocationTargetException var8) {
            ConfigurationException ex = new ConfigurationException("Invalid definition for comparator " + typeClass.getName() + ".");
            ex.initCause(var8.getTargetException());
            throw ex;
        }
    }

    static {
        try {
            EMPTY_PARSER = new ShadedTypeParser("");
        }
        catch (ConfigurationException e) {
            Logger.error("ShadedTypeParser failed to create EMPTY_PARSER; message=" + e.getMessage(), (Throwable)e);
        }
    }
}

