/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.AbstractMarker;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnSpecification;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Term;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.VariableSpecifications;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CollectionType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ListType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TupleType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuples {
    private static final Logger logger = LoggerFactory.getLogger(Tuples.class);

    public static String tupleToString(List<?> items) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < items.size(); ++i) {
            sb.append(items.get(i));
            if (i >= items.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static class InMarker
    extends AbstractMarker {
        protected InMarker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof ListType);
        }

        @Override
        public InValue bind(List<ByteBuffer> values) throws InvalidRequestException {
            ByteBuffer value = values.get(this.bindIndex);
            return value == null ? null : InValue.fromSerialized(value, (ListType)this.receiver.type);
        }
    }

    public static class Marker
    extends AbstractMarker {
        public Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
        }

        @Override
        public Value bind(List<ByteBuffer> values) throws InvalidRequestException {
            ByteBuffer value = values.get(this.bindIndex);
            return value == null ? null : Value.fromSerialized(value, (TupleType)this.receiver.type);
        }
    }

    public static class INRaw
    extends AbstractMarker.Raw {
        public INRaw(int bindIndex) {
            super(bindIndex);
        }

        private static ColumnSpecification makeInReceiver(List<? extends ColumnSpecification> receivers) throws InvalidRequestException {
            ArrayList types = new ArrayList(receivers.size());
            StringBuilder inName = new StringBuilder("in(");
            for (int i = 0; i < receivers.size(); ++i) {
                ColumnSpecification receiver = receivers.get(i);
                inName.append(receiver.name);
                if (i < receivers.size() - 1) {
                    inName.append(",");
                }
                if (receiver.type instanceof CollectionType) {
                    throw new InvalidRequestException("Collection columns do not support IN relations");
                }
                types.add(receiver.type);
            }
            inName.append(')');
            ColumnIdentifier identifier = new ColumnIdentifier(inName.toString(), true);
            TupleType type = new TupleType(types);
            return new ColumnSpecification(receivers.get((int)0).ksName, receivers.get((int)0).cfName, identifier, ListType.getInstance(type));
        }

        public AbstractMarker prepare(List<? extends ColumnSpecification> receivers) throws InvalidRequestException {
            return new InMarker(this.bindIndex, INRaw.makeInReceiver(receivers));
        }

        @Override
        public AbstractMarker prepare(ColumnSpecification receiver) {
            throw new AssertionError((Object)"Tuples.INRaw.prepare() requires a list of receivers");
        }
    }

    public static class Raw
    extends AbstractMarker.Raw
    implements Term.MultiColumnRaw {
        public Raw(int bindIndex) {
            super(bindIndex);
        }

        private static ColumnSpecification makeReceiver(List<? extends ColumnSpecification> receivers) throws InvalidRequestException {
            ArrayList types = new ArrayList(receivers.size());
            StringBuilder inName = new StringBuilder("(");
            for (int i = 0; i < receivers.size(); ++i) {
                ColumnSpecification receiver = receivers.get(i);
                inName.append(receiver.name);
                if (i < receivers.size() - 1) {
                    inName.append(",");
                }
                types.add(receiver.type);
            }
            inName.append(')');
            ColumnIdentifier identifier = new ColumnIdentifier(inName.toString(), true);
            TupleType type = new TupleType(types);
            return new ColumnSpecification(receivers.get((int)0).ksName, receivers.get((int)0).cfName, identifier, type);
        }

        @Override
        public AbstractMarker prepare(List<? extends ColumnSpecification> receivers) throws InvalidRequestException {
            return new Marker(this.bindIndex, Raw.makeReceiver(receivers));
        }

        @Override
        public AbstractMarker prepare(ColumnSpecification receiver) {
            throw new AssertionError((Object)"Tuples.Raw.prepare() requires a list of receivers");
        }
    }

    public static class InValue
    extends Term.Terminal {
        List<List<ByteBuffer>> elements;

        public InValue(List<List<ByteBuffer>> items) {
            this.elements = items;
        }

        public static InValue fromSerialized(ByteBuffer value, ListType type) throws InvalidRequestException {
            try {
                List l = (List)type.compose(value);
                assert (type.elements instanceof TupleType);
                TupleType tupleType = (TupleType)type.elements;
                ArrayList<List<ByteBuffer>> elements = new ArrayList<List<ByteBuffer>>(l.size());
                for (Object element : l) {
                    elements.add(Arrays.asList(tupleType.split(type.elements.decompose(element))));
                }
                return new InValue(elements);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get() {
            throw new UnsupportedOperationException();
        }

        public List<List<ByteBuffer>> getSplitValues() {
            return this.elements;
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        public final List<Term> elements;

        public DelayedValue(List<Term> elements) {
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            for (Term term : this.elements) {
                if (!term.containsBindMarker()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            for (Term term : this.elements) {
                term.collectMarkerSpecification(boundNames);
            }
        }

        @Override
        public Value bind(List<ByteBuffer> values) throws InvalidRequestException {
            ByteBuffer[] buffers = new ByteBuffer[this.elements.size()];
            for (int i = 0; i < this.elements.size(); ++i) {
                ByteBuffer bytes = this.elements.get(i).bindAndGet(values);
                if (bytes == null) {
                    throw new InvalidRequestException("Tuples may not contain null values");
                }
                buffers[i] = this.elements.get(i).bindAndGet(values);
            }
            return new Value(buffers);
        }

        public String toString() {
            return Tuples.tupleToString(this.elements);
        }
    }

    public static class Value
    extends Term.MultiItemTerminal {
        public final ByteBuffer[] elements;

        public Value(ByteBuffer[] elements) {
            this.elements = elements;
        }

        public static Value fromSerialized(ByteBuffer bytes, TupleType type) {
            return new Value(type.split(bytes));
        }

        @Override
        public ByteBuffer get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ByteBuffer> getElements() {
            return Arrays.asList(this.elements);
        }
    }

    public static class Literal
    implements Term.MultiColumnRaw {
        private final List<Term.Raw> elements;

        public Literal(List<Term.Raw> elements) {
            this.elements = elements;
        }

        @Override
        public Term prepare(List<? extends ColumnSpecification> receivers) throws InvalidRequestException {
            if (this.elements.size() != receivers.size()) {
                throw new InvalidRequestException(String.format("Expected %d elements in value tuple, but got %d: %s", receivers.size(), this.elements.size(), this));
            }
            ArrayList<Term> values = new ArrayList<Term>(this.elements.size());
            boolean allTerminal = true;
            for (int i = 0; i < this.elements.size(); ++i) {
                Term t = this.elements.get(i).prepare(receivers.get(i));
                if (t instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(t);
            }
            DelayedValue value = new DelayedValue(values);
            return allTerminal ? value.bind(Collections.emptyList()) : value;
        }

        @Override
        public Term prepare(ColumnSpecification receiver) {
            throw new AssertionError((Object)"Tuples.Literal instances require a list of receivers for prepare()");
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            return false;
        }

        public String toString() {
            return Tuples.tupleToString(this.elements);
        }
    }
}

