/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Auth;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.DataResource;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.IResource;
import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Permission;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.AuthorizationStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import java.util.Set;

public abstract class PermissionAlteringStatement
extends AuthorizationStatement {
    protected final Set<Permission> permissions;
    protected DataResource resource;
    protected final String username;

    protected PermissionAlteringStatement(Set<Permission> permissions, IResource resource, String username) {
        this.permissions = permissions;
        this.resource = (DataResource)resource;
        this.username = username;
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (!Auth.isExistingUser(this.username)) {
            throw new InvalidRequestException(String.format("User %s doesn't exist", this.username));
        }
        this.resource = PermissionAlteringStatement.maybeCorrectResource(this.resource, state);
        if (!this.resource.exists()) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.resource));
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.ensureHasPermission(Permission.AUTHORIZE, this.resource);
        for (Permission p : this.permissions) {
            state.ensureHasPermission(p, this.resource);
        }
    }
}

