/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.CounterMutationSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.IMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SliceByNamesReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.NamesQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.HeapAllocator;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;

public class CounterMutation
implements IMutation {
    public static final CounterMutationSerializer serializer = new CounterMutationSerializer();
    private final RowMutation rowMutation;
    private final ConsistencyLevel consistency;

    public CounterMutation(RowMutation rowMutation, ConsistencyLevel consistency) {
        this.rowMutation = rowMutation;
        this.consistency = consistency;
    }

    @Override
    public String getKeyspaceName() {
        return this.rowMutation.getKeyspaceName();
    }

    @Override
    public Collection<UUID> getColumnFamilyIds() {
        return this.rowMutation.getColumnFamilyIds();
    }

    @Override
    public Collection<ColumnFamily> getColumnFamilies() {
        return this.rowMutation.getColumnFamilies();
    }

    @Override
    public ByteBuffer key() {
        return this.rowMutation.key();
    }

    public RowMutation rowMutation() {
        return this.rowMutation;
    }

    public ConsistencyLevel consistency() {
        return this.consistency;
    }

    public RowMutation makeReplicationMutation() {
        LinkedList<ReadCommand> readCommands = new LinkedList<ReadCommand>();
        long timestamp = System.currentTimeMillis();
        for (ColumnFamily columnFamily : this.rowMutation.getColumnFamilies()) {
            if (!columnFamily.metadata().getReplicateOnWrite()) continue;
            this.addReadCommandFromColumnFamily(this.rowMutation.getKeyspaceName(), this.rowMutation.key(), columnFamily, timestamp, readCommands);
        }
        RowMutation replicationMutation = new RowMutation(this.rowMutation.getKeyspaceName(), this.rowMutation.key());
        for (ReadCommand readCommand : readCommands) {
            Keyspace keyspace;
            Row row = readCommand.getRow(keyspace = Keyspace.open(readCommand.ksName));
            if (row == null || row.cf == null) continue;
            ColumnFamily cf = row.cf;
            replicationMutation.add(cf);
        }
        return replicationMutation.isEmpty() ? null : replicationMutation;
    }

    private void addReadCommandFromColumnFamily(String keyspaceName, ByteBuffer key, ColumnFamily columnFamily, long timestamp, List<ReadCommand> commands) {
        TreeSet<ByteBuffer> s = new TreeSet<ByteBuffer>(columnFamily.metadata().comparator);
        Iterables.addAll(s, columnFamily.getColumnNames());
        commands.add(new SliceByNamesReadCommand(keyspaceName, key, columnFamily.metadata().cfName, timestamp, new NamesQueryFilter(s)));
    }

    public MessageOut<CounterMutation> makeMutationMessage() {
        return new MessageOut<CounterMutation>(MessagingService.Verb.COUNTER_MUTATION, this, serializer);
    }

    public boolean shouldReplicateOnWrite() {
        for (ColumnFamily cf : this.rowMutation.getColumnFamilies()) {
            if (!cf.metadata().getReplicateOnWrite()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply() {
        RowMutation rm = new RowMutation(this.rowMutation.getKeyspaceName(), ByteBufferUtil.clone(this.rowMutation.key()));
        Keyspace keyspace = Keyspace.open(rm.getKeyspaceName());
        for (ColumnFamily cf_ : this.rowMutation.getColumnFamilies()) {
            ColumnFamily cf = cf_.cloneMeShallow();
            ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(cf.id());
            for (Column column : cf_) {
                cf.addColumn(column.localCopy(cfs), HeapAllocator.instance);
            }
            rm.add(cf);
        }
        rm.apply();
    }

    @Override
    public void addAll(IMutation m) {
        if (!(m instanceof CounterMutation)) {
            throw new IllegalArgumentException();
        }
        CounterMutation cm = (CounterMutation)m;
        this.rowMutation.addAll(cm.rowMutation);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("CounterMutation(");
        buff.append(this.rowMutation.toString(shallow));
        buff.append(", ").append(this.consistency.toString());
        return buff.append(")").toString();
    }
}

