/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.index.composites;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.ColumnDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnNameBuilder;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.SecondaryIndex;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.composites.CompositesIndex;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CompositesIndexOnRegular
extends CompositesIndex {
    public static CompositeType buildIndexComparator(CFMetaData baseMetadata, ColumnDefinition columnDef) {
        int prefixSize = columnDef.componentIndex;
        ArrayList types = new ArrayList(prefixSize + 1);
        types.add(SecondaryIndex.keyComparator);
        for (int i = 0; i < prefixSize; ++i) {
            types.add(((CompositeType)baseMetadata.comparator).types.get(i));
        }
        return CompositeType.getInstance(types);
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Column column) {
        return column.value();
    }

    @Override
    protected ColumnNameBuilder makeIndexColumnNameBuilder(ByteBuffer rowKey, ByteBuffer columnName) {
        CompositeType baseComparator = (CompositeType)this.baseCfs.getComparator();
        ByteBuffer[] components = baseComparator.split(columnName);
        CompositeType.Builder builder = this.getIndexComparator().builder();
        builder.add(rowKey);
        for (int i = 0; i < Math.min(this.columnDef.componentIndex, components.length); ++i) {
            builder.add(components[i]);
        }
        return builder;
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Column indexEntry) {
        ByteBuffer[] components = this.getIndexComparator().split(indexEntry.name());
        CompositeType.Builder builder = this.getBaseComparator().builder();
        for (int i = 0; i < this.columnDef.componentIndex; ++i) {
            builder.add(components[i + 1]);
        }
        return new CompositesIndex.IndexedEntry(indexedValue, indexEntry.name(), indexEntry.timestamp(), components[0], builder);
    }

    @Override
    public boolean indexes(ByteBuffer name) {
        ByteBuffer[] components = this.getBaseComparator().split(name);
        AbstractType<?> comp = this.baseCfs.metadata.getColumnDefinitionComparator(this.columnDef);
        return components.length > this.columnDef.componentIndex && comp.compare(components[this.columnDef.componentIndex], this.columnDef.name) == 0;
    }

    @Override
    public boolean isStale(CompositesIndex.IndexedEntry entry, ColumnFamily data, long now) {
        ByteBuffer bb = entry.indexedEntryNameBuilder.copy().add(this.columnDef.name).build();
        Column liveColumn = data.getColumn(bb);
        if (liveColumn == null || liveColumn.isMarkedForDelete(now)) {
            return true;
        }
        ByteBuffer liveValue = liveColumn.value();
        return this.columnDef.getValidator().compare(entry.indexValue.key, liveValue) != 0;
    }
}

