/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.index.keys;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.SecondaryIndexSearcher;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.keys.KeysSearcher;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import java.nio.ByteBuffer;
import java.util.Set;

public class KeysIndex
extends AbstractSimplePerColumnSecondaryIndex {
    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Column column) {
        return column.value();
    }

    @Override
    protected ByteBuffer makeIndexColumnName(ByteBuffer rowKey, Column column) {
        return rowKey;
    }

    @Override
    public SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ByteBuffer> columns) {
        return new KeysSearcher(this.baseCfs.indexManager, columns);
    }

    public boolean isIndexEntryStale(ByteBuffer indexedValue, ColumnFamily data, long now) {
        Column liveColumn = data.getColumn(this.columnDef.name);
        if (liveColumn == null || liveColumn.isMarkedForDelete(now)) {
            return true;
        }
        ByteBuffer liveValue = liveColumn.value();
        return this.columnDef.getValidator().compare(indexedValue, liveValue) != 0;
    }

    @Override
    public void validateOptions() throws ConfigurationException {
    }

    @Override
    protected AbstractType getExpressionComparator() {
        return this.baseCfs.getComparator();
    }
}

