/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQL3Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.InetAddressSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class InetAddressType
extends AbstractType<InetAddress> {
    public static final InetAddressType instance = new InetAddressType();

    InetAddressType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        InetAddress address;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            address = InetAddress.getByName(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make inetaddress from '%s'", source), e);
        }
        return this.decompose(address);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.INET;
    }

    @Override
    public TypeSerializer<InetAddress> getSerializer() {
        return InetAddressSerializer.instance;
    }
}

